/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import org.astrogrid.samp.gui.Transmission;
import org.astrogrid.samp.gui.TransmissionPanel;
import org.astrogrid.samp.gui.TransmissionTableModel;

class TransmissionView
extends JPanel {
    public TransmissionView(final TransmissionTableModel transModel) {
        super(new BorderLayout());
        final TransmissionPanel transPanel = new TransmissionPanel();
        transPanel.setBorder(BorderFactory.createBevelBorder(1));
        final JTable table = new JTable(transModel);
        Dimension tableSize = table.getPreferredScrollableViewportSize();
        tableSize.height = 80;
        table.setPreferredScrollableViewportSize(tableSize);
        DefaultTableColumnModel tcolModel = new DefaultTableColumnModel();
        for (int icol = 0; icol < transModel.getColumnCount(); ++icol) {
            tcolModel.addColumn(transModel.getTableColumn(icol));
        }
        table.setColumnModel(tcolModel);
        final ListSelectionModel selModel = table.getSelectionModel();
        selModel.setSelectionMode(0);
        selModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Object src = evt.getSource();
                if (!selModel.getValueIsAdjusting() && !selModel.isSelectionEmpty()) {
                    Transmission trans = transModel.getTransmission(table.getSelectedRow());
                    transPanel.setTransmission(trans);
                }
            }
        });
        JSplitPane splitter = new JSplitPane(0);
        this.add((Component)splitter, "Center");
        splitter.setTopComponent(new JScrollPane(table));
        splitter.setBottomComponent(transPanel);
        Dimension splitSize = splitter.getPreferredSize();
        splitSize.height = 180;
        splitter.setPreferredSize(splitSize);
    }
}

