/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;

class HubCallableClient
implements CallableClient {
    private final HubConnection connection_;
    private final AbstractMessageHandler[] handlers_;

    public HubCallableClient(HubConnection connection, AbstractMessageHandler[] handlers) {
        this.connection_ = connection;
        this.handlers_ = handlers;
    }

    public void receiveCall(String senderId, String msgId, Message msg) throws SampException {
        msg.check();
        this.getHandler(msg.getMType()).receiveCall(this.connection_, senderId, msgId, msg);
    }

    public void receiveNotification(String senderId, Message msg) throws SampException {
        msg.check();
        this.getHandler(msg.getMType()).receiveNotification(this.connection_, senderId, msg);
    }

    public void receiveResponse(String responderId, String msgTag, Response response) throws SampException {
    }

    public Subscriptions getSubscriptions() {
        Subscriptions subs = new Subscriptions();
        for (int i = 0; i < this.handlers_.length; ++i) {
            subs.putAll(this.handlers_[i].getSubscriptions());
        }
        return subs;
    }

    private AbstractMessageHandler getHandler(String mtype) throws SampException {
        for (int i = 0; i < this.handlers_.length; ++i) {
            AbstractMessageHandler handler = this.handlers_[i];
            if (!Subscriptions.asSubscriptions(handler.getSubscriptions()).isSubscribed(mtype)) continue;
            return handler;
        }
        throw new SampException("Not subscribed to " + mtype);
    }
}

