/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.test.TestException;
import org.astrogrid.samp.test.Tester;
import org.astrogrid.samp.xmlrpc.internal.InternalClient;
import org.astrogrid.samp.xmlrpc.internal.XmlUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class TestXmlrpcClient
extends InternalClient {
    public static final Object SUCCESS = "Success";
    public static final Object FAILURE = "Failure";

    TestXmlrpcClient(URL endpoint) {
        super(endpoint);
    }

    protected Object deserializeResponse(InputStream in) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            Element topEl = XmlUtils.getChild(doc, "methodResponse");
            Element contentEl = XmlUtils.getChild(topEl);
            String contentTag = contentEl.getTagName();
            if ("params".equals(contentTag)) {
                Element paramEl = XmlUtils.getChild(contentEl, "param");
                Element valueEl = XmlUtils.getChild(paramEl, "value");
                Object value = XmlUtils.parseSampValue(valueEl);
                SampUtils.checkObject(value);
                return SUCCESS;
            }
            if ("fault".equals(contentTag)) {
                Element valueEl = XmlUtils.getChild(contentEl, "value");
                Map value = (Map)XmlUtils.parseSampValue(valueEl);
                String faultString = (String)value.get("faultString");
                int faultCode = (Integer)value.get("faultCode");
                Tester.assertEquals(2, value.size());
                return FAILURE;
            }
            throw new TestException("Unknown <methodResponse> child: " + contentTag);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("Trouble with XML parsing").initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Trouble with XML parsing").initCause(e);
        }
        catch (DOMException e) {
            throw (IOException)new IOException("Trouble with XML parsing").initCause(e);
        }
    }

    public void checkSuccessCall(String method, List params) throws IOException {
        Tester.assertEquals(SUCCESS, this.callAndWait(method, params));
    }

    public void checkFailureCall(String method, List params) throws IOException {
        Tester.assertEquals(FAILURE, this.callAndWait(method, params));
    }
}

