/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.astrogrid.samp.web.AuthResourceBundle_en;

public class AuthResourceBundle
extends ResourceBundle {
    private final Hashtable map_ = new Hashtable();
    private static final Logger logger_ = Logger.getLogger(AuthResourceBundle.class.getName());
    static /* synthetic */ Class class$java$lang$String;

    public AuthResourceBundle() {
        this(AuthResourceBundle.getDefaultContent());
    }

    protected AuthResourceBundle(Content content) {
        Method[] methods = AuthResourceBundle.getContentMethods();
        Object[] noArgs = new Object[]{};
        for (int im = 0; im < methods.length; ++im) {
            Method method = methods[im];
            String mname = method.getName();
            try {
                this.map_.put(method.getName(), method.invoke((Object)content, noArgs));
                continue;
            }
            catch (IllegalAccessException e) {
                throw (RuntimeException)new RuntimeException("Failed to call method " + method.getName()).initCause(e);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)new RuntimeException("Failed to call method " + method.getName()).initCause(e);
            }
        }
        AuthResourceBundle.checkHasAllKeys(this);
    }

    protected final Object handleGetObject(String key) {
        return this.map_.get(key);
    }

    public final Enumeration getKeys() {
        return this.map_.keys();
    }

    public static Content getAuthContent(final ResourceBundle bundle) {
        try {
            AuthResourceBundle.checkHasAllKeys(bundle);
        }
        catch (MissingResourceException e) {
            logger_.warning("Some keys missing from localised auth resource bundle; using English");
            return AuthResourceBundle.getDefaultContent();
        }
        InvocationHandler ihandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class<?> rclazz;
                String key = method.getName();
                if ((class$java$lang$String == null ? (class$java$lang$String = AuthResourceBundle.class$("java.lang.String")) : class$java$lang$String).equals(rclazz = method.getReturnType())) {
                    return bundle.getString(key);
                }
                throw new RuntimeException("Unsuitable return type " + rclazz.getName() + " (shouldn't happen)");
            }
        };
        return (Content)Proxy.newProxyInstance(AuthResourceBundle.class.getClassLoader(), new Class[]{Content.class}, ihandler);
    }

    static Method[] getContentMethods() {
        return Content.class.getMethods();
    }

    static void checkHasAllKeys(ResourceBundle bundle) {
        HashSet<String> bkeys = new HashSet<String>();
        Enumeration<String> en = bundle.getKeys();
        while (en.hasMoreElements()) {
            bkeys.add(en.nextElement());
        }
        HashSet<String> mnames = new HashSet<String>();
        Method[] methods = AuthResourceBundle.getContentMethods();
        for (int im = 0; im < methods.length; ++im) {
            mnames.add(methods[im].getName());
        }
        mnames.removeAll(bkeys);
        if (!mnames.isEmpty()) {
            throw new MissingResourceException("Missing resources " + mnames, AuthResourceBundle.class.getName(), mnames.iterator().next().toString());
        }
    }

    private static Content getDefaultContent() {
        return new AuthResourceBundle_en.EnglishContent();
    }

    private static String toPropertyString(Content content, Method method) {
        try {
            String value = (String)method.invoke((Object)content, new Object[0]);
            value = value.replaceAll("\n", "\\\\n");
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(method.getName()).append('=');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\n') {
                    sbuf.append("\\n");
                    continue;
                }
                if (c >= ' ' && c < '\u0080') {
                    sbuf.append(c);
                    continue;
                }
                String xs = Integer.toHexString(c);
                sbuf.append("\\u");
                for (int j = xs.length(); j < 4; ++j) {
                    sbuf.append('0');
                }
                sbuf.append(xs);
            }
            return sbuf.toString();
        }
        catch (IllegalAccessException e) {
            throw (RuntimeException)new RuntimeException("Failed to call method " + method.getName()).initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)new RuntimeException("Failed to call method " + method.getName()).initCause(e);
        }
    }

    public static void main(String[] args) {
        ResourceBundle lBundle = ResourceBundle.getBundle(AuthResourceBundle.class.getName());
        Content lContent = AuthResourceBundle.getAuthContent(lBundle);
        Content dContent = AuthResourceBundle.getDefaultContent();
        Method[] methods = AuthResourceBundle.getContentMethods();
        System.out.println("# Template for " + AuthResourceBundle.class.getName() + "_xx.properties file,");
        System.out.println("# giving localised text for Web Profile client authorization dialogue.");
        System.out.println("# Please fill in language-specific values for each key, as in the example.");
        System.out.println("# Follow the capitalization and punctuation of the English version.");
        System.out.println("# Long lines should be broken up with return characters (\\n).");
        System.out.println("# Encoding is ISO 8859-1; see java.util.Properties docs for detailed syntax.");
        System.out.println("#");
        System.out.println("# Alternatively, implement " + AuthResourceBundle.class.getName() + "_xx");
        System.out.println("# using " + AuthResourceBundle_en.class.getName() + " as an example.");
        System.out.println();
        for (int im = 0; im < methods.length; ++im) {
            Method method = methods[im];
            System.out.println("# " + AuthResourceBundle.toPropertyString(dContent, method));
            System.out.println(AuthResourceBundle.toPropertyString(lContent, method));
        }
    }

    public static interface Content {
        public String windowTitle();

        public String appIntroductionLines();

        public String nameWord();

        public String originWord();

        public String undeclaredWord();

        public String privilegeWarningLines();

        public String adviceLines();

        public String questionLine();

        public String yesWord();

        public String noWord();
    }
}

