/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.web.UrlTracker;

class UrlTrackerHubConnection
implements HubConnection {
    private final HubConnection base_;
    private final UrlTracker urlTracker_;

    public UrlTrackerHubConnection(HubConnection base, UrlTracker urlTracker) {
        this.base_ = base;
        this.urlTracker_ = urlTracker;
    }

    private Map scanIncoming(Map map) {
        URL[] urls = this.scanForUrls(map);
        for (int iu = 0; iu < urls.length; ++iu) {
            this.urlTracker_.noteIncomingUrl(urls[iu]);
        }
        return map;
    }

    private Map scanOutgoing(Map map) {
        URL[] urls = this.scanForUrls(map);
        for (int iu = 0; iu < urls.length; ++iu) {
            this.urlTracker_.noteOutgoingUrl(urls[iu]);
        }
        return map;
    }

    private URL[] scanForUrls(Map map) {
        HashSet urlSet = new HashSet();
        this.scanForUrls(map, urlSet);
        return urlSet.toArray(new URL[0]);
    }

    private void scanForUrls(Object item, Collection urlSet) {
        block8: {
            block7: {
                if (!(item instanceof String)) break block7;
                if (!this.isUrl((String)item)) break block8;
                try {
                    urlSet.add(new URL((String)item));
                }
                catch (MalformedURLException malformedURLException) {}
                break block8;
            }
            if (item instanceof List) {
                Iterator it = ((List)item).iterator();
                while (it.hasNext()) {
                    this.scanForUrls(it.next(), urlSet);
                }
            } else if (item instanceof Map) {
                Iterator it = ((Map)item).values().iterator();
                while (it.hasNext()) {
                    this.scanForUrls(it.next(), urlSet);
                }
            }
        }
    }

    private boolean isUrl(String str) {
        if (str == null || str.indexOf(":/") <= 0) {
            return false;
        }
        try {
            new URL(str);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setCallable(CallableClient callable) throws SampException {
        this.base_.setCallable(new UrlTrackerCallableClient(callable));
    }

    public void notify(String recipientId, Map msg) throws SampException {
        this.base_.notify(recipientId, this.scanOutgoing(msg));
    }

    public List notifyAll(Map msg) throws SampException {
        return this.base_.notifyAll(this.scanOutgoing(msg));
    }

    public String call(String recipientId, String msgTag, Map msg) throws SampException {
        return this.base_.call(recipientId, msgTag, this.scanOutgoing(msg));
    }

    public Map callAll(String msgTag, Map msg) throws SampException {
        return this.base_.callAll(msgTag, this.scanOutgoing(msg));
    }

    public Response callAndWait(String recipientId, Map msg, int timeout) throws SampException {
        return (Response)this.scanIncoming(this.base_.callAndWait(recipientId, this.scanOutgoing(msg), timeout));
    }

    public void reply(String msgId, Map response) throws SampException {
        this.base_.reply(msgId, this.scanOutgoing(response));
    }

    public RegInfo getRegInfo() {
        return (RegInfo)this.scanIncoming(this.base_.getRegInfo());
    }

    public void ping() throws SampException {
        this.base_.ping();
    }

    public void unregister() throws SampException {
        this.base_.unregister();
    }

    public void declareMetadata(Map meta) throws SampException {
        this.base_.declareMetadata(this.scanOutgoing(meta));
    }

    public Metadata getMetadata(String clientId) throws SampException {
        return (Metadata)this.scanIncoming(this.base_.getMetadata(clientId));
    }

    public void declareSubscriptions(Map subs) throws SampException {
        this.base_.declareSubscriptions(this.scanOutgoing(subs));
    }

    public Subscriptions getSubscriptions(String clientId) throws SampException {
        return (Subscriptions)this.scanIncoming(this.base_.getSubscriptions(clientId));
    }

    public String[] getRegisteredClients() throws SampException {
        return this.base_.getRegisteredClients();
    }

    public Map getSubscribedClients(String mtype) throws SampException {
        return this.scanIncoming(this.base_.getSubscribedClients(mtype));
    }

    private class UrlTrackerCallableClient
    implements CallableClient {
        private final CallableClient baseCallable_;

        UrlTrackerCallableClient(CallableClient baseCallable) {
            this.baseCallable_ = baseCallable;
        }

        public void receiveCall(String senderId, String msgId, Message msg) throws Exception {
            this.baseCallable_.receiveCall(senderId, msgId, (Message)UrlTrackerHubConnection.this.scanIncoming(msg));
        }

        public void receiveNotification(String senderId, Message msg) throws Exception {
            this.baseCallable_.receiveNotification(senderId, (Message)UrlTrackerHubConnection.this.scanIncoming(msg));
        }

        public void receiveResponse(String responderId, String msgTag, Response response) throws Exception {
            this.baseCallable_.receiveResponse(responderId, msgTag, (Response)UrlTrackerHubConnection.this.scanIncoming(response));
        }
    }
}

