/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.ServerResource;
import org.astrogrid.samp.httpd.UtilServer;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.KeyGenerator;
import org.astrogrid.samp.hub.LockWriter;
import org.astrogrid.samp.hub.MessageRestriction;
import org.astrogrid.samp.hub.ProfileToken;
import org.astrogrid.samp.xmlrpc.HubMode;
import org.astrogrid.samp.xmlrpc.HubXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.LockInfo;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class HubRunner {
    private final SampXmlRpcClientFactory xClientFactory_;
    private final SampXmlRpcServerFactory xServerFactory_;
    private final HubService hub_;
    private final File lockfile_;
    private URL lockUrl_;
    private LockInfo lockInfo_;
    private SampXmlRpcServer server_;
    private HubXmlRpcHandler hubHandler_;
    private boolean shutdown_;
    private static final ProfileToken STANDARD_PROFILE;
    private static final Logger logger_;
    private static final Random random_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HubRunner(SampXmlRpcClientFactory xClientFactory, SampXmlRpcServerFactory xServerFactory, HubService hub, File lockfile) {
        this.xClientFactory_ = xClientFactory;
        this.xServerFactory_ = xServerFactory;
        this.hub_ = hub;
        this.lockfile_ = lockfile;
        logger_.warning("Class " + HubRunner.class.getName() + " is deprecated; use " + Hub.class.getName() + " instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.lockfile_ != null && this.lockfile_.exists()) {
            if (HubRunner.isHubAlive(this.xClientFactory_, this.lockfile_)) {
                throw new IOException("A hub is already running");
            }
            logger_.warning("Overwriting " + this.lockfile_ + " lockfile for apparently dead hub");
            this.lockfile_.delete();
        }
        try {
            this.server_ = this.xServerFactory_.getServer();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Can't start XML-RPC server").initCause(e);
        }
        this.hub_.start();
        String secret = this.createSecret();
        ClientProfile connectionFactory = new ClientProfile(){

            public HubConnection register() throws SampException {
                return HubRunner.this.hub_.register(STANDARD_PROFILE);
            }

            public boolean isHubRunning() {
                return HubRunner.this.hub_.isHubRunning();
            }
        };
        this.hubHandler_ = new HubXmlRpcHandler(this.xClientFactory_, connectionFactory, secret, new KeyGenerator("k:", 16, random_));
        this.server_.addHandler(this.hubHandler_);
        Runtime.getRuntime().addShutdownHook(new Thread("HubRunner shutdown"){

            public void run() {
                HubRunner.this.shutdown();
            }
        });
        this.lockInfo_ = new LockInfo(secret, this.server_.getEndpoint().toString());
        this.lockInfo_.put("hub.impl", this.hub_.getClass().getName());
        this.lockInfo_.put("hub.start.date", new Date().toString());
        if (this.lockfile_ != null) {
            logger_.info("Writing new lockfile " + this.lockfile_);
            FileOutputStream out = new FileOutputStream(this.lockfile_);
            try {
                HubRunner.writeLockInfo(this.lockInfo_, out);
                try {
                    LockWriter.setLockPermissions(this.lockfile_);
                    logger_.info("Lockfile permissions set to user access only");
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Failed attempt to change " + this.lockfile_ + " permissions to user access only - possible security implications", e);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Error closing lockfile?", e);
                }
            }
        }
    }

    public synchronized void shutdown() {
        block15: {
            if (this.shutdown_) {
                return;
            }
            this.shutdown_ = true;
            if (this.lockfile_ != null) {
                if (this.lockfile_.exists()) {
                    try {
                        LockInfo lockInfo = HubRunner.readLockFile(this.lockfile_);
                        if (lockInfo.getSecret().equals(this.lockInfo_.getSecret())) {
                            if (!$assertionsDisabled && !lockInfo.equals(this.lockInfo_)) {
                                throw new AssertionError();
                            }
                            boolean deleted = this.lockfile_.delete();
                            logger_.info("Lockfile " + this.lockfile_ + " " + (deleted ? "deleted" : "deletion attempt failed"));
                            break block15;
                        }
                        logger_.warning("Lockfile " + this.lockfile_ + " has been  overwritten - not deleting");
                    }
                    catch (Throwable e) {
                        logger_.log(Level.WARNING, "Failed to delete lockfile " + this.lockfile_, e);
                    }
                } else {
                    logger_.warning("Lockfile " + this.lockfile_ + " has disappeared");
                }
            }
        }
        if (this.lockUrl_ != null) {
            try {
                UtilServer.getInstance().getResourceHandler().removeResource(this.lockUrl_);
            }
            catch (IOException e) {
                logger_.warning("Failed to withdraw lockfile URL");
            }
            this.lockUrl_ = null;
        }
        if (this.hub_ != null) {
            try {
                this.hub_.shutdown();
            }
            catch (Throwable e) {
                logger_.log(Level.WARNING, "Hub service shutdown failed", e);
            }
        }
        if (this.hubHandler_ != null && this.server_ != null) {
            this.server_.removeHandler(this.hubHandler_);
            this.server_ = null;
        }
        this.lockInfo_ = null;
    }

    public HubService getHub() {
        return this.hub_;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo_;
    }

    public URL publishLockfile() throws IOException {
        if (this.lockUrl_ == null) {
            ByteArrayOutputStream infoStrm = new ByteArrayOutputStream();
            HubRunner.writeLockInfo(this.lockInfo_, infoStrm);
            infoStrm.close();
            final byte[] infoBuf = infoStrm.toByteArray();
            URL url = UtilServer.getInstance().getResourceHandler().addResource("samplock", new ServerResource(){

                public long getContentLength() {
                    return infoBuf.length;
                }

                public String getContentType() {
                    return "text/plain";
                }

                public void writeBody(OutputStream out) throws IOException {
                    out.write(infoBuf);
                }
            });
            try {
                url = new URL(url.getProtocol(), InetAddress.getLocalHost().getCanonicalHostName(), url.getPort(), url.getFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lockUrl_ = url;
        }
        return this.lockUrl_;
    }

    public String createSecret() {
        return Long.toHexString(random_.nextLong());
    }

    private static boolean isHubAlive(SampXmlRpcClientFactory xClientFactory, File lockfile) {
        LockInfo info;
        try {
            info = HubRunner.readLockFile(lockfile);
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Failed to read lockfile", e);
            return false;
        }
        if (info == null) {
            return false;
        }
        URL xurl = info.getXmlrpcUrl();
        if (xurl != null) {
            try {
                xClientFactory.createClient(xurl).callAndWait("samp.hub.ping", new ArrayList());
                return true;
            }
            catch (Exception e) {
                logger_.log(Level.WARNING, "Hub ping method failed", e);
                return false;
            }
        }
        logger_.warning("No XMLRPC URL in lockfile");
        return false;
    }

    private static LockInfo readLockFile(File lockFile) throws IOException {
        return LockInfo.readLockFile(new FileInputStream(lockFile));
    }

    private static void writeLockInfo(LockInfo info, OutputStream out) throws IOException {
        LockWriter writer = new LockWriter(out);
        writer.writeComment("SAMP Standard Profile lockfile written " + new Date());
        writer.writeComment("Note contact URL hostname may be configured using jsamp.localhost property");
        writer.writeAssignments(info);
        out.flush();
    }

    public static void main(String[] args) throws IOException {
        int status = HubRunner.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runMain(String[] args) throws IOException {
        File lockfile;
        StringBuffer ubuf = new StringBuffer();
        ubuf.append("\n   Usage:").append("\n      ").append(HubRunner.class.getName()).append("\n           ").append(" [-help]").append(" [-/+verbose]").append("\n           ").append(" [-mode ");
        HubMode[] modes = HubMode.getAvailableModes();
        for (int im = 0; im < modes.length; ++im) {
            if (im > 0) {
                ubuf.append('|');
            }
            ubuf.append(modes[im].getName());
        }
        ubuf.append(']').append(" [-secret <secret>]").append(" [-httplock]").append("\n");
        String usage = ubuf.toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        HubMode hubMode = HubMode.MESSAGE_GUI;
        if (!Arrays.asList(HubMode.getAvailableModes()).contains(hubMode)) {
            hubMode = HubMode.NO_GUI;
        }
        int verbAdjust = 0;
        XmlRpcKit xmlrpc = null;
        String secret = null;
        boolean httplock = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-mode") && it.hasNext()) {
                it.remove();
                String mode = (String)it.next();
                it.remove();
                hubMode = HubMode.getModeFromName(mode);
                if (hubMode != null) continue;
                System.err.println("Unknown mode " + mode);
                System.err.println(usage);
                return 1;
            }
            if (arg.equals("-secret") && it.hasNext()) {
                it.remove();
                secret = (String)it.next();
                it.remove();
                continue;
            }
            if (arg.equals("-httplock")) {
                it.remove();
                httplock = true;
                continue;
            }
            if (arg.startsWith("-v")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.startsWith("+v")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        if (httplock) {
            lockfile = null;
        } else {
            URL lockUrl = StandardClientProfile.getLockUrl();
            File f = SampUtils.urlToFile(lockUrl);
            if (f == null) {
                System.err.println("Can't write lockfile to " + lockUrl);
                System.err.println("Try resetting SAMP_HUB environment variable.");
                return 1;
            }
            lockfile = f;
        }
        HubRunner runner = HubRunner.runHub(hubMode, xmlrpc, secret, lockfile);
        URL lockfileUrl = httplock ? runner.publishLockfile() : SampUtils.fileToUrl(lockfile);
        boolean isDflt = StandardClientProfile.getDefaultLockUrl().toString().equals(lockfileUrl.toString());
        String hubassign = "SAMP_HUB=std-lockurl:" + lockfileUrl;
        logger_.log(isDflt ? Level.INFO : Level.WARNING, hubassign);
        if (hubMode.isDaemon()) {
            String lock;
            String string = lock = new String("Indefinite");
            synchronized (string) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public static HubRunner runHub(HubMode hubMode, XmlRpcKit xmlrpc) throws IOException {
        return HubRunner.runHub(hubMode, xmlrpc, null, SampUtils.urlToFile(StandardClientProfile.getLockUrl()));
    }

    public static HubRunner runHub(HubMode hubMode, XmlRpcKit xmlrpc, final String secret, File lockfile) throws IOException {
        HubRunner[] hubRunners;
        HubRunner runner;
        if (xmlrpc == null) {
            xmlrpc = XmlRpcKit.getInstance();
        }
        hubRunners = new HubRunner[]{runner = new HubRunner(xmlrpc.getClientFactory(), xmlrpc.getServerFactory(), hubMode.createHubService(random_, hubRunners), lockfile){

            public String createSecret() {
                return secret == null ? super.createSecret() : secret;
            }
        }};
        runner.start();
        return runner;
    }

    public static void runExternalHub(HubMode hubMode) throws IOException {
        String classpath = System.getProperty("java.class.path");
        if (classpath == null || classpath.trim().length() == 0) {
            throw new IOException("No classpath available - JNLP context?");
        }
        File javaHome = new File(System.getProperty("java.home"));
        File javaExec = new File(new File(javaHome, "bin"), "java");
        String javacmd = javaExec.exists() && !javaExec.isDirectory() ? javaExec.toString() : "java";
        String[] propagateProps = new String[]{"jsamp.xmlrpc.impl", "jsamp.server.port", "jsamp.localhost", "java.awt.Window.locationByPlatform"};
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(javacmd);
        for (int ip = 0; ip < propagateProps.length; ++ip) {
            String propName = propagateProps[ip];
            String propVal = System.getProperty(propName);
            if (propVal == null) continue;
            argList.add("-D" + propName + "=" + propVal);
        }
        argList.add("-classpath");
        argList.add(classpath);
        argList.add(HubRunner.class.getName());
        argList.add("-mode");
        argList.add(hubMode.toString());
        String[] args = argList.toArray(new String[0]);
        StringBuffer cmdbuf = new StringBuffer();
        for (int iarg = 0; iarg < args.length; ++iarg) {
            if (iarg > 0) {
                cmdbuf.append(' ');
            }
            cmdbuf.append(args[iarg]);
        }
        logger_.info("Starting external hub");
        logger_.info(cmdbuf.toString());
        HubRunner.execBackground(args);
    }

    public static void checkExternalHubAvailability() throws IOException {
        String classpath = System.getProperty("java.class.path");
        if (classpath == null || classpath.trim().length() == 0) {
            throw new IOException("No classpath available - JNLP context?");
        }
        if (System.getProperty("jnlpx.jvm") != null) {
            throw new IOException("Running under WebStart - external hub not likely to work");
        }
    }

    private static void execBackground(String[] cmdarray) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdarray);
        HubRunner.discardBytes(process.getInputStream());
        HubRunner.discardBytes(process.getErrorStream());
    }

    private static void discardBytes(final InputStream in) {
        Thread eater = new Thread("StreamEater"){

            public void run() {
                try {
                    while (in.read() >= 0) {
                    }
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        eater.setDaemon(true);
        eater.start();
    }

    static {
        $assertionsDisabled = !HubRunner.class.desiredAssertionStatus();
        STANDARD_PROFILE = new ProfileToken(){

            public String getProfileName() {
                return "Standard";
            }

            public MessageRestriction getMessageRestriction() {
                return null;
            }
        };
        logger_ = Logger.getLogger(HubRunner.class.getName());
        random_ = KeyGenerator.createRandom();
    }
}

