/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;

public abstract class XmlRpcKit {
    public static final XmlRpcKit APACHE;
    public static final XmlRpcKit INTERNAL;
    public static final XmlRpcKit XML_LOGGING;
    public static final XmlRpcKit RPC_LOGGING;
    public static XmlRpcKit[] KNOWN_IMPLS;
    public static final String IMPL_PROP = "jsamp.xmlrpc.impl";
    private static XmlRpcKit defaultInstance_;
    private static Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract SampXmlRpcClientFactory getClientFactory();

    public abstract SampXmlRpcServerFactory getServerFactory();

    public abstract boolean isAvailable();

    public abstract String getName();

    public static XmlRpcKit getInstance() {
        if (defaultInstance_ == null) {
            defaultInstance_ = XmlRpcKit.createDefaultInstance();
            logger_.info("Default XmlRpcInstance is " + defaultInstance_);
        }
        return defaultInstance_;
    }

    public static XmlRpcKit getInstanceByName(String name) {
        Class<?> clazz;
        XmlRpcKit[] impls = KNOWN_IMPLS;
        for (int i = 0; i < impls.length; ++i) {
            if (!name.equalsIgnoreCase(impls[i].getName())) continue;
            return impls[i];
        }
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such XML-RPC implementation \"" + name + "\"");
        }
        try {
            return (XmlRpcKit)clazz.newInstance();
        }
        catch (Throwable e) {
            throw (RuntimeException)new IllegalArgumentException("Error instantiating custom XmlRpcKit " + clazz.getName()).initCause(e);
        }
    }

    private static XmlRpcKit createDefaultInstance() {
        XmlRpcKit[] impls = KNOWN_IMPLS;
        String implName = System.getProperty(IMPL_PROP);
        logger_.info("Creating default XmlRpcInstance: jsamp.xmlrpc.impl=" + implName);
        if (implName == null) {
            for (int i = 0; i < impls.length; ++i) {
                if (!impls[i].isAvailable()) continue;
                return impls[i];
            }
            return impls[0];
        }
        return XmlRpcKit.getInstanceByName(implName);
    }

    public static XmlRpcKit createReflectionKit(String name, String clientFactoryClassName, String serverFactoryClassName) {
        SampXmlRpcClientFactory clientFactory = null;
        SampXmlRpcServerFactory serverFactory = null;
        Throwable error = null;
        try {
            clientFactory = (SampXmlRpcClientFactory)Class.forName(clientFactoryClassName).newInstance();
            serverFactory = (SampXmlRpcServerFactory)Class.forName(serverFactoryClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            error = e;
        }
        catch (LinkageError e) {
            error = e;
        }
        catch (InstantiationException e) {
            error = e;
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        if (clientFactory != null && serverFactory != null) {
            if (!$assertionsDisabled && error != null) {
                throw new AssertionError();
            }
            return new AvailableKit(name, clientFactory, serverFactory);
        }
        if (!$assertionsDisabled && error == null) {
            throw new AssertionError();
        }
        return new UnavailableKit(name, error);
    }

    private static XmlRpcKit createApacheKit(String name) {
        XmlRpcKit kit = XmlRpcKit.createReflectionKit(name, "org.astrogrid.samp.xmlrpc.apache.ApacheClientFactory", "org.astrogrid.samp.xmlrpc.apache.ApacheServerFactory");
        if (kit.isAvailable()) {
            try {
                Object version;
                Class<?> xClazz = Class.forName("org.apache.xmlrpc.XmlRpc");
                Field vField = xClazz.getField("version");
                Object object = version = Modifier.isStatic(vField.getModifiers()) ? vField.get(null) : null;
                if (version instanceof String && ((String)version).startsWith("Apache XML-RPC 1.2")) {
                    return kit;
                }
                String msg = "Wrong Apache XML-RPC version: " + version + " not 1.2";
                return new UnavailableKit(name, new ClassNotFoundException(msg));
            }
            catch (Throwable e) {
                return new UnavailableKit(name, e);
            }
        }
        return kit;
    }

    static {
        $assertionsDisabled = !XmlRpcKit.class.desiredAssertionStatus();
        INTERNAL = XmlRpcKit.createReflectionKit("internal", "org.astrogrid.samp.xmlrpc.internal.InternalClientFactory", "org.astrogrid.samp.xmlrpc.internal.InternalServerFactory");
        KNOWN_IMPLS = new XmlRpcKit[]{INTERNAL, XML_LOGGING = XmlRpcKit.createReflectionKit("xml-log", "org.astrogrid.samp.xmlrpc.internal.XmlLoggingInternalClientFactory", "org.astrogrid.samp.xmlrpc.internal.XmlLoggingInternalServerFactory"), RPC_LOGGING = XmlRpcKit.createReflectionKit("rpc-log", "org.astrogrid.samp.xmlrpc.internal.RpcLoggingInternalClientFactory", "org.astrogrid.samp.xmlrpc.internal.RpcLoggingInternalServerFactory"), APACHE = XmlRpcKit.createApacheKit("apache")};
        logger_ = Logger.getLogger(XmlRpcKit.class.getName());
    }

    private static class UnavailableKit
    extends XmlRpcKit {
        private final String name_;
        private final Throwable error_;

        UnavailableKit(String name, Throwable error) {
            this.name_ = name;
            this.error_ = error;
        }

        public SampXmlRpcClientFactory getClientFactory() {
            throw (RuntimeException)new UnsupportedOperationException(this.name_ + " implementation not available").initCause(this.error_);
        }

        public SampXmlRpcServerFactory getServerFactory() {
            throw (RuntimeException)new UnsupportedOperationException(this.name_ + " implementation not available").initCause(this.error_);
        }

        public String getName() {
            return this.name_;
        }

        public boolean isAvailable() {
            return false;
        }

        public String toString() {
            return this.name_;
        }
    }

    private static class AvailableKit
    extends XmlRpcKit {
        private final String name_;
        private final SampXmlRpcClientFactory clientFactory_;
        private final SampXmlRpcServerFactory serverFactory_;

        AvailableKit(String name, SampXmlRpcClientFactory clientFactory, SampXmlRpcServerFactory serverFactory) {
            this.name_ = name;
            this.clientFactory_ = clientFactory;
            this.serverFactory_ = serverFactory;
        }

        public SampXmlRpcClientFactory getClientFactory() {
            return this.clientFactory_;
        }

        public SampXmlRpcServerFactory getServerFactory() {
            return this.serverFactory_;
        }

        public String getName() {
            return this.name_;
        }

        public boolean isAvailable() {
            return true;
        }

        public String toString() {
            return this.name_;
        }
    }
}

