/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.apache;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcHandler;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.xmlrpc.SampXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.apache.ApacheUtils;

public class ApacheServer
implements SampXmlRpcServer {
    private final WebServer webServer_;
    private final URL endpoint_;
    private final List handlerList_;

    private ApacheServer(LabelledServer server) {
        this.webServer_ = server.webServer_;
        this.endpoint_ = server.endpoint_;
        this.handlerList_ = Collections.synchronizedList(new ArrayList());
        this.webServer_.addHandler("$default", new XmlRpcHandler(){

            public Object execute(String method, Vector params) throws Exception {
                return ApacheServer.this.doExecute(method, params);
            }
        });
    }

    public ApacheServer(WebServer webServer, int port) {
        this(new LabelledServer(webServer, ApacheServer.getServerEndpoint(port)));
    }

    public ApacheServer() throws IOException {
        this(ApacheServer.createLabelledServer(true));
        this.webServer_.start();
    }

    public URL getEndpoint() {
        return this.endpoint_;
    }

    public void addHandler(SampXmlRpcHandler handler) {
        this.handlerList_.add(handler);
    }

    public void removeHandler(SampXmlRpcHandler handler) {
        this.handlerList_.remove(handler);
    }

    private Object doExecute(String fqMethod, Vector paramVec) throws Exception {
        SampXmlRpcHandler[] handlers = this.handlerList_.toArray(new SampXmlRpcHandler[0]);
        for (int ih = 0; ih < handlers.length; ++ih) {
            SampXmlRpcHandler handler = handlers[ih];
            if (!handler.canHandleCall(fqMethod)) continue;
            List paramList = (List)ApacheUtils.fromApache(paramVec);
            Object result = handler.handleCall(fqMethod, paramList, null);
            return ApacheUtils.toApache(result);
        }
        throw new UnsupportedOperationException("No handler for method " + fqMethod);
    }

    private static LabelledServer createLabelledServer(final boolean isDaemon) throws IOException {
        int port = SampUtils.getUnusedPort(2300);
        WebServer server = new WebServer(port){

            public void start() {
                if (this.listener == null) {
                    this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
                    this.listener.setDaemon(isDaemon);
                    this.listener.start();
                }
            }
        };
        return new LabelledServer(server, ApacheServer.getServerEndpoint(port));
    }

    private static URL getServerEndpoint(int port) {
        String endpoint = "http://" + SampUtils.getLocalhost() + ":" + port + "/";
        try {
            return new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)("Bad protocol http?? " + endpoint)))).initCause(e);
        }
    }

    private static class LabelledServer {
        private final WebServer webServer_;
        private final URL endpoint_;

        LabelledServer(WebServer webServer, URL endpoint) {
            this.webServer_ = webServer;
            this.endpoint_ = endpoint;
        }
    }
}

