/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.internal.XmlRpcFormatException;
import org.astrogrid.samp.xmlrpc.internal.XmlUtils;
import org.astrogrid.samp.xmlrpc.internal.XmlWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class InternalClient
implements SampXmlRpcClient {
    private final URL endpoint_;
    private final String userAgent_;
    private static final Logger logger_ = Logger.getLogger(InternalClient.class.getName());

    public InternalClient(URL endpoint) {
        this.endpoint_ = endpoint;
        this.userAgent_ = "JSAMP/" + SampUtils.getSoftwareVersion();
    }

    public Object callAndWait(String method, List params) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.endpoint_.openConnection();
        byte[] callBuf = this.serializeCall(method, params);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "text/xml");
        connection.setRequestProperty("Content-Length", Integer.toString(callBuf.length));
        connection.setRequestProperty("User-Agent", this.userAgent_);
        connection.connect();
        OutputStream out = connection.getOutputStream();
        out.write(callBuf);
        out.flush();
        out.close();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException(responseCode + " " + connection.getResponseMessage());
        }
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        Object result = this.deserializeResponse(in);
        connection.disconnect();
        return result;
    }

    public void callAndForget(String method, List params) throws IOException {
        final HttpURLConnection connection = (HttpURLConnection)this.endpoint_.openConnection();
        byte[] callBuf = this.serializeCall(method, params);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "text/xml");
        connection.setRequestProperty("Content-Length", Integer.toString(callBuf.length));
        connection.setRequestProperty("User-Agent", this.userAgent_);
        connection.connect();
        OutputStream out = connection.getOutputStream();
        out.write(callBuf);
        out.flush();
        out.close();
        new Thread(){

            public void run() {
                try {
                    BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                    while (((InputStream)in).read() >= 0) {
                    }
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200) {
                        logger_.warning(responseCode + " " + connection.getResponseMessage());
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    connection.disconnect();
                }
            }
        }.start();
    }

    protected byte[] serializeCall(String method, List paramList) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XmlWriter xout = new XmlWriter(bos, 2);
        xout.start("methodCall");
        xout.inline("methodName", method);
        if (!paramList.isEmpty()) {
            xout.start("params");
            Iterator it = paramList.iterator();
            while (it.hasNext()) {
                xout.start("param");
                xout.sampValue(it.next());
                xout.end("param");
            }
            xout.end("params");
        }
        xout.end("methodCall");
        xout.close();
        return bos.toByteArray();
    }

    protected Object deserializeResponse(InputStream in) throws IOException {
        try {
            Document doc = XmlUtils.createDocumentBuilder().parse(in);
            Element top = XmlUtils.getChild(XmlUtils.getChild(doc, "methodResponse"));
            String topName = top.getTagName();
            if ("fault".equals(topName)) {
                Element value = XmlUtils.getChild(top, "value");
                XmlUtils.getChild(value, "struct");
                Map faultMap = (Map)XmlUtils.parseSampValue(value);
                Object fcode = faultMap.get("faultCode");
                Object fmsg = faultMap.get("faultString");
                int code = fcode instanceof Integer ? (Integer)fcode : -9999;
                String msg = String.valueOf(fmsg);
                throw new XmlRpcFault(code, msg);
            }
            if ("params".equals(topName)) {
                Element value = XmlUtils.getChild(XmlUtils.getChild(top, "param"), "value");
                return XmlUtils.parseSampValue(value);
            }
            throw new XmlRpcFormatException("Not <fault> or <params>?");
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("Trouble with XML parsing").initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Trouble with XML parsing").initCause(e);
        }
        catch (DOMException e) {
            throw (IOException)new IOException("Trouble with XML parsing").initCause(e);
        }
    }

    private static class XmlRpcFault
    extends IOException {
        public XmlRpcFault(int code, String msg) {
            super("XML-RPC Fault (" + code + ": " + msg + ")");
        }
    }
}

