/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import uk.ac.starlink.parquet.Decoder;
import uk.ac.starlink.parquet.InputColumn;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;
import uk.ac.starlink.util.ByteList;
import uk.ac.starlink.util.DoubleList;
import uk.ac.starlink.util.FloatList;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.util.LongList;
import uk.ac.starlink.util.PrimitiveList;
import uk.ac.starlink.util.ShortList;

public class InputColumns {
    public static final byte BAD_BYTE = -128;
    public static final short BAD_SHORT = Short.MIN_VALUE;
    public static final int BAD_INT = Integer.MIN_VALUE;
    public static final long BAD_LONG = Long.MIN_VALUE;
    static final Map<LogicalTypeAnnotation.TimeUnit, TimeMapper> TIME_MAPPERS = InputColumns.createTimeMappers();
    private static final TimeMapper DATE_MAPPER = InputColumns.createUnixDateMapper();

    private InputColumns() {
    }

    public static InputColumn<?> createInputColumn(MessageType schema, String[] path) {
        Col<?> col = InputColumns.createCol(schema, path);
        if (col == null) {
            return null;
        }
        boolean isNullable = !schema.getType(path[0]).isRepetition(Type.Repetition.REQUIRED);
        ColumnDescriptor cdesc = schema.getColumnDescription(path);
        return InputColumns.createInputColumn(col, cdesc, isNullable);
    }

    public static InputColumn<String> createUnsupportedColumn(final ColumnDescriptor cdesc) {
        return new InputColumn<String>(){

            @Override
            public ColumnDescriptor getColumnDescriptor() {
                return cdesc;
            }

            @Override
            public Class<String> getContentClass() {
                return String.class;
            }

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Decoder<String> createDecoder() {
                return new Decoder<String>(){

                    @Override
                    public void clearValue() {
                    }

                    @Override
                    public Class<String> getContentClass() {
                        return String.class;
                    }

                    @Override
                    public void readItem(ColumnReader crdr) {
                    }

                    @Override
                    public void readNull() {
                    }

                    @Override
                    public String getValue() {
                        return null;
                    }
                };
            }

            @Override
            public DomainMapper getDomainMapper() {
                return null;
            }
        };
    }

    private static <T> InputColumn<?> createInputColumn(final Col<T> col, final ColumnDescriptor cdesc, final boolean isNullable) {
        final Class<T> clazz = col.getContentClass();
        return new InputColumn<T>(){

            @Override
            public Class<T> getContentClass() {
                return clazz;
            }

            @Override
            public Decoder<T> createDecoder() {
                return col.createDecoder();
            }

            @Override
            public ColumnDescriptor getColumnDescriptor() {
                return cdesc;
            }

            @Override
            public boolean isNullable() {
                return isNullable;
            }

            @Override
            public DomainMapper getDomainMapper() {
                return col.getDomainMapper();
            }
        };
    }

    private static Col<?> createCol(MessageType schema, String[] path) {
        PrimitiveType scalarType = InputColumns.getScalarType(schema, path);
        if (scalarType != null) {
            return InputColumns.createScalarCol(scalarType);
        }
        PrimitiveType elType = InputColumns.getArrayElementType(schema, path);
        if (elType != null) {
            return InputColumns.createArrayCol(elType);
        }
        return null;
    }

    private static PrimitiveType getScalarType(MessageType schema, String[] path) {
        if (path.length == 1) {
            Type t = schema.getType(path);
            if (t.isPrimitive() && !t.isRepetition(Type.Repetition.REPEATED)) {
                return t.asPrimitiveType();
            }
            return null;
        }
        return null;
    }

    private static PrimitiveType getArrayElementType(MessageType schema, String[] path) {
        if (path.length == 3) {
            Type t0 = schema.getType(path[0]);
            Type t1 = schema.getType(new String[]{path[0], path[1]});
            Type t2 = schema.getType(path);
            if (!t0.isPrimitive() && !t1.isPrimitive() && t1.isRepetition(Type.Repetition.REPEATED) && t2.isPrimitive()) {
                return t2.asPrimitiveType();
            }
            return null;
        }
        if (path.length == 2) {
            Type t0 = schema.getType(path[0]);
            Type t1 = schema.getType(path);
            if (!t0.isPrimitive() && t1.isRepetition(Type.Repetition.REPEATED) && t1.isPrimitive()) {
                return t1.asPrimitiveType();
            }
            return null;
        }
        if (path.length == 1) {
            Type t = schema.getType(path);
            if (t.isPrimitive() && t.isRepetition(Type.Repetition.REPEATED)) {
                return t.asPrimitiveType();
            }
            return null;
        }
        return null;
    }

    private static Col<?> createScalarCol(PrimitiveType ptype) {
        LogicalTypeAnnotation logType = ptype.getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName ptName = ptype.getPrimitiveTypeName();
        switch (ptName) {
            case BOOLEAN: {
                return new ScalarCol<Boolean>(Boolean.class, rdr -> rdr.getBoolean());
            }
            case INT32: {
                TimeMapper dmapper;
                boolean isSigned;
                int nbit;
                if (logType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logType;
                    nbit = intType.getBitWidth();
                    isSigned = intType.isSigned();
                } else {
                    nbit = 32;
                    isSigned = true;
                }
                TimeMapper timeMapper = dmapper = logType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation ? DATE_MAPPER : null;
                if (nbit == 8 && isSigned) {
                    return new ScalarCol<Byte>(Byte.class, rdr -> (byte)rdr.getInteger(), dmapper);
                }
                if (nbit == 16 && isSigned || nbit == 8 && !isSigned) {
                    return new ScalarCol<Short>(Short.class, rdr -> (short)rdr.getInteger(), dmapper);
                }
                if (nbit == 32 && isSigned || nbit == 16 && !isSigned) {
                    return new ScalarCol<Integer>(Integer.class, rdr -> rdr.getInteger(), dmapper);
                }
                if (nbit == 32 || !isSigned) {
                    return new ScalarCol<Long>(Long.class, rdr -> Integer.toUnsignedLong(rdr.getInteger()), dmapper);
                }
                return null;
            }
            case INT64: {
                DomainMapper tmapper;
                if (logType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.TimestampLogicalTypeAnnotation ttype = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logType;
                    LogicalTypeAnnotation.TimeUnit tunit = ttype.getUnit();
                    boolean isAdjusted = ttype.isAdjustedToUTC();
                    tmapper = TIME_MAPPERS.get(ttype.getUnit());
                } else {
                    tmapper = null;
                }
                return new ScalarCol<Long>(Long.class, rdr -> rdr.getLong(), tmapper);
            }
            case FLOAT: {
                return new ScalarCol<Float>(Float.class, rdr -> Float.valueOf(rdr.getFloat()));
            }
            case DOUBLE: {
                return new ScalarCol<Double>(Double.class, rdr -> rdr.getDouble());
            }
            case BINARY: {
                return InputColumns.isStringLikeBinary(logType) ? new ScalarCol<String>(String.class, rdr -> rdr.getBinary().toStringUsingUTF8()) : new ScalarCol<byte[]>(byte[].class, rdr -> rdr.getBinary().getBytes());
            }
        }
        return null;
    }

    private static Col<?> createArrayCol(PrimitiveType elType) {
        LogicalTypeAnnotation logType = elType.getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName ptName = elType.getPrimitiveTypeName();
        switch (ptName) {
            case INT32: {
                boolean isSigned;
                int nbit;
                if (logType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logType;
                    nbit = intType.getBitWidth();
                    isSigned = intType.isSigned();
                } else {
                    nbit = 32;
                    isSigned = true;
                }
                if (nbit == 8 && isSigned) {
                    return new PrimitiveArrayCol<byte[], ByteList>(byte[].class, ByteList::new, (rdr, list) -> list.add((byte)rdr.getInteger()), list -> list.add((byte)-128));
                }
                if (nbit == 16 && isSigned || nbit == 8 && !isSigned) {
                    return new PrimitiveArrayCol<short[], ShortList>(short[].class, ShortList::new, (rdr, list) -> list.add((short)rdr.getInteger()), list -> list.add((short)Short.MIN_VALUE));
                }
                if (nbit == 32 && isSigned || nbit == 16 && isSigned) {
                    return new PrimitiveArrayCol<int[], IntList>(int[].class, IntList::new, (rdr, list) -> list.add(rdr.getInteger()), list -> list.add(Integer.MIN_VALUE));
                }
                if (nbit == 32 || !isSigned) {
                    return new PrimitiveArrayCol<long[], LongList>(long[].class, LongList::new, (rdr, list) -> list.add(Integer.toUnsignedLong(rdr.getInteger())), list -> list.add(Long.MIN_VALUE));
                }
                return null;
            }
            case INT64: {
                return new PrimitiveArrayCol<long[], LongList>(long[].class, LongList::new, (rdr, list) -> list.add(rdr.getLong()), list -> list.add(Long.MIN_VALUE));
            }
            case FLOAT: {
                return new PrimitiveArrayCol<float[], FloatList>(float[].class, FloatList::new, (rdr, list) -> list.add(rdr.getFloat()), list -> list.add(Float.NaN));
            }
            case DOUBLE: {
                return new PrimitiveArrayCol<double[], DoubleList>(double[].class, DoubleList::new, (rdr, list) -> list.add(rdr.getDouble()), list -> list.add(Double.NaN));
            }
            case BINARY: {
                return InputColumns.isStringLikeBinary(logType) ? InputColumns.createStringArrayCol() : null;
            }
            case BOOLEAN: {
                return InputColumns.createBooleanArrayCol();
            }
        }
        return null;
    }

    private static boolean isStringLikeBinary(LogicalTypeAnnotation logType) {
        return Stream.of(LogicalTypeAnnotation.StringLogicalTypeAnnotation.class, LogicalTypeAnnotation.JsonLogicalTypeAnnotation.class, LogicalTypeAnnotation.EnumLogicalTypeAnnotation.class).anyMatch(t -> t.isInstance(logType));
    }

    private static Map<LogicalTypeAnnotation.TimeUnit, TimeMapper> createTimeMappers() {
        HashMap<LogicalTypeAnnotation.TimeUnit, TimeMapper> map = new HashMap<LogicalTypeAnnotation.TimeUnit, TimeMapper>();
        map.put(LogicalTypeAnnotation.TimeUnit.MILLIS, InputColumns.createUnixTimeMapper("milli", 1000L));
        map.put(LogicalTypeAnnotation.TimeUnit.MICROS, InputColumns.createUnixTimeMapper("micro", 1000000L));
        map.put(LogicalTypeAnnotation.TimeUnit.NANOS, InputColumns.createUnixTimeMapper("nano", 1000000000L));
        return Collections.unmodifiableMap(map);
    }

    private static TimeMapper createUnixTimeMapper(String unit, long perSec) {
        final double factor = 1.0 / (double)perSec;
        return new TimeMapper(Long.class, "Unix " + unit + "s", unit + "seconds since midnight 1 Jan 1970"){

            @Override
            public double toUnixSeconds(Object sourceValue) {
                return sourceValue instanceof Number ? (double)((Number)sourceValue).longValue() * factor : Double.NaN;
            }
        };
    }

    private static TimeMapper createUnixDateMapper() {
        double factor = 86400.0;
        return new TimeMapper((Class)Integer.class, "Unix date", "Days since 1 Jan 1970"){

            @Override
            public double toUnixSeconds(Object sourceValue) {
                return sourceValue instanceof Number ? (double)((Number)sourceValue).intValue() * 86400.0 : Double.NaN;
            }
        };
    }

    private static Col<boolean[]> createBooleanArrayCol() {
        final boolean[] array0 = new boolean[]{};
        return new Col<boolean[]>(){

            @Override
            public Class<boolean[]> getContentClass() {
                return boolean[].class;
            }

            @Override
            public Decoder<boolean[]> createDecoder() {
                return new Decoder<boolean[]>(){
                    final BitSet bits_ = new BitSet();
                    boolean[] value_;
                    int n_;

                    @Override
                    public Class<boolean[]> getContentClass() {
                        return boolean[].class;
                    }

                    @Override
                    public void clearValue() {
                        this.value_ = null;
                        this.n_ = 0;
                    }

                    @Override
                    public void readItem(ColumnReader crdr) {
                        this.bits_.set(this.n_++, crdr.getBoolean());
                    }

                    @Override
                    public void readNull() {
                        this.bits_.clear(this.n_++);
                    }

                    @Override
                    public boolean[] getValue() {
                        if (this.value_ == null) {
                            if (this.n_ == 0) {
                                this.value_ = array0;
                            } else {
                                this.value_ = new boolean[this.n_];
                                for (int i = 0; i < this.n_; ++i) {
                                    this.value_[i] = this.bits_.get(i);
                                }
                            }
                        }
                        return this.value_;
                    }
                };
            }

            @Override
            public DomainMapper getDomainMapper() {
                return null;
            }
        };
    }

    private static Col<String[]> createStringArrayCol() {
        final String[] array0 = new String[]{};
        return new Col<String[]>(){

            @Override
            public Class<String[]> getContentClass() {
                return String[].class;
            }

            @Override
            public Decoder<String[]> createDecoder() {
                return new Decoder<String[]>(){
                    final List<String> list_ = new ArrayList<String>();
                    String[] value_;

                    @Override
                    public Class<String[]> getContentClass() {
                        return String[].class;
                    }

                    @Override
                    public void clearValue() {
                        this.value_ = null;
                        this.list_.clear();
                    }

                    @Override
                    public void readItem(ColumnReader crdr) {
                        this.list_.add(crdr.getBinary().toStringUsingUTF8());
                    }

                    @Override
                    public void readNull() {
                        this.list_.add(null);
                    }

                    @Override
                    public String[] getValue() {
                        if (this.value_ == null) {
                            int n = this.list_.size();
                            this.value_ = n == 0 ? array0 : this.list_.toArray(new String[n]);
                        }
                        return this.value_;
                    }
                };
            }

            @Override
            public DomainMapper getDomainMapper() {
                return null;
            }
        };
    }

    private static class PrimitiveArrayCol<T, L extends PrimitiveList>
    implements Col<T> {
        final Class<T> clazz_;
        final Supplier<L> listSupplier_;
        final BiConsumer<ColumnReader, L> append_;
        final Consumer<L> appendNull_;

        PrimitiveArrayCol(Class<T> clazz, Supplier<L> listSupplier, BiConsumer<ColumnReader, L> append, Consumer<L> appendNull) {
            this.clazz_ = clazz;
            this.listSupplier_ = listSupplier;
            this.append_ = append;
            this.appendNull_ = appendNull;
        }

        @Override
        public Class<T> getContentClass() {
            return this.clazz_;
        }

        @Override
        public Decoder<T> createDecoder() {
            return new Decoder<T>(){
                final L plist_;
                boolean hasValue_;
                T value_;
                {
                    this.plist_ = (PrimitiveList)listSupplier_.get();
                }

                @Override
                public Class<T> getContentClass() {
                    return clazz_;
                }

                @Override
                public void clearValue() {
                    this.hasValue_ = false;
                    this.plist_.clear();
                }

                @Override
                public void readItem(ColumnReader crdr) {
                    append_.accept(crdr, this.plist_);
                }

                @Override
                public void readNull() {
                    appendNull_.accept(this.plist_);
                }

                @Override
                public T getValue() {
                    if (!this.hasValue_) {
                        this.hasValue_ = true;
                        this.value_ = this.plist_.size() == 0 ? null : clazz_.cast(this.plist_.toArray());
                    }
                    return this.value_;
                }
            };
        }

        @Override
        public DomainMapper getDomainMapper() {
            return null;
        }
    }

    private static class ScalarCol<T>
    implements Col<T> {
        final Class<T> clazz_;
        final Function<ColumnReader, T> readFunc_;
        final DomainMapper domainMapper_;

        ScalarCol(Class<T> clazz, Function<ColumnReader, T> readFunc, DomainMapper domainMapper) {
            this.clazz_ = clazz;
            this.readFunc_ = readFunc;
            this.domainMapper_ = domainMapper;
        }

        ScalarCol(Class<T> clazz, Function<ColumnReader, T> readFunc) {
            this(clazz, readFunc, null);
        }

        @Override
        public Class<T> getContentClass() {
            return this.clazz_;
        }

        @Override
        public Decoder<T> createDecoder() {
            return new Decoder<T>(){
                T value_;

                @Override
                public Class<T> getContentClass() {
                    return clazz_;
                }

                @Override
                public void clearValue() {
                    this.value_ = null;
                }

                @Override
                public void readItem(ColumnReader crdr) {
                    this.value_ = readFunc_.apply(crdr);
                }

                @Override
                public void readNull() {
                    assert (this.value_ == null);
                    this.value_ = null;
                }

                @Override
                public T getValue() {
                    return this.value_;
                }
            };
        }

        @Override
        public DomainMapper getDomainMapper() {
            return this.domainMapper_;
        }
    }

    private static interface Col<T> {
        public Class<T> getContentClass();

        public Decoder<T> createDecoder();

        public DomainMapper getDomainMapper();
    }
}

