/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReadStore;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.MessageType;
import uk.ac.starlink.parquet.InputColumn;
import uk.ac.starlink.parquet.InputColumns;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.Bi;
import uk.ac.starlink.util.IOSupplier;

public abstract class ParquetStarTable
extends AbstractStarTable {
    private final IOSupplier<ParquetFileReader> pfrSupplier_;
    private final MessageType schema_;
    private final String createdBy_;
    private final long nrow_;
    private final int ncol_;
    private final ColumnInfo[] cinfos_;
    private final InputColumn<?>[] incols_;
    private final Map<String, String> extrametaMap_;
    private String votmeta_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.parquet");
    public static final ValueInfo CREATEDBY_INFO = new DefaultValueInfo("Parquet_Created_By", String.class, "Parquet library source for file");
    public static final ValueInfo UNSUPPORTED_INFO = new DefaultValueInfo("PARQUET_UNSUPPORTED", Boolean.class, "If set, STIL reader cannot retrieve data");
    public static final String NAME_KEY = "name";
    public static final String VOTMETA_NAMESPACE = "IVOA.VOTable-Parquet.";
    public static final String VOTMETA_KEY = "IVOA.VOTable-Parquet.content";
    public static final String VOTMETAVERSION_KEY = "IVOA.VOTable-Parquet.version";
    public static final String REQUIRED_VOTMETAVERSION = "1.0";

    public ParquetStarTable(IOSupplier<ParquetFileReader> pfrSupplier, Config config) throws IOException {
        Map kvmap;
        this.pfrSupplier_ = pfrSupplier;
        try (ParquetFileReader pfr = (ParquetFileReader)pfrSupplier.get();){
            FileMetaData fmeta = pfr.getFileMetaData();
            kvmap = fmeta.getKeyValueMetaData();
            this.schema_ = fmeta.getSchema();
            this.createdBy_ = fmeta.getCreatedBy();
            this.nrow_ = pfr.getRecordCount();
        }
        HashMap metaMap = kvmap == null ? new HashMap() : new LinkedHashMap(kvmap);
        this.extrametaMap_ = new LinkedHashMap<String, String>(metaMap);
        String tname = (String)metaMap.remove(NAME_KEY);
        if (tname != null) {
            this.setName(tname);
        }
        String votmeta = (String)metaMap.remove(VOTMETA_KEY);
        String votmetaVersion = (String)metaMap.remove(VOTMETAVERSION_KEY);
        this.setVOTableMetadataText(votmeta);
        List<DescribedValue> params = this.getParameters();
        if (this.createdBy_ != null) {
            params.add(new DescribedValue(CREATEDBY_INFO, this.createdBy_));
        }
        for (Map.Entry meta : metaMap.entrySet()) {
            String pvalue = (String)meta.getValue();
            if (pvalue == null || pvalue.trim().length() <= 0) continue;
            DefaultValueInfo pinfo = new DefaultValueInfo((String)meta.getKey(), String.class, null);
            params.add(new DescribedValue(pinfo, pvalue));
        }
        ArrayList<Object> cinfos = new ArrayList<Object>();
        ArrayList<Object> incols = new ArrayList<Object>();
        int ic = 0;
        for (String[] path : this.schema_.getPaths()) {
            Bi col;
            ColumnInfo cinfo;
            String cname = path[0];
            InputColumn<Object> incol = InputColumns.createInputColumn(this.schema_, path);
            ColumnDescriptor cdesc = this.schema_.getColumnDescription(path);
            if (incol != null) {
                cinfo = new ColumnInfo(cname, incol.getContentClass(), null);
                cinfo.setNullable(incol.isNullable());
                DomainMapper dmapper = incol.getDomainMapper();
                if (dmapper != null) {
                    cinfo.setDomainMappers(new DomainMapper[]{dmapper});
                }
                col = new Bi(incol, (Object)cinfo);
            } else if (config.includeUnsupportedColumns()) {
                incol = InputColumns.createUnsupportedColumn(cdesc);
                cinfo = new ColumnInfo(cname, incol.getContentClass(), null);
                cinfo.setNullable(true);
                cinfo.setElementSize(0);
                cinfo.setAuxDatum(new DescribedValue(UNSUPPORTED_INFO, Boolean.TRUE));
                col = new Bi(incol, (Object)cinfo);
            } else {
                logger_.warning("Omitting unsupported Parquet column " + cdesc);
                col = null;
            }
            if (col != null) {
                incols.add(col.getItem1());
                cinfos.add(col.getItem2());
            }
            ++ic;
        }
        assert (ic == this.schema_.getFieldCount());
        this.incols_ = incols.toArray(new InputColumn[0]);
        this.cinfos_ = cinfos.toArray(new ColumnInfo[0]);
        this.ncol_ = this.cinfos_.length;
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.cinfos_[icol];
    }

    public ParquetFileReader getParquetFileReader() throws IOException {
        return (ParquetFileReader)this.pfrSupplier_.get();
    }

    public MessageType getSchema() {
        return this.schema_;
    }

    public Map<String, String> getExtraMetadataMap() {
        return this.extrametaMap_;
    }

    public String getVOTableMetadataText() {
        return this.votmeta_;
    }

    public void setVOTableMetadataText(String votmeta) {
        this.votmeta_ = votmeta;
    }

    public ColumnReadStore getColumnReadStore(PageReadStore pageStore, MessageType schema) {
        DummyGroupConverter groupConverter = new DummyGroupConverter();
        return new ColumnReadStoreImpl(pageStore, (GroupConverter)groupConverter, schema, this.createdBy_);
    }

    public InputColumn<?> getInputColumn(int icol) {
        return this.incols_[icol];
    }

    private static class DummyPrimitiveConverter
    extends PrimitiveConverter {
        private DummyPrimitiveConverter() {
        }

        public GroupConverter asGroupConverter() {
            return new DummyGroupConverter();
        }
    }

    private static class DummyGroupConverter
    extends GroupConverter {
        private DummyGroupConverter() {
        }

        public void start() {
        }

        public void end() {
        }

        public Converter getConverter(int iField) {
            return new DummyPrimitiveConverter();
        }
    }

    public static interface Config {
        public boolean includeUnsupportedColumns();
    }
}

