/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.parquet.ParquetIO;
import uk.ac.starlink.parquet.ParquetStarTable;
import uk.ac.starlink.parquet.ParquetUtil;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.table.storage.AdaptiveByteStore;
import uk.ac.starlink.table.storage.MonitorStoragePolicy;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class ParquetTableBuilder
extends DocumentedTableBuilder {
    private Boolean cacheCols_;
    private Boolean votMeta_;
    private int nThread_;
    private boolean tryUrl_;
    private String votableLoc_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.parquet");

    public ParquetTableBuilder() {
        super(new String[]{"parquet", "parq"});
    }

    @Override
    public String getFormatName() {
        return "parquet";
    }

    @Override
    public boolean canStream() {
        return false;
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>Parquet is a columnar format developed within the Apache", "project.", "Data is compressed on disk and read into memory before use.", this.readText("parquet-format.xml"), "</p>", "<p>This input handler will read columns representing", "scalars, strings and one-dimensional arrays of the same.", "It is not capable of reading multi-dimensional arrays,", "more complex nested data structures,", "or some more exotic data types like 96-bit integers.", "If such columns are encountered in an input file,", "a warning will be emitted through the logging system", "and the column will not appear in the read table.", "Support may be introduced for some additional types", "if there is demand.", "</p>", "<p>Parquet files typically do not contain rich metadata", "such as column units, descriptions, UCDs etc.", "To remedy that, this reader supports the", "<webref url='https://www.ivoa.net/documents/Notes/VOParquet/'", ">VOParquet convention</webref> (version 1.0),", "in which metadata is recorded in a DATA-less VOTable", "stored in the parquet file header.", "If such metadata is present it will by default be used,", "though this can be controlled using the <code>votmeta</code>", "configuration option below.", "</p>", "<p>Depending on the way that the table is accessed,", "the reader tries to take advantage of the column and", "row block structure of parquet files to read the data", "in parallel where possible.", "</p>", this.readText("parquet-packaging.xml"), "");
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storage) throws IOException {
        if (!ParquetUtil.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Not parquet format (no leading magic number)");
        }
        ParquetIO io = ParquetUtil.getIO();
        boolean useCache = this.useCache(datsrc, wantRandom, storage);
        ParquetStarTable.Config config = new ParquetStarTable.Config(){

            @Override
            public boolean includeUnsupportedColumns() {
                return true;
            }
        };
        ParquetStarTable parquetTable = io.readParquet(datsrc, this, config, useCache, this.tryUrl_);
        if (this.votableLoc_ != null) {
            String votTxt = ParquetTableBuilder.readUtf8FromLocation(this.votableLoc_);
            parquetTable.setVOTableMetadataText(votTxt);
        }
        return this.hideUnsupportedColumns(this.applyVOTableMetadata(parquetTable));
    }

    @Override
    public void streamStarTable(InputStream istrm, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream parquet");
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @ConfigMethod(property="cachecols", usage="true|false|null", example="true", doc="<p>Forces whether to read all the column data at table load\ntime.  If <code>true</code>, then when the table is loaded,\nall data is read by column into local scratch disk files,\nwhich is generally the fastest way to ingest all the data.\nIf <code>false</code>, the table rows are read as required,\nand possibly cached using the normal STIL mechanisms.\nIf <code>null</code> (the default), the decision is taken\nautomatically based on available information.\n</p>")
    public void setCacheCols(Boolean cacheCols) {
        this.cacheCols_ = cacheCols;
    }

    public Boolean getCacheCols() {
        return this.cacheCols_;
    }

    @ConfigMethod(property="nThread", usage="<int>", example="4", doc="<p>Sets the number of read threads used for concurrently\nreading table columns if the columns are cached at load time\n- see the <code>cachecols</code> option.\nIf the value is &lt;=0 (the default), a value is chosen\nbased on the number of apparently available processors.\n</p>")
    public void setReadThreadCount(int nThread) {
        this.nThread_ = nThread;
    }

    public int getReadThreadCount() {
        return this.nThread_;
    }

    @ConfigMethod(property="tryUrl", doc="<p>Whether to attempt to open non-file URLs as parquet files.\nThis usually seems to fail with a cryptic error message,\nso it is not attempted by default, but it's possible that with\nsuitable library support on the classpath it might work,\nso this option exists to make the attempt.\n</p>", example="true")
    public void setTryUrl(boolean tryUrl) {
        this.tryUrl_ = tryUrl;
    }

    public boolean getTryUrl() {
        return this.tryUrl_;
    }

    @ConfigMethod(property="votmeta", example="false", doc="<p>If true, the content of the parquet extra metadata\nkey-value list item with key\n<code>IVOA.VOTable-Parquet.content</code>\nwill be read to supply the metadata for the input table,\nfollowing the\n<webref url='https://www.ivoa.net/documents/Notes/VOParquet/'>VOParquet convention</webref>.\nIf false, any such VOTable metadata is ignored.\nIf set null, the default, then such VOTable metadata\nwill be used only if it is present and apparently consistent\nwith the parquet data and metadata.\n</p>")
    public void setVOTableMetadata(Boolean votMeta) {
        this.votMeta_ = votMeta;
    }

    public Boolean getVOTableMetadata() {
        return this.votMeta_;
    }

    @ConfigMethod(property="votable", doc="<p>Location of a UTF-8-encoded data-less VOTable\nthat will supply additional metadata for a parquet table\nbeing read, according to the\n<webref url='https://www.ivoa.net/documents/Notes/VOParquet/'>VOParquet convention</webref>.\nThis is normally not required, but if present it overrides\nany such metadata VOTable embedded within the parquet file.\nThis value will only be used if the <code>votmeta</code>\nconfiguration is not false.\n</p>", usage="<filename-or-url>", example="./metadata.vot")
    public void setVOTableLocation(String votableLoc) {
        this.votableLoc_ = votableLoc;
    }

    public String getVOTableLocation() {
        return this.votableLoc_;
    }

    public static String readUtf8FromLocation(String loc) throws IOException {
        try (InputStream in = DataSource.getInputStream((String)loc, (boolean)false);){
            int nc;
            InputStreamReader rdr = new InputStreamReader(in, StandardCharsets.UTF_8);
            int bufsiz = 10240;
            char[] buf = new char[bufsiz];
            StringBuffer sbuf = new StringBuffer();
            while ((nc = ((Reader)rdr).read(buf, 0, buf.length)) > 0) {
                sbuf.append(buf, 0, nc);
            }
            String string = sbuf.toString();
            return string;
        }
    }

    private boolean useCache(DataSource datsrc, boolean wantRandom, StoragePolicy storage) {
        if (this.cacheCols_ != null) {
            return this.cacheCols_;
        }
        if (wantRandom) {
            while (storage instanceof MonitorStoragePolicy) {
                storage = ((MonitorStoragePolicy)storage).getBasePolicy();
            }
            if (StoragePolicy.PREFER_MEMORY.equals(storage)) {
                return false;
            }
            if (StoragePolicy.PREFER_DISK.equals(storage)) {
                return true;
            }
            if (StoragePolicy.ADAPTIVE.equals(storage) && datsrc instanceof FileDataSource) {
                long len = ((FileDataSource)datsrc).getFile().length();
                return (double)len > 0.5 * (double)AdaptiveByteStore.getDefaultLimit();
            }
            return false;
        }
        return false;
    }

    private StarTable applyVOTableMetadata(ParquetStarTable parquetTable) throws TableFormatException {
        String failMsg;
        block9: {
            String votmetaTxt = parquetTable.getVOTableMetadataText();
            if (votmetaTxt == null || Boolean.FALSE.equals(this.votMeta_)) {
                if (Boolean.TRUE.equals(this.votMeta_)) {
                    throw new TableFormatException("VOParquet: No VOTable metadata found");
                }
                return parquetTable;
            }
            try {
                TableElement tabEl = ParquetTableBuilder.readVOParquetTableElement(votmetaTxt);
                if (tabEl == null) {
                    failMsg = "No suitable TABLE element found";
                    break block9;
                }
                try {
                    VOStarTable votTable = VOStarTable.createDecoratedTable(parquetTable, tabEl);
                    return ParquetTableBuilder.fixColumnTypes(parquetTable, votTable);
                }
                catch (IOException e) {
                    failMsg = "Cannot reconcile VOTable metadata with parquet: " + e;
                }
            }
            catch (IOException e) {
                failMsg = "Failed to read VOTable metadata: " + e;
            }
        }
        if (Boolean.TRUE.equals(this.votMeta_)) {
            throw new TableFormatException("VOParquet: " + failMsg);
        }
        assert (this.votMeta_ == null);
        logger_.warning("VOParquet: " + failMsg);
        return parquetTable;
    }

    private StarTable hideUnsupportedColumns(final StarTable table) {
        IntList icolList = new IntList();
        for (int icol = 0; icol < table.getColumnCount(); ++icol) {
            ColumnInfo cinfo = table.getColumnInfo(icol);
            if (Boolean.TRUE.equals(cinfo.getAuxDatumValue(ParquetStarTable.UNSUPPORTED_INFO, Boolean.class))) {
                logger_.warning("Ignoring parquet column with unsupported type: " + cinfo.getName());
                continue;
            }
            icolList.add(icol);
        }
        if (icolList.size() == table.getColumnCount()) {
            return table;
        }
        return new ColumnPermutedStarTable(table, icolList.toIntArray(), true){

            @Override
            public URL getURL() {
                return table.getURL();
            }
        };
    }

    private static TableElement readVOParquetTableElement(String votTxt) throws IOException {
        DOMSource domsrc;
        VOElementFactory vofact = new VOElementFactory();
        try {
            domsrc = vofact.transformToDOM(new StreamSource(new StringReader(votTxt)), false);
        }
        catch (SAXException e) {
            throw new TableFormatException("VOTable parse failed", e);
        }
        VODocument doc = (VODocument)domsrc.getNode();
        VOElement topel = (VOElement)doc.getDocumentElement();
        NodeList tlist = topel.getElementsByVOTagName("TABLE");
        if (tlist.getLength() > 0) {
            TableElement tableEl = (TableElement)tlist.item(0);
            if (DOMUtils.getChildElementByName((Node)tableEl, (String)"DATA") != null) {
                String msg = "VOParquet: first TABLE element has illegal DATA child (using it anyway)";
                logger_.warning(msg);
            }
            return tableEl;
        }
        throw new TableFormatException("VOParquet: no suitable TABLE element found");
    }

    private static StarTable fixColumnTypes(final ParquetStarTable pt, VOStarTable vt) throws TableFormatException {
        int ncol = pt.getColumnCount();
        if (vt.getColumnCount() != ncol) {
            throw new TableFormatException("Column count mismatch");
        }
        final ColumnInfo[] cinfos = new ColumnInfo[ncol];
        int nMeta = 0;
        for (int ic = 0; ic < ncol; ++ic) {
            ColumnInfo vinfo = vt.getColumnInfo(ic);
            ColumnInfo pinfo = pt.getColumnInfo(ic);
            if (vinfo.getName().equals(pinfo.getName())) {
                ColumnInfo info = new ColumnInfo(vinfo);
                info.setContentClass(pinfo.getContentClass());
                info.getAuxData().addAll(pinfo.getAuxData());
                ArrayList<DomainMapper> dmappers = new ArrayList<DomainMapper>();
                dmappers.addAll(Arrays.asList(pinfo.getDomainMappers()));
                dmappers.addAll(Arrays.asList(vinfo.getDomainMappers()));
                info.setDomainMappers(dmappers.toArray(new DomainMapper[0]));
                cinfos[ic] = info;
                ++nMeta;
                continue;
            }
            cinfos[ic] = pinfo;
            logger_.warning("Name mismatch for column " + (ic + 1) + ": \"" + pinfo.getName() + "\" != \"" + vinfo.getName() + "\", ignoring VOTable metadata");
        }
        if (nMeta > 0) {
            return new WrapperStarTable(vt){

                @Override
                public URL getURL() {
                    return pt.getURL();
                }

                @Override
                public ColumnInfo getColumnInfo(int ic) {
                    return cinfos[ic];
                }
            };
        }
        return pt;
    }
}

