/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import cds.healpix.Healpix;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedPolygonComputer;
import java.util.Arrays;
import uk.ac.starlink.ttools.cone.CdsHealpixUtil;
import uk.ac.starlink.ttools.func.Coverage;
import uk.ac.starlink.util.LongList;

public class Area {
    private final Type type_;
    private final double[] dataArray_;

    public Area(Type type, double[] dataArray) {
        this.type_ = type;
        this.dataArray_ = dataArray;
    }

    public Type getType() {
        return this.type_;
    }

    public double[] getDataArray() {
        return this.dataArray_;
    }

    public void writePlaneCoords2(double[] buffer) {
        this.type_.writePlaneCoords2(this.dataArray_, buffer);
    }

    public void writeSkyCoords3(double[] buffer) {
        this.type_.writeSkyCoords3(this.dataArray_, buffer);
    }

    public long[] toMocUniqs(int level) {
        return this.type_.toMocUniqs(this.dataArray_, level);
    }

    public static double[] serializeMultishape(Area[] areas) {
        int nel = 1 + Arrays.stream(areas).mapToInt(a -> 2 + a.getDataArray().length).sum();
        double[] array = new double[nel];
        int iel = 0;
        array[iel++] = areas.length;
        for (Area area : areas) {
            array[iel++] = area.getType().ordinal();
            array[iel++] = area.getDataArray().length;
        }
        for (Area area : areas) {
            double[] coords = area.getDataArray();
            int nc = coords.length;
            System.arraycopy(coords, 0, array, iel, nc);
            iel += nc;
        }
        assert (iel == array.length);
        return array;
    }

    public static Area[] deserializeMultishape(double[] data) {
        int iel = 0;
        int ns = (int)data[iel++];
        Area[] shapes = new Area[ns];
        int kel = 1 + ns * 2;
        for (int is = 0; is < ns; ++is) {
            Type type = Type.values()[(int)data[iel++]];
            int nc = (int)data[iel++];
            double[] d = new double[nc];
            System.arraycopy(data, kel, d, 0, nc);
            kel += nc;
            shapes[is] = new Area(type, d);
        }
        assert (kel == data.length);
        return shapes;
    }

    public static Area createMultishape(Area[] areas) {
        return areas != null && areas.length > 0 ? new Area(Type.MULTISHAPE, Area.serializeMultishape(areas)) : null;
    }

    private static void writeLonLatSky3(double lonDeg, double latDeg, double[] buffer) {
        if (latDeg >= -90.0 && latDeg <= 90.0) {
            double theta = Math.toRadians(90.0 - latDeg);
            double phi = Math.toRadians(lonDeg % 360.0);
            double z = Math.cos(theta);
            double sd = Math.sin(theta);
            double x = Math.cos(phi) * sd;
            double y = Math.sin(phi) * sd;
            buffer[0] = x;
            buffer[1] = y;
            buffer[2] = z;
        } else {
            buffer[0] = Double.NaN;
            buffer[1] = Double.NaN;
            buffer[2] = Double.NaN;
        }
    }

    public static enum Type {
        POLYGON{

            @Override
            public boolean isLegalArrayLength(int n) {
                return n % 2 == 0 && n >= 6;
            }

            @Override
            public void writePlaneCoords2(double[] data, double[] buffer) {
                int nc2 = data.length;
                double x0 = data[0];
                double y0 = data[1];
                double xmin = x0;
                double xmax = x0;
                double ymin = y0;
                double ymax = y0;
                for (int ic2 = 2; ic2 < nc2; ic2 += 2) {
                    double x = data[ic2 + 0];
                    double y = data[ic2 + 1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    xmin = Math.min(xmin, x);
                    xmax = Math.max(xmax, x);
                    ymin = Math.min(ymin, y);
                    ymax = Math.max(ymax, y);
                }
                buffer[0] = 0.5 * (xmin + xmax);
                buffer[1] = 0.5 * (ymin + ymax);
            }

            @Override
            public void writeSkyCoords3(double[] data, double[] buffer) {
                double[] v3 = new double[3];
                int nc2 = data.length;
                double sx = 0.0;
                double sy = 0.0;
                double sz = 0.0;
                for (int ic2 = 0; ic2 < nc2; ic2 += 2) {
                    double lonDeg = data[ic2 + 0];
                    double latDeg = data[ic2 + 1];
                    if (Double.isNaN(lonDeg) || Double.isNaN(latDeg)) continue;
                    Area.writeLonLatSky3(lonDeg, latDeg, v3);
                    sx += v3[0];
                    sy += v3[1];
                    sz += v3[2];
                }
                double fact = 1.0 / Math.sqrt(sx * sx + sy * sy + sz * sz);
                buffer[0] = sx * fact;
                buffer[1] = sy * fact;
                buffer[2] = sz * fact;
            }

            @Override
            public long[] toMocUniqs(double[] data, int level) {
                LongList uniqList = new LongList();
                int nc2 = data.length;
                int ic2start = 0;
                HealpixNestedPolygonComputer polyComputer = Healpix.getNested((int)level).newPolygonComputer();
                for (int ic2 = 0; ic2 < nc2; ic2 += 2) {
                    boolean isBreak;
                    boolean bl = isBreak = Double.isNaN(data[ic2 + 0]) || Double.isNaN(data[ic2 + 1]);
                    if (!isBreak && ic2 + 2 != nc2) continue;
                    if (ic2 > ic2start) {
                        int nv2 = isBreak ? ic2 - ic2start : ic2 + 2 - ic2start;
                        int nv = nv2 / 2;
                        double[][] vertices = new double[nv][];
                        for (int iv = 0; iv < nv; ++iv) {
                            double lonDeg = data[ic2start + 2 * iv + 0];
                            double latDeg = data[ic2start + 2 * iv + 1];
                            vertices[iv] = new double[]{Math.toRadians(lonDeg), Math.toRadians(latDeg)};
                        }
                        HealpixNestedBMOC bmoc = polyComputer.overlappingCells((double[][])vertices);
                        for (HealpixNestedBMOC.CurrentValueAccessor a : bmoc) {
                            uniqList.add(Coverage.mocUniq(a.getDepth(), a.getHash()));
                        }
                    }
                    ic2start = ic2 + 2;
                }
                return uniqList.toLongArray();
            }
        }
        ,
        CIRCLE{

            @Override
            public boolean isLegalArrayLength(int n) {
                return n == 3;
            }

            @Override
            public void writePlaneCoords2(double[] data, double[] buffer) {
                buffer[0] = data[0];
                buffer[1] = data[1];
            }

            @Override
            public void writeSkyCoords3(double[] data, double[] buffer) {
                Area.writeLonLatSky3(data[0], data[1], buffer);
            }

            @Override
            public long[] toMocUniqs(double[] data, int level) {
                double lonDeg = data[0];
                double latDeg = data[1];
                double rDeg = data[2];
                HealpixNestedBMOC bmoc = Healpix.getNested((int)level).newConeComputer(Math.toRadians(rDeg)).overlappingCells(Math.toRadians(lonDeg), Math.toRadians(latDeg));
                long[] uniqs = new long[bmoc.size()];
                int i = 0;
                for (HealpixNestedBMOC.CurrentValueAccessor access : bmoc) {
                    uniqs[i++] = Coverage.mocUniq(access.getDepth(), access.getHash());
                }
                assert (i == bmoc.size());
                return uniqs;
            }
        }
        ,
        POINT{

            @Override
            public boolean isLegalArrayLength(int n) {
                return n == 2;
            }

            @Override
            public void writePlaneCoords2(double[] data, double[] buffer) {
                buffer[0] = data[0];
                buffer[1] = data[1];
            }

            @Override
            public void writeSkyCoords3(double[] data, double[] buffer) {
                Area.writeLonLatSky3(data[0], data[1], buffer);
            }

            @Override
            public long[] toMocUniqs(double[] data, int level) {
                double lonDeg = data[0];
                double latDeg = data[1];
                long hash = Healpix.getNestedFast((int)level).hash(Math.toRadians(lonDeg), Math.toRadians(latDeg));
                return new long[]{Coverage.mocUniq(level, hash)};
            }
        }
        ,
        MOC{

            @Override
            public boolean isLegalArrayLength(int n) {
                return n > 0;
            }

            @Override
            public void writePlaneCoords2(double[] data, double[] buffer) {
                double lon;
                double[] r3 = new double[3];
                this.writeSkyCoords3(data, r3);
                double lat = 90.0 - Math.toDegrees(Math.acos(r3[2]));
                buffer[0] = lon = Math.toDegrees(Math.atan2(r3[1], r3[0]));
                buffer[1] = lat;
            }

            @Override
            public void writeSkyCoords3(double[] data, double[] buffer) {
                int nd = data.length;
                double tx = 0.0;
                double ty = 0.0;
                double tz = 0.0;
                double[] lonlat = new double[2];
                double[] xyz = new double[3];
                for (int i = 0; i < nd; ++i) {
                    long uniq = Double.doubleToRawLongBits(data[i]);
                    int order = 61 - Long.numberOfLeadingZeros(uniq) >> 1;
                    long ipix = uniq - (4L << 2 * order);
                    Healpix.getNestedFast((int)order).center(ipix, lonlat);
                    CdsHealpixUtil.lonlatToVector(lonlat, xyz);
                    double factor = 1.0 / (double)(1L << 2 * order);
                    tx += factor * xyz[0];
                    ty += factor * xyz[1];
                    tz += factor * xyz[2];
                }
                double scale = 1.0 / Math.sqrt(tx * tx + ty * ty + tz * tz);
                buffer[0] = tx * scale;
                buffer[1] = ty * scale;
                buffer[2] = tz * scale;
            }

            @Override
            public long[] toMocUniqs(double[] data, int level) {
                int npix = data.length;
                long[] moc = new long[npix];
                for (int i = 0; i < npix; ++i) {
                    moc[i] = Double.doubleToRawLongBits(data[i]);
                }
                return moc;
            }
        }
        ,
        MULTISHAPE{

            @Override
            public boolean isLegalArrayLength(int n) {
                return n > 3;
            }

            @Override
            public void writePlaneCoords2(double[] data, double[] buffer) {
                Area[] shapes = Area.deserializeMultishape(data);
                assert (shapes.length > 0);
                Area shape0 = shapes[0];
                shape0.getType().writePlaneCoords2(shape0.getDataArray(), buffer);
                double x0 = buffer[0];
                double y0 = buffer[1];
                double xmin = x0;
                double xmax = x0;
                double ymin = y0;
                double ymax = y0;
                for (int is = 1; is < shapes.length; ++is) {
                    Area shape = shapes[is];
                    shape.getType().writePlaneCoords2(shape.getDataArray(), buffer);
                    double x = buffer[0];
                    double y = buffer[1];
                    xmin = Math.min(xmin, x);
                    xmax = Math.max(xmax, x);
                    ymin = Math.min(ymin, y);
                    ymax = Math.max(ymax, y);
                }
                buffer[0] = 0.5 * (xmin + xmax);
                buffer[1] = 0.5 * (ymin + ymax);
            }

            @Override
            public void writeSkyCoords3(double[] data, double[] buffer) {
                double sx = 0.0;
                double sy = 0.0;
                double sz = 0.0;
                for (Area shape : Area.deserializeMultishape(data)) {
                    shape.getType().writeSkyCoords3(shape.getDataArray(), buffer);
                    sx += buffer[0];
                    sy += buffer[1];
                    sz += buffer[2];
                }
                double fact = 1.0 / Math.sqrt(sx * sx + sy * sy + sz * sz);
                buffer[0] = sx * fact;
                buffer[1] = sy * fact;
                buffer[2] = sz * fact;
            }

            @Override
            public long[] toMocUniqs(double[] data, int level) {
                LongList uniqList = new LongList();
                for (Area shape : Area.deserializeMultishape(data)) {
                    uniqList.addAll(shape.getType().toMocUniqs(shape.getDataArray(), level));
                }
                return uniqList.toLongArray();
            }
        };

        private static final Type[] VALUES;

        public abstract boolean isLegalArrayLength(int var1);

        abstract void writePlaneCoords2(double[] var1, double[] var2);

        abstract void writeSkyCoords3(double[] var1, double[] var2);

        public abstract long[] toMocUniqs(double[] var1, int var2);

        public static Type fromInt(int itype) {
            return itype >= 0 && itype < VALUES.length ? VALUES[itype] : null;
        }

        static {
            VALUES = Type.values();
        }
    }
}

