/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.util.XmlWriter;

public class DocUtils {
    private DocUtils() {
    }

    public static String join(String[] lines) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            sbuf.append(lines[i]).append('\n');
        }
        return sbuf.toString();
    }

    public static String filterRef(BasicFilter filter) {
        String name = filter.getName();
        return new StringBuffer().append("<code>").append("<ref id=\"").append(name).append("\">").append(name).append("</ref>").append("</code>").toString();
    }

    public static String modeRef(String name) {
        return new StringBuffer().append("<code>").append("<ref id=\"mode-").append(name).append("\">").append(name).append("</ref>").append("</code>").toString();
    }

    public static String listInfos(ValueInfo[] infos) {
        return DocUtils.describedList(infos, ValueInfo::getName, ValueInfo::getDescription, false);
    }

    public static <E> String describedList(E[] items, Function<E, String> namer, Function<E, String> describer, boolean isDescriptionXml) {
        return DocUtils.describedList(Arrays.asList(items), namer, describer, isDescriptionXml);
    }

    public static <E> String describedList(Collection<E> items, Function<E, String> namer, Function<E, String> describer, boolean isDescriptionXml) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<ul>\n");
        for (E item : items) {
            String name = namer.apply(item);
            String descrip = describer.apply(item);
            sbuf.append("<li><code>").append(name).append("</code>: ").append(isDescriptionXml ? descrip : XmlWriter.formatText((String)descrip)).append("\n</li>").append("\n");
        }
        sbuf.append("</ul>\n");
        return sbuf.toString();
    }

    public static String getXmlDescription(Documented item) throws IOException {
        try {
            return DocUtils.fromXhtml(item.getXmlDescription());
        }
        catch (TransformerException e) {
            throw new IOException("XSLT trouble", e);
        }
    }

    public static String fromXhtml(String xhtml) throws IOException, TransformerException {
        String wrapTag = "wrap-doc";
        String wrapXhtml = "<" + wrapTag + ">" + xhtml + "</" + wrapTag + ">";
        URL xsltUrl = DocUtils.class.getResource("fromXhtml.xslt");
        StreamSource xsltSrc = new StreamSource(xsltUrl.openStream());
        StreamSource docSrc = new StreamSource(new StringReader(wrapXhtml));
        Transformer trans = TransformerFactory.newInstance().newTransformer(xsltSrc);
        StringWriter out = new StringWriter();
        StreamResult docRes = new StreamResult(out);
        trans.transform(docSrc, docRes);
        out.close();
        return out.getBuffer().toString();
    }
}

