/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.build.DocletOutput;
import uk.ac.starlink.ttools.build.Heading;

public class HtmlDocletOutput
implements DocletOutput {
    private final File baseDir_;
    private final boolean isHeadings_;
    private Writer out_;
    private String className_;

    public HtmlDocletOutput(File baseDir, boolean isHeadings) {
        this.baseDir_ = baseDir;
        this.isHeadings_ = isHeadings;
    }

    @Override
    public void startOutput() throws IOException {
        if (this.isHeadings_) {
            this.writeHeadingFiles();
        }
    }

    @Override
    public void endOutput() throws IOException {
    }

    @Override
    public void startClass(String className, String firstSentence, String fullDescription) throws IOException {
        this.className_ = className;
        this.startOutFile(HtmlDocletOutput.docFile(this.baseDir_, className, ".html"));
        String shortName = className.replaceFirst("^.*[.]", "");
        this.outHeader("Class", shortName);
        this.outDescription(fullDescription);
        this.outFooter();
        this.endOutFile();
    }

    @Override
    public void endClass() {
        this.className_ = null;
    }

    @Override
    public void startMember(String memberName, String memberType, String uniqueId, String description) throws IOException {
        this.startOutFile(HtmlDocletOutput.docFile(this.baseDir_, this.className_, "-" + uniqueId + ".html"));
        this.outHeader(memberType, memberName);
        this.outDescription(description);
    }

    @Override
    public void endMember() throws IOException {
        this.outFooter();
        this.endOutFile();
    }

    @Override
    public void outMemberItem(String name, String val) throws IOException {
        this.out(new String[]{"<dl>", "<dt><strong>" + name + ":</strong></dt>", "<dd>" + val + "</dd>", "</dl>"});
    }

    @Override
    public void outParameters(DocletOutput.DocVariable[] params) throws IOException {
        this.out(new String[]{"<dl>", "<dt><strong>Parameters:</strong></dt>", "<dd>", "<dl>"});
        for (DocletOutput.DocVariable param : params) {
            this.out(new StringBuffer().append("<dt><strong><font color='blue'><code>").append(param.getName()).append("</code></font></strong> ").append("<em>(").append(param.getType()).append(")</em>").append("</dt>").toString());
            String comment = param.getCommentText();
            if (comment == null) continue;
            this.out("<dd>" + comment + "</dd>");
        }
        this.out("</dl></dd></dl>");
    }

    @Override
    public void outReturn(String type, String comment) throws IOException {
        if (comment != null) {
            this.outMemberItem("Return Value (" + type + ")", comment);
        } else {
            this.outMemberItem("Return Type", type);
        }
    }

    private void outDescription(String descrip) throws IOException {
        this.out(new String[]{"<dl>", "<dt><strong>Description:</strong></dt>", "<dd>", descrip, "</dd>", "</dl>"});
    }

    @Override
    public void outExamples(String heading, String[] examples) throws IOException {
        this.outList(heading, examples);
    }

    @Override
    public void outSees(String heading, String[] sees) throws IOException {
        List<String> seeTxts = Arrays.stream(sees).map(t -> HtmlDocletOutput.formatSeeText(t)).filter(t -> t != null).collect(Collectors.toList());
        if (seeTxts.size() > 0) {
            this.outList(heading, seeTxts.toArray(new String[0]));
        }
    }

    private void outList(String heading, String[] items) throws IOException {
        int nItem = items.length;
        if (nItem > 0) {
            this.out(new String[]{"<dl>", "<dt><strong>" + heading + ":</strong></dt>"});
            if (nItem == 1) {
                this.out("<dd>" + items[0] + "</dd>");
            } else {
                this.out("<dd><ul>");
                for (String item : items) {
                    this.out("<li>" + item + "</li>");
                }
                this.out("</ul></dd>");
            }
            this.out(new String[]{"</dl>"});
        }
    }

    private void writeHeadingFiles() throws IOException {
        Heading[] headings = Heading.ALL_HEADINGS;
        for (Heading heading : Heading.ALL_HEADINGS) {
            File file = HtmlDocletOutput.docFile(this.baseDir_, Heading.class.getName(), heading.getDocSuffix());
            this.startOutFile(file);
            this.outHeader("", heading.getUserString());
            this.out(heading.getDescription());
            this.outFooter();
            this.endOutFile();
        }
    }

    private void outHeader(String memType, String memName) throws IOException {
        this.out(new String[]{"<html>", "<head><title>" + memName + "</title></head>", "<body bgcolor='white'>", "<h2>" + memType + " <font color='blue'><code>" + memName + "</code></font></h2>"});
    }

    private void outFooter() throws IOException {
        this.out(new String[]{"</body>", "</html>"});
    }

    private void startOutFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Can't create directory " + parent);
        }
        this.out_ = new BufferedWriter(new FileWriter(file));
    }

    private void endOutFile() throws IOException {
        this.out_.close();
        this.out_ = null;
    }

    private void out(String[] lines) throws IOException {
        for (int i = 0; i < lines.length; ++i) {
            this.out(lines[i]);
        }
    }

    private void out(String line) throws IOException {
        this.out_.write(line);
        this.out_.write(10);
    }

    private static String formatSeeText(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        if ((txt = txt.trim().replaceAll("\\s+", " ")).startsWith("<a ")) {
            return txt;
        }
        return null;
    }

    private static File docFile(File baseDir, String className, String suffix) throws IOException {
        File file = baseDir;
        StringTokenizer st = new StringTokenizer(className, ".");
        while (st.hasMoreTokens()) {
            file = new File(file, st.nextToken());
        }
        return new File(file.getPath() + suffix);
    }
}

