/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.build.LayerTypeDoc;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.LayerTypeParameter;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.LogUtils;
import uk.ac.starlink.util.ObjectFactory;

public class LayersWriter {
    private final TypedPlot2Task<?, ?> task_;

    public LayersWriter(TypedPlot2Task<?, ?> task) {
        this.task_ = task;
    }

    public String getXml() {
        StringBuffer sbuf = new StringBuffer().append("<p>Content is added to the plot by specifying\n").append("one or more <em>plot layers</em> using the\n").append("<code>layerN</code> parameter.\n").append("The <code>N</code> part is a suffix applied to\n").append("all the parameters affecting a given layer;\n").append("any suffix (including the empty string) may be used.\n").append("Available layers for this plot type are:\n");
        LayerType[] ltypes = LayerTypeParameter.getLayerTypes(this.task_.getPlotContext().getPlotType().getPlotters());
        int nt = ltypes.length;
        for (int it = 0; it < nt; ++it) {
            sbuf.append(LayerTypeDoc.layerTypeRef(ltypes[it])).append(it < nt - 1 ? "," : ".").append("\n");
        }
        sbuf.append("</p>\n");
        return sbuf.toString();
    }

    public static void main(String[] args) throws LoadException, IOException {
        LogUtils.getLogger((String)"uk.ac.starlink.ttools.plot2").setLevel(Level.WARNING);
        ObjectFactory<Task> taskFact = Stilts.getTaskFactory();
        if (args.length == 0) {
            File dir = new File(".");
            for (String nickname : taskFact.getNickNames()) {
                Task task = (Task)taskFact.createObject(nickname);
                if (!(task instanceof TypedPlot2Task)) continue;
                TypedPlot2Task p2task = (TypedPlot2Task)task;
                String fname = nickname + "-layers.xml";
                File file = new File(dir, fname);
                System.out.println("Writing " + fname);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                out.write(new LayersWriter(p2task).getXml());
                ((Writer)out).close();
            }
        } else {
            LayersWriter writer = new LayersWriter((TypedPlot2Task)taskFact.createObject(args[0]));
            System.out.println(writer.getXml());
        }
    }
}

