/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot2.config.ClippedShader;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.util.IconUtils;
import uk.ac.starlink.util.LogUtils;

public class ShaderLegend {
    private final int ncol_;
    private final int colWidth_;
    private final int textWidth_;
    private final int rampWidth_;
    private final int rowHeight_;
    private final int rampHeight_;
    private final int pad_;
    private final boolean forcePixelated_;

    public ShaderLegend(int ncol) {
        this.ncol_ = ncol;
        this.colWidth_ = 300;
        this.textWidth_ = 130;
        this.rampWidth_ = 120;
        this.rowHeight_ = 30;
        this.rampHeight_ = 20;
        this.pad_ = 15;
        this.forcePixelated_ = false;
    }

    public String toSvg(Shader[] shaders) {
        Base64.Encoder b64encoder = Base64.getEncoder();
        int ns = shaders.length;
        int nrow = (ns + this.ncol_ - 1) / this.ncol_;
        int wpix = this.colWidth_ * this.ncol_ + 2 * this.pad_;
        int hpix = this.rowHeight_ * nrow + 2 * this.pad_;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(String.join((CharSequence)"\n", "<svg xmlns='http://www.w3.org/2000/svg'", "     xmlns:xlink='http://www.w3.org/1999/xlink'", "     width='" + wpix + "px' height='" + hpix + "px' viewBox='0 0 " + wpix + " " + hpix + "'>", ""));
        if (this.forcePixelated_) {
            sbuf.append("  <g style='image-rendering: pixelated;'>\n");
        }
        for (int is = 0; is < ns; ++is) {
            Shader shader = shaders[is];
            int ir = is % nrow;
            int ic = is / nrow;
            int x0 = this.pad_ + this.colWidth_ * ic;
            int y0 = this.pad_ + this.rowHeight_ * (ir + 1);
            int iconHeight = shader.isAbsolute() ? 1 : 16;
            byte[] rampPng = ShaderLegend.createShaderPng(shader, 256, iconHeight);
            sbuf.append("    <text x='" + x0 + "' y='" + y0 + "'>").append(shader.getName()).append("</text>\n");
            sbuf.append("    <image preserveAspectRatio='none'").append(" width='" + this.rampWidth_ + "'").append(" height='" + this.rampHeight_ + "'").append(" x='" + (x0 + this.textWidth_) + "'").append(" y='" + (y0 - this.rampHeight_) + "'\n").append("           xlink:href='data:image/png;base64,").append(b64encoder.encodeToString(rampPng)).append("'/>\n");
        }
        if (this.forcePixelated_) {
            sbuf.append("</g>\n");
        }
        sbuf.append("</svg>\n");
        return sbuf.toString();
    }

    private static byte[] createShaderPng(Shader shader, int w, int h) {
        Icon icon = Shaders.createShaderIcon(shader, true, w, h, 0, 0);
        BufferedImage img = IconUtils.createImage((Icon)icon);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "PNG", out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error: " + e, e);
        }
        return out.toByteArray();
    }

    public static Shader[] getAllShaders() {
        RampKeySet[] ramps;
        LinkedHashSet<Shader> shaders = new LinkedHashSet<Shader>();
        for (RampKeySet ramp : ramps = new RampKeySet[]{StyleKeys.AUX_RAMP, StyleKeys.DENSITY_RAMP}) {
            for (ClippedShader cshader : ramp.getShaders()) {
                Shader shader = cshader.getShader();
                if (shaders.contains(shader)) continue;
                shaders.add(shader);
            }
        }
        return shaders.toArray(new Shader[0]);
    }

    public static void main(String[] args) {
        LogUtils.getLogger((String)"uk.ac.starlink.ttools").setLevel(Level.WARNING);
        String usage = "\n   Usage: " + ShaderLegend.class.getName() + " [-ncol <n>] [-abs|-noabs]\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Predicate<Shader> filter = s -> true;
        int ncol = 2;
        boolean writeHelp = false;
        Iterator argIt = argList.iterator();
        while (argIt.hasNext()) {
            Shader[] arg = (Shader[])argIt.next();
            if ("-abs".equals(arg)) {
                argIt.remove();
                filter = s -> s.isAbsolute();
                continue;
            }
            if ("-noabs".equals(arg)) {
                argIt.remove();
                filter = s -> !s.isAbsolute();
                continue;
            }
            if ("-ncol".equals(arg) && argIt.hasNext()) {
                argIt.remove();
                ncol = Integer.parseInt((String)argIt.next());
                argIt.remove();
                continue;
            }
            writeHelp = true;
        }
        if (writeHelp || argList.size() > 0) {
            System.err.println(usage);
            System.exit(1);
        }
        ArrayList<Shader> list = new ArrayList<Shader>();
        for (Shader shader : ShaderLegend.getAllShaders()) {
            if (!filter.test(shader)) continue;
            list.add(shader);
        }
        Shader[] shaders = list.toArray(new Shader[0]);
        System.out.println(new ShaderLegend(ncol).toSvg(shaders));
    }
}

