/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.calc;

import java.util.Iterator;
import uk.ac.starlink.ttools.calc.ColumnCalculatorFilter;
import uk.ac.starlink.ttools.calc.SchlegelCalculator;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class SchlegelFilter
extends ColumnCalculatorFilter<SchlegelCalculator.Spec> {
    public SchlegelFilter() {
        super("addschlegel", SchlegelFilter.createUsage(), new SchlegelCalculator());
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Adds columns giving Schlegel dust values", "at a given sky position (J2000).", "Some or all of E(B-V) Reddening, 100 Micro Emission,", "and Dust Temperature can be added.", "By default the value averaged over an area (5 degrees?)", "is returned, but other statistics can be requested as well", "or instead.", "</p>", "<p>An example invocation would be:", "<pre>" + this.getName() + " -results emission -stats mean,std</pre>", "giving the mean and standard deviation for just the", "100 micron emission quantity.", "</p>", "<p>This uses the service described at", "<webref url='http://irsa.ipac.caltech.edu/applications/DUST/'/>.", "</p>", SchlegelFilter.explainSyntax(new String[]{"ra-expr", "dec-expr"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String[] tupleExprs = new String[2];
        SchlegelCalculator.ResultType[] rtypes = SchlegelCalculator.ResultType.values();
        SchlegelCalculator.Statistic[] stats = new SchlegelCalculator.Statistic[]{SchlegelCalculator.DEFAULT_STAT};
        String raExpr = null;
        String decExpr = null;
        while (argIt.hasNext() && (raExpr == null || decExpr == null)) {
            String arg = argIt.next();
            if (arg.equals("-results") && argIt.hasNext()) {
                argIt.remove();
                String resultTxt = argIt.next();
                argIt.remove();
                rtypes = SchlegelFilter.decodeResultTypes(resultTxt);
                continue;
            }
            if (arg.equals("-stats") && argIt.hasNext()) {
                argIt.remove();
                String statTxt = argIt.next();
                argIt.remove();
                stats = SchlegelFilter.decodeStats(statTxt);
                continue;
            }
            if (raExpr == null) {
                argIt.remove();
                raExpr = arg;
                continue;
            }
            if (decExpr != null) continue;
            argIt.remove();
            decExpr = arg;
        }
        if (raExpr == null || decExpr == null) {
            throw new ArgException("No ra/dec specified");
        }
        return this.createCalcStep(new String[]{raExpr, decExpr}, new SchlegelCalculator.Spec(rtypes, stats));
    }

    private static SchlegelCalculator.ResultType[] decodeResultTypes(String txt) throws ArgException {
        String[] words = SchlegelFilter.splitEnumList(txt);
        int nword = words.length;
        SchlegelCalculator.ResultType[] rtypes = new SchlegelCalculator.ResultType[nword];
        for (int iw = 0; iw < nword; ++iw) {
            String word = words[iw];
            try {
                rtypes[iw] = SchlegelCalculator.ResultType.valueOf(word.toUpperCase());
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ArgException("No such result type \"" + word + "\"");
            }
        }
        return rtypes;
    }

    private static SchlegelCalculator.Statistic[] decodeStats(String txt) throws ArgException {
        String[] words = SchlegelFilter.splitEnumList(txt);
        int nword = words.length;
        SchlegelCalculator.Statistic[] stats = new SchlegelCalculator.Statistic[nword];
        for (int iw = 0; iw < nword; ++iw) {
            String word = words[iw];
            try {
                stats[iw] = SchlegelCalculator.Statistic.valueOf(word.toUpperCase());
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ArgException("No such statistic \"" + word + "\"");
            }
        }
        return stats;
    }

    private static String[] splitEnumList(String txt) {
        return txt.split(" *, *");
    }

    private static String createUsage() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[-results (");
        SchlegelCalculator.ResultType[] resultTypes = SchlegelCalculator.ResultType.values();
        for (int ir = 0; ir < resultTypes.length; ++ir) {
            if (ir > 0) {
                sbuf.append("|");
            }
            sbuf.append(resultTypes[ir].toString().toLowerCase());
        }
        sbuf.append(")[,...]]");
        sbuf.append("\n");
        sbuf.append("[-stats (");
        SchlegelCalculator.Statistic[] stats = SchlegelCalculator.Statistic.values();
        for (int is = 0; is < stats.length; ++is) {
            if (is > 0) {
                sbuf.append("|");
            }
            sbuf.append(stats[is].toString().toLowerCase());
        }
        sbuf.append(")[,...]]");
        sbuf.append("\n");
        sbuf.append("<ra-expr> <dec-expr>");
        return sbuf.toString();
    }
}

