/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.cone.ColumnPlan;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.QuerySequenceFactory;
import uk.ac.starlink.ttools.cone.RowMapper;
import uk.ac.starlink.ttools.cone.ServiceFindMode;
import uk.ac.starlink.ttools.cone.UploadMatcher;
import uk.ac.starlink.ttools.cone.WrapperQuerySequence;
import uk.ac.starlink.util.Bi;

public class BlockUploader {
    private final UploadMatcher umatcher_;
    private final int blocksize_;
    private final long maxrec_;
    private final String outName_;
    private final JoinFixAction uploadFixAct_;
    private final JoinFixAction remoteFixAct_;
    private final ServiceFindMode serviceMode_;
    private final boolean oneToOne_;
    private final boolean uploadEmpty_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public BlockUploader(UploadMatcher umatcher, int blocksize, long maxrec, String outName, JoinFixAction uploadFixAct, JoinFixAction remoteFixAct, ServiceFindMode serviceMode, boolean oneToOne, boolean uploadEmpty) {
        this.umatcher_ = umatcher;
        this.blocksize_ = blocksize;
        this.maxrec_ = maxrec;
        this.outName_ = outName;
        this.uploadFixAct_ = uploadFixAct;
        this.remoteFixAct_ = remoteFixAct;
        this.serviceMode_ = serviceMode;
        this.oneToOne_ = oneToOne;
        this.uploadEmpty_ = uploadEmpty;
        if (this.oneToOne_ && !serviceMode.supportsOneToOne()) {
            throw new IllegalArgumentException("Mode " + (Object)((Object)serviceMode) + " doesn't support 1:1");
        }
        if (blocksize <= 0) {
            throw new IllegalArgumentException("Non-positive blocksize");
        }
    }

    public Bi<StarTable, BlockStats> runMatch(StarTable inTable, QuerySequenceFactory qsFact, StoragePolicy storage) throws IOException {
        XmatchOutputTable outTable;
        int nrRes;
        if (!inTable.isRandom()) {
            throw new IllegalArgumentException("non-random input table");
        }
        ConeQueryRowSequence coneSeq = qsFact.createQuerySequence(inTable);
        RowStore rawResultStore = storage.makeRowStore();
        long nrow = inTable.getRowCount();
        LongMapper rowMapper = nrow >= 0L && nrow < Integer.MAX_VALUE ? new IntegerMapper() : new LongMapper();
        int nOverflow = 0;
        long totOut = 0L;
        boolean done = false;
        int iblock = 0;
        while (!(done || this.maxrec_ >= 0L && totOut >= this.maxrec_)) {
            PreviewBlockSequence blockSeq = new PreviewBlockSequence(coneSeq, this.blocksize_);
            boolean isFirst = iblock == 0;
            boolean hasNext = blockSeq.hasNext();
            if (isFirst && !hasNext && !this.uploadEmpty_) {
                throw new IOException("No candidate rows for upload match");
            }
            if (hasNext || isFirst) {
                BlockSink blockSink = new BlockSink((TableSink)rawResultStore, isFirst);
                long nRemain = this.maxrec_ >= 0L ? this.maxrec_ - totOut : -1L;
                boolean over = this.umatcher_.streamRawResult(blockSeq, blockSink, rowMapper, nRemain);
                int nIn = blockSeq.getProducedCount();
                long nOut = blockSink.getCount();
                nOverflow += over ? 1 : 0;
                logger_.info("Match block " + (iblock + 1) + ": " + nIn + " uploaded, " + nOut + " received" + (over ? " (truncated)" : ""));
                if (over) {
                    logger_.warning("Block " + (iblock + 1) + " truncated at " + nOut + " rows");
                }
                totOut += nOut;
                ++iblock;
            }
            done = !hasNext;
        }
        final int nblock = iblock;
        coneSeq.close();
        rawResultStore.endRows();
        StarTable rawResult = rawResultStore.getStarTable();
        if (this.serviceMode_.isRemoteUnique() && nblock > 1) {
            logger_.warning("Bug: a remote row may appear up to " + nblock + " times, not just once, in the result");
        }
        ColumnInfo[] rawCols = Tables.getColumnInfos((StarTable)rawResult);
        ColumnInfo[] inCols = Tables.getColumnInfos((StarTable)inTable);
        ColumnPlan cplan = this.umatcher_.getColumnPlan(rawCols, inCols);
        Tables.fixColumns((ColumnInfo[][])new ColumnInfo[][]{rawCols, inCols}, (JoinFixAction[])new JoinFixAction[]{this.remoteFixAct_, this.uploadFixAct_});
        int icolId = cplan.getResultIdColumnIndex();
        if (this.oneToOne_) {
            nrRes = Tables.checkedLongToInt((long)rawResult.getRowCount());
            int nrUp = Tables.checkedLongToInt((long)inTable.getRowCount());
            IrowPair[] irPairs = new IrowPair[nrUp];
            for (int irUp = 0; irUp < nrUp; ++irUp) {
                irPairs[irUp] = new IrowPair(-1L, irUp);
            }
            for (int irRes = 0; irRes < nrRes; ++irRes) {
                Object idUp = rawResult.getCell((long)irRes, icolId);
                long irUp = BlockUploader.rowIdToIndex(rowMapper, idUp);
                irPairs[Tables.checkedLongToInt((long)irUp)] = new IrowPair(irRes, irUp);
            }
            outTable = new XmatchOutputTable(rawResult, inTable, cplan, irPairs);
        } else {
            nrRes = Tables.checkedLongToInt((long)rawResult.getRowCount());
            IrowPair[] irPairs = new IrowPair[nrRes];
            for (int ir = 0; ir < nrRes; ++ir) {
                Object idUp = rawResult.getCell((long)ir, icolId);
                irPairs[ir] = new IrowPair(ir, BlockUploader.rowIdToIndex(rowMapper, idUp));
            }
            outTable = new XmatchOutputTable(rawResult, inTable, cplan, irPairs);
        }
        final int nover = nOverflow;
        BlockStats blockStats = new BlockStats(){

            @Override
            public int getBlockCount() {
                return nblock;
            }

            @Override
            public int getTruncatedBlockCount() {
                return nover;
            }
        };
        outTable.setName(this.outName_);
        return new Bi((Object)outTable, (Object)blockStats);
    }

    private static <I> long rowIdToIndex(RowMapper<I> rowMapper, Object id) {
        return rowMapper.rowIdToIndex(rowMapper.getIdClass().cast(id));
    }

    private static class IrowPair {
        final long irRes_;
        final long irUp_;

        IrowPair(long irRes, long irUp) {
            this.irRes_ = irRes;
            this.irUp_ = irUp;
        }
    }

    private static class LongMapper
    implements RowMapper<Long> {
        private LongMapper() {
        }

        @Override
        public Class<Long> getIdClass() {
            return Long.class;
        }

        @Override
        public long rowIdToIndex(Long id) {
            return id;
        }

        @Override
        public Long rowIndexToId(long index) {
            return index;
        }
    }

    private static class IntegerMapper
    implements RowMapper<Integer> {
        private IntegerMapper() {
        }

        @Override
        public Class<Integer> getIdClass() {
            return Integer.class;
        }

        @Override
        public long rowIdToIndex(Integer id) {
            return id.longValue();
        }

        @Override
        public Integer rowIndexToId(long index) {
            return this.toInt(index);
        }

        private int toInt(long lval) {
            int ival = (int)lval;
            if ((long)ival != lval) {
                throw new IllegalArgumentException("Should have used long");
            }
            return ival;
        }
    }

    private static class BlockSink
    implements TableSink {
        private final TableSink baseSink_;
        private final boolean isFirst_;
        private long nrow_;

        public BlockSink(TableSink baseSink, boolean isFirst) {
            this.baseSink_ = baseSink;
            this.isFirst_ = isFirst;
        }

        public void acceptMetadata(StarTable meta) throws TableFormatException {
            if (this.isFirst_) {
                this.baseSink_.acceptMetadata(meta);
            }
        }

        public void acceptRow(Object[] row) throws IOException {
            this.baseSink_.acceptRow(row);
            ++this.nrow_;
        }

        public void endRows() {
        }

        public long getCount() {
            return this.nrow_;
        }
    }

    private static class BlockSequence
    extends WrapperQuerySequence {
        private final int maxrow_;
        private int nProduced_;
        private int nConsumed_;

        BlockSequence(ConeQueryRowSequence baseSeq, int maxrow) {
            super(baseSeq);
            this.maxrow_ = maxrow;
        }

        public boolean next() throws IOException {
            while (this.nProduced_ < this.maxrow_ && super.next()) {
                ++this.nConsumed_;
                if (!this.isPossibleMatch()) continue;
                ++this.nProduced_;
                return true;
            }
            return false;
        }

        public void close() throws IOException {
        }

        public int getConsumedCount() {
            return this.nConsumed_;
        }

        public int getProducedCount() {
            return this.nProduced_;
        }

        private boolean isPossibleMatch() throws IOException {
            double ra = this.getRa();
            double dec = this.getDec();
            return !Double.isNaN(ra) && dec >= -90.0 && dec <= 90.0;
        }
    }

    private static class PreviewBlockSequence
    extends BlockSequence {
        private Boolean hasNext_;

        PreviewBlockSequence(ConeQueryRowSequence baseSeq, int maxrow) {
            super(baseSeq, maxrow);
        }

        @Override
        public final boolean next() throws IOException {
            this.readyNext();
            boolean hasNext = this.hasNext_;
            this.hasNext_ = null;
            return hasNext;
        }

        public boolean hasNext() throws IOException {
            this.readyNext();
            return this.hasNext_;
        }

        private void readyNext() throws IOException {
            if (this.hasNext_ == null) {
                this.hasNext_ = super.next();
            }
        }
    }

    private static class ColTable
    extends WrapperStarTable {
        private final ColumnInfo[] colInfos_;

        ColTable(StarTable base, ColumnInfo[] colInfos) {
            super(base);
            this.colInfos_ = colInfos;
        }

        public ColumnInfo getColumnInfo(int ic) {
            return this.colInfos_[ic];
        }
    }

    private static class XmatchOutputTable
    extends RandomStarTable {
        private final StarTable rawResult_;
        private final StarTable uploadTable_;
        private final ColumnPlan cplan_;
        private final IrowPair[] irPairs_;
        private final int ncol_;

        XmatchOutputTable(StarTable rawResult, StarTable uploadTable, ColumnPlan cplan, IrowPair[] irPairs) {
            this.rawResult_ = rawResult;
            this.uploadTable_ = uploadTable;
            this.cplan_ = cplan;
            this.irPairs_ = irPairs;
            this.ncol_ = cplan.getOutputColumnCount();
            this.getParameters().addAll(rawResult.getParameters());
            if (!rawResult.isRandom() || !uploadTable.isRandom()) {
                throw new IllegalArgumentException("Non-random input table");
            }
        }

        public long getRowCount() {
            return this.irPairs_.length;
        }

        public int getColumnCount() {
            return this.ncol_;
        }

        public ColumnInfo getColumnInfo(int icol) {
            int loc = this.cplan_.getOutputColumnLocation(icol);
            return loc >= 0 ? this.rawResult_.getColumnInfo(loc) : this.uploadTable_.getColumnInfo(-loc - 1);
        }

        public Object getCell(long irow, int icol) throws IOException {
            int loc = this.cplan_.getOutputColumnLocation(icol);
            IrowPair irPair = this.irPairs_[Tables.checkedLongToInt((long)irow)];
            if (loc >= 0) {
                long ir = irPair.irRes_;
                return ir >= 0L ? this.rawResult_.getCell(ir, loc) : null;
            }
            long ir = irPair.irUp_;
            return ir >= 0L ? this.uploadTable_.getCell(ir, -loc - 1) : null;
        }

        public Object[] getRow(long irow) throws IOException {
            IrowPair irPair = this.irPairs_[Tables.checkedLongToInt((long)irow)];
            long irRes = irPair.irRes_;
            long irUp = irPair.irUp_;
            Object[] resRow = irRes >= 0L ? this.rawResult_.getRow(irRes) : null;
            Object[] upRow = irUp >= 0L ? this.uploadTable_.getRow(irUp) : null;
            Object[] row = new Object[this.ncol_];
            for (int icol = 0; icol < this.ncol_; ++icol) {
                int loc = this.cplan_.getOutputColumnLocation(icol);
                if (loc >= 0) {
                    if (resRow == null) continue;
                    row[icol] = resRow[loc];
                    continue;
                }
                if (upRow == null) continue;
                row[icol] = upRow[-loc - 1];
            }
            return row;
        }
    }

    public static interface BlockStats {
        public int getBlockCount();

        public int getTruncatedBlockCount();
    }
}

