/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.healpix.FlatHashIterator;
import cds.healpix.Healpix;
import cds.healpix.HealpixNestedBMOC;
import cds.moc.HealpixImpl;
import uk.ac.starlink.table.Tables;

public class CdsHealpix
implements HealpixImpl {
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final CdsHealpix instance_ = new CdsHealpix();

    private CdsHealpix() {
    }

    public long ang2pix(int order, double lonDeg, double latDeg) {
        return Healpix.getNestedFast((int)order).hash(lonDeg * (Math.PI / 180), latDeg * (Math.PI / 180));
    }

    public double[] pix2ang(int order, long ipix) {
        double[] pos = new double[2];
        Healpix.getNestedFast((int)order).center(ipix, pos);
        pos[0] = pos[0] * 57.29577951308232;
        pos[1] = pos[1] * 57.29577951308232;
        return pos;
    }

    public long[] queryDisc(int order, double lonDeg, double latDeg, double radiusDeg) {
        HealpixNestedBMOC bmoc = Healpix.getNested((int)order).newConeComputerApprox(radiusDeg * (Math.PI / 180)).overlappingCells(lonDeg * (Math.PI / 180), latDeg * (Math.PI / 180));
        int ntile = Tables.checkedLongToInt((long)bmoc.computeDeepSize());
        long[] itiles = new long[ntile];
        FlatHashIterator fhit = bmoc.flatHashIterator();
        for (int itile = 0; itile < ntile; ++itile) {
            assert (fhit.hasNext());
            itiles[itile] = fhit.next();
        }
        assert (!fhit.hasNext());
        return itiles;
    }

    public static CdsHealpix getInstance() {
        return instance_;
    }
}

