/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;

public class ColumnQueryRowSequence
extends WrapperRowSequence
implements ConeQueryRowSequence {
    private final int raCol_;
    private final int decCol_;
    private final int srCol_;
    private long index_;

    public ColumnQueryRowSequence(StarTable table, int raCol, int decCol, int srCol) throws IOException {
        super(table.getRowSequence());
        this.raCol_ = raCol;
        this.decCol_ = decCol;
        this.srCol_ = srCol;
        this.index_ = -1L;
    }

    @Override
    public double getRa() throws IOException {
        return this.getDoubleCell(this.raCol_);
    }

    @Override
    public double getDec() throws IOException {
        return this.getDoubleCell(this.decCol_);
    }

    @Override
    public double getRadius() throws IOException {
        return this.getDoubleCell(this.srCol_);
    }

    @Override
    public long getIndex() {
        return this.index_;
    }

    public boolean next() throws IOException {
        if (super.next()) {
            ++this.index_;
            return true;
        }
        return false;
    }

    private double getDoubleCell(int colIndex) throws IOException {
        Object value = this.getCell(colIndex);
        return value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
    }

    public static ConeQueryRowSequence createFixedRadiusSequence(StarTable table, int raCol, int decCol, final double sr) throws IOException {
        return new ColumnQueryRowSequence(table, raCol, decCol, -1){

            @Override
            public double getRadius() {
                return sr;
            }
        };
    }
}

