/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.healpix.Healpix;
import cds.moc.SMoc;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.ttools.cone.CdsHealpix;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.JELQuerySequenceFactory;
import uk.ac.starlink.ttools.cone.MocCoverage;
import uk.ac.starlink.util.LogUtils;

public class ConeQueryCoverage
extends MocCoverage {
    private ConeQueryRowSequence qseq_;
    private final double resolutionDeg_;

    public ConeQueryCoverage(ConeQueryRowSequence qseq, double resolutionDeg) {
        super(CdsHealpix.getInstance());
        this.qseq_ = qseq;
        this.resolutionDeg_ = resolutionDeg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SMoc createMoc() throws IOException {
        SMoc moc;
        Nsider nsider = new Nsider();
        int maxOrder = Math.min(nsider.calcOrder(this.resolutionDeg_), 29);
        try {
            moc = new SMoc(maxOrder);
        }
        catch (Exception e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Trouble creating SMoc??"))).initCause(e);
        }
        moc.bufferOn();
        try {
            CdsHealpix healpix = CdsHealpix.getInstance();
            while (this.qseq_.next()) {
                long[] pixels;
                if (Thread.interrupted()) {
                    throw new InterruptedIOException();
                }
                double ra = this.qseq_.getRa();
                double dec = this.qseq_.getDec();
                double radius = this.qseq_.getRadius();
                if (Double.isNaN(ra) || !(dec >= -90.0) || !(dec <= 90.0) || !(radius >= 0.0)) continue;
                int order = radius <= this.resolutionDeg_ ? maxOrder : nsider.calcOrder(radius);
                try {
                    pixels = healpix.queryDisc(order, ra, dec, radius);
                }
                catch (Exception e) {
                    throw (IOException)new IOException("HEALPix processing error").initCause(e);
                }
                for (int ip = 0; ip < pixels.length; ++ip) {
                    try {
                        moc.add(order, pixels[ip]);
                        continue;
                    }
                    catch (Exception e) {
                        throw (IOException)new IOException("HEALPix processing error").initCause(e);
                    }
                }
            }
            moc.bufferOff();
            SMoc sMoc = moc;
            return sMoc;
        }
        finally {
            try {
                this.qseq_.close();
            }
            catch (IOException iOException) {}
            this.qseq_ = null;
        }
    }

    public static void main(String[] args) throws IOException {
        LogUtils.getLogger((String)"uk.ac.starlink").setLevel(Level.WARNING);
        double resDeg = 1.0;
        String tname = args[0];
        String raExpr = args[1];
        String decExpr = args[2];
        String srExpr = args[3];
        ConeQueryRowSequence qseq = new JELQuerySequenceFactory(raExpr, decExpr, srExpr).createQuerySequence(new StarTableFactory().makeStarTable(tname));
        long start = System.currentTimeMillis();
        SMoc moc = new ConeQueryCoverage(qseq, resDeg).createMoc();
        long time = System.currentTimeMillis() - start;
        System.out.println(ConeQueryCoverage.summariseMoc(moc));
        System.out.println("time: " + time + " ms");
    }

    private static class Nsider {
        private Nsider() {
        }

        synchronized int calcOrder(double sizeDeg) {
            return Math.max(0, Healpix.getBestStartingDepth((double)Math.toRadians(sizeDeg)));
        }
    }
}

