/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.net.URL;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.ConeServiceType;
import uk.ac.starlink.ttools.cone.Coner;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.task.ContentCodingParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.util.ContentCoding;

public class ConeSearchConer
implements Coner {
    private final URLParameter urlParam_;
    private final ChoiceParameter<String> verbParam_;
    private final ChoiceParameter<ConeServiceType> serviceParam_;
    private final BooleanParameter believeemptyParam_;
    private final ContentCodingParameter codingParam_;
    private final StringParameter formatParam_;
    private int nside_ = -1;
    private static final String BELIEVE_EMPTY_NAME = "emptyok";
    private static final String INCONSISTENT_EMPTY_ADVICE = "emptyok=false";

    public ConeSearchConer() {
        Object[] serviceTypes = ConeServiceType.getAllTypes();
        this.urlParam_ = new URLParameter("serviceurl");
        this.urlParam_.setPrompt("Base URL for query returning VOTable");
        this.urlParam_.setDescription(new String[]{"<p>The base part of a URL which defines the queries to be made.", "Additional parameters will be appended to this using CGI syntax", "(\"<code>name=value</code>\", separated by '&amp;' characters).", "If this value does not end in either a '?' or a '&amp;',", "one will be added as appropriate.", "</p>", "<p>See <ref id='coneService'/> for discussion of how to locate", "service URLs corresponding to given datasets.", "</p>"});
        this.serviceParam_ = new ChoiceParameter("servicetype", serviceTypes);
        this.serviceParam_.setPrompt("Search service type");
        StringBuffer typesDescrip = new StringBuffer();
        for (Object stype : serviceTypes) {
            typesDescrip.append("<li>").append("<code>").append(stype).append("</code>:\n").append(((ConeServiceType)stype).getDescription()).append("</li>").append("\n");
        }
        this.serviceParam_.setDescription(new String[]{"<p>Selects the type of data access service to contact.", "Most commonly this will be the Cone Search service itself,", "but there are one or two other possibilities:", "<ul>", typesDescrip.toString(), "</ul>", "</p>"});
        this.serviceParam_.setDefaultOption(serviceTypes[0]);
        this.verbParam_ = new ChoiceParameter("verb", (Object[])new String[]{"1", "2", "3"});
        this.verbParam_.setNullPermitted(true);
        this.verbParam_.setPrompt("Verbosity level of search responses (1..3)");
        this.verbParam_.setDescription(new String[]{"<p>Verbosity level of the tables returned by the query service.", "A value of 1 indicates the bare minimum and", "3 indicates all available information.", "</p>"});
        this.believeemptyParam_ = new BooleanParameter(BELIEVE_EMPTY_NAME);
        this.believeemptyParam_.setBooleanDefault(true);
        this.believeemptyParam_.setPrompt("Believe metadata from empty results?");
        this.believeemptyParam_.setDescription(new String[]{"<p>Whether the table metadata which is returned from a search", "result with zero rows is to be believed.", "According to the spirit, though not the letter, of the", "cone search standard, a cone search service which returns no data", "ought nevertheless to return the correct column headings.", "Unfortunately this is not always the case.", "If this parameter is set <code>true</code>, it is assumed", "that the service behaves properly in this respect; if it does not", "an error may result.  In that case, set this parameter", "<code>false</code>.  A consequence of setting it false is that", "in the event of no results being returned, the task will", "return no table at all, rather than an empty one.", "</p>"});
        this.codingParam_ = new ContentCodingParameter();
        this.formatParam_ = new StringParameter("dataformat");
        this.formatParam_.setPrompt("Data format type for DAL outputs");
        this.formatParam_.setNullPermitted(true);
        StringBuffer formatsDescrip = new StringBuffer();
        for (Object stype : serviceTypes) {
            formatsDescrip.append("<li>").append("<code>").append(this.serviceParam_.getName()).append("=").append(stype).append("</code>:\n").append(((ConeServiceType)stype).getFormatDescription()).append("</li>").append("\n");
        }
        this.formatParam_.setDescription(new String[]{"<p>Indicates the format of data objects described in the", "returned table.", "The meaning of this is dependent on the value of the", "<code>" + this.serviceParam_.getName() + "</code>", "parameter:", "<ul>", formatsDescrip.toString(), "</ul>", "</p>"});
    }

    @Override
    public String getSkySystem() {
        return "ICRS";
    }

    @Override
    public Parameter<?>[] getParameters() {
        return new Parameter[]{this.serviceParam_, this.urlParam_, this.verbParam_, this.formatParam_, this.believeemptyParam_, this.codingParam_};
    }

    public Parameter<URL> getServiceUrlParameter() {
        return this.urlParam_;
    }

    public Parameter<ConeServiceType> getServiceTypeParameter() {
        return this.serviceParam_;
    }

    public Parameter<String> getFormatParameter() {
        return this.formatParam_;
    }

    public Parameter<String> getVerbosityParameter() {
        return this.verbParam_;
    }

    @Override
    public void configureRadiusParam(Environment env, Parameter<?> srParam) throws TaskException {
        if (Double.class.isAssignableFrom(srParam.getValueClass())) {
            Parameter<?> dsrParam = srParam;
            ((ConeServiceType)this.serviceParam_.objectValue(env)).configureRadiusParam(dsrParam);
        } else assert (false);
    }

    @Override
    public boolean useDistanceFilter(Environment env) throws TaskException {
        return ((ConeServiceType)this.serviceParam_.objectValue(env)).useDistanceFilter();
    }

    @Override
    public ConeSearcher createSearcher(Environment env, boolean bestOnly) throws TaskException {
        ConeServiceType serviceType = (ConeServiceType)this.serviceParam_.objectValue(env);
        URL url = (URL)this.urlParam_.objectValue(env);
        boolean believeEmpty = this.believeemptyParam_.booleanValue(env);
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        ContentCoding coding = this.codingParam_.codingValue(env);
        return serviceType.createMultiSearcher(env, this, url.toString(), believeEmpty, tfact, coding);
    }

    @Override
    public Coverage getCoverage(Environment env) throws TaskException {
        ConeServiceType serviceType = (ConeServiceType)this.serviceParam_.objectValue(env);
        URL url = (URL)this.urlParam_.objectValue(env);
        return serviceType.getCoverage(url, this.nside_);
    }

    public void setNside(int nside) {
        this.nside_ = nside;
    }
}

