/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import edu.jhu.htm.core.Domain;
import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.geometry.Circle;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.cone.SkyTiling;
import uk.ac.starlink.ttools.func.Tilings;

public class HtmTiling
implements SkyTiling {
    private final HTMindexImp htm_;
    private final int level_;
    private final double resolution_;

    public HtmTiling(HTMindexImp htm) {
        this.htm_ = htm;
        this.level_ = htm.maxlevel_;
        this.resolution_ = Tilings.htmResolution(this.level_);
    }

    public HtmTiling(int level) {
        this(new HTMindexImp(level));
        assert (this.level_ == level);
    }

    @Override
    public long getPixelCount() {
        return 8L << 2 * this.level_;
    }

    @Override
    public ValueInfo getIndexInfo() {
        String name = "htm" + this.level_;
        Class clazz = this.level_ <= 14 ? Integer.class : Long.class;
        String descrip = "HTM index at level " + this.level_;
        DefaultValueInfo info = new DefaultValueInfo(name, clazz, descrip);
        info.setUCD("pos.HTM");
        return info;
    }

    @Override
    public long getPositionTile(double ra, double dec) {
        try {
            return this.htm_.lookupId(ra, dec);
        }
        catch (HTMException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("HTM error: " + e.getMessage()).initCause(e);
        }
    }

    @Override
    public long[] getTileRange(double ra, double dec, double radius) {
        long[] lArray;
        long[] lohi;
        if (radius > this.resolution_ * 50.0) {
            return null;
        }
        Circle zone = new Circle(ra, dec, radius * 60.0);
        Domain domain = zone.getDomain();
        domain.setOlevel(this.level_);
        HTMrange range = new HTMrange();
        domain.intersect(this.htm_, range, false);
        long lo = Long.MAX_VALUE;
        long hi = Long.MIN_VALUE;
        range.reset();
        while (!HtmTiling.endRange(lohi = range.getNext())) {
            lo = Math.min(lo, lohi[0]);
            hi = Math.max(hi, lohi[1]);
        }
        if (lo <= hi) {
            long[] lArray2 = new long[2];
            lArray2[0] = lo;
            lArray = lArray2;
            lArray2[1] = hi;
        } else {
            lArray = null;
        }
        return lArray;
    }

    public String toString() {
        return "htm" + this.level_;
    }

    private static boolean endRange(long[] lohi) {
        return lohi[0] == 0L && lohi[1] == 0L;
    }
}

