/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.healpix.Healpix;
import cds.healpix.HealpixNestedBMOC;
import cds.moc.HealpixImpl;
import cds.moc.SMoc;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.cone.CdsHealpix;
import uk.ac.starlink.ttools.cone.Coverage;

public abstract class MocCoverage
implements Coverage {
    private final HealpixImpl hpi_;
    private volatile SMoc moc_;
    private volatile Coverage.Amount amount_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");
    public static final HealpixImpl DFLT_HPI = CdsHealpix.getInstance();

    protected MocCoverage() {
        this(DFLT_HPI);
    }

    protected MocCoverage(HealpixImpl hpi) {
        this.hpi_ = hpi;
    }

    protected abstract SMoc createMoc() throws IOException;

    @Override
    public synchronized void initCoverage() throws IOException {
        if (this.amount_ == null) {
            assert (this.moc_ == null);
            try {
                this.moc_ = this.createMoc();
            }
            finally {
                this.amount_ = MocCoverage.determineAmount(this.moc_);
                assert (this.amount_ != null);
            }
        }
    }

    @Override
    public Coverage.Amount getAmount() {
        return this.amount_;
    }

    @Override
    public boolean discOverlaps(double alphaDeg, double deltaDeg, double radiusDeg) {
        this.checkInitialised();
        Boolean knownResult = this.amount_.getKnownResult();
        if (knownResult != null) {
            return knownResult;
        }
        int mocOrder = this.moc_.getMocOrder();
        double alphaRad = Math.toRadians(alphaDeg);
        double deltaRad = Math.toRadians(deltaDeg);
        double radiusRad = Math.toRadians(radiusDeg);
        try {
            long centerPixel = this.hpi_.ang2pix(mocOrder, alphaDeg, deltaDeg);
            if (this.moc_.isIntersecting(mocOrder, centerPixel)) {
                return true;
            }
            if (radiusDeg == 0.0) {
                return false;
            }
            int scanOrder = mocOrder;
            int orderLimit = Healpix.getBestStartingDepth((double)(radiusRad * 0.01));
            if (scanOrder > orderLimit) {
                logger_.config("Limit MOC order " + scanOrder + " -> " + orderLimit + " for radius " + radiusDeg + "deg");
                scanOrder = orderLimit;
            }
            HealpixNestedBMOC bmoc = Healpix.getNested((int)mocOrder).newConeComputerApprox(radiusRad).overlappingCells(alphaRad, deltaRad);
            for (HealpixNestedBMOC.CurrentValueAccessor vac : bmoc) {
                if (!this.moc_.isIntersecting(vac.getDepth(), vac.getHash())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Unexpected MOC error - fail safe", e);
            return true;
        }
    }

    public SMoc getMoc() {
        return this.moc_;
    }

    private void checkInitialised() {
        if (this.amount_ == null) {
            throw new IllegalStateException("Not initialised");
        }
    }

    static String summariseMoc(SMoc moc) {
        return new StringBuffer().append("Fraction: ").append((float)moc.getCoverage()).append(", ").append("Pixels: ").append(moc.getNbCoding()).append(", ").append("Bytes: ").append(moc.getMem()).append(", ").append("Order: ").append(moc.getMocOrder()).toString();
    }

    private static Coverage.Amount determineAmount(SMoc moc) {
        if (moc == null) {
            return Coverage.Amount.NO_DATA;
        }
        double frac = moc.getCoverage();
        if (frac == 0.0) {
            return Coverage.Amount.NO_SKY;
        }
        if (frac == 1.0) {
            return Coverage.Amount.ALL_SKY;
        }
        return Coverage.Amount.SOME_SKY;
    }
}

