/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.DalConeSearcher;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.SiaFormatOption;
import uk.ac.starlink.vo.SiaVersion;

public class SiaConeSearcher
extends DalConeSearcher
implements ConeSearcher {
    private final String serviceUrl_;
    private final SiaVersion siaVersion_;
    private final SiaFormatOption format_;
    private final StarTableFactory tfact_;
    private final ContentCoding coding_;

    public SiaConeSearcher(String serviceUrl, SiaVersion siaVersion, SiaFormatOption format, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) {
        super("SIA", Integer.toString(siaVersion.getMajorVersion()), believeEmpty);
        this.serviceUrl_ = serviceUrl;
        this.siaVersion_ = siaVersion;
        this.format_ = format;
        this.tfact_ = tfact;
        this.coding_ = coding;
    }

    @Override
    public StarTable performSearch(double ra, double dec, double sr) throws IOException {
        StarTable table = this.siaVersion_.executeQuery(this.serviceUrl_, ra, dec, sr * 2.0, this.format_, this.tfact_, this.coding_);
        return this.getConsistentTable(table);
    }

    @Override
    public int getRaIndex(StarTable result) {
        return this.siaVersion_.usesUcd1() ? this.getUcd1RaIndex(result) : SiaConeSearcher.getObscoreColumnIndex(result, "s_ra", "pos.eq.ra");
    }

    @Override
    public int getDecIndex(StarTable result) {
        return this.siaVersion_.usesUcd1() ? this.getUcd1DecIndex(result) : SiaConeSearcher.getObscoreColumnIndex(result, "s_dec", "pos.eq.dec");
    }

    @Override
    public void close() {
    }

    private static int getObscoreColumnIndex(StarTable table, String cname, String ucd1p) {
        int ic;
        int nc = table.getColumnCount();
        for (ic = 0; ic < nc; ++ic) {
            if (!cname.equals(table.getColumnInfo(ic).getName())) continue;
            return ic;
        }
        for (ic = 0; ic < nc; ++ic) {
            if (!ucd1p.equals(table.getColumnInfo(ic).getUCD())) continue;
            return ic;
        }
        return -1;
    }
}

