/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.auth.UrlConnector;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.cone.ColumnPlan;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.LimitRowSink;
import uk.ac.starlink.ttools.cone.RowMapper;
import uk.ac.starlink.ttools.cone.ServiceFindMode;
import uk.ac.starlink.ttools.cone.UploadConeTable;
import uk.ac.starlink.ttools.cone.UploadMatcher;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public class TapUploadMatcher
implements UploadMatcher {
    private final IOSupplier<TapService> tapServiceSupplier_;
    private final String tableName_;
    private final String raExpr_;
    private final String decExpr_;
    private final String radiusDegExpr_;
    private final boolean isSync_;
    private final String[] tapCols_;
    private final ServiceFindMode serviceMode_;
    private final int pollMillis_ = 10000;
    private final Map<String, String> extraParams_;
    private final ContentCoding coding_;
    private static final String TABLE_ID = "up";
    private static final String ID_NAME = "tapupload_id";
    private static final String ID_ALIAS = "tapupload_id_a";
    private static final String RA_NAME = "lon";
    private static final String DEC_NAME = "lat";

    public TapUploadMatcher(IOSupplier<TapService> tapServiceSupplier, String tableName, String raExpr, String decExpr, String radiusDegExpr, boolean isSync, String[] tapCols, ServiceFindMode serviceMode, Map<String, String> extraParams, ContentCoding coding) {
        this.tapServiceSupplier_ = tapServiceSupplier;
        this.tableName_ = tableName;
        this.raExpr_ = raExpr;
        this.decExpr_ = decExpr;
        this.radiusDegExpr_ = radiusDegExpr;
        this.isSync_ = isSync;
        this.tapCols_ = tapCols;
        this.serviceMode_ = serviceMode;
        this.extraParams_ = extraParams;
        this.coding_ = coding;
        if (!Arrays.asList(TapUploadMatcher.getSupportedServiceModes()).contains((Object)serviceMode)) {
            throw new IllegalArgumentException("Unsupported mode: " + (Object)((Object)serviceMode));
        }
    }

    @Override
    public boolean streamRawResult(ConeQueryRowSequence coneSeq, TableSink rawResultSink, RowMapper<?> rowMapper, long maxrec) throws IOException {
        URLConnection conn;
        String adql = this.getAdql(maxrec);
        HashMap<String, UploadConeTable> uploadMap = new HashMap<String, UploadConeTable>();
        uploadMap.put(TABLE_ID, new UploadConeTable(coneSeq, rowMapper, ID_NAME, RA_NAME, DEC_NAME));
        VOTableWriter voWriter = new VOTableWriter(DataFormat.BINARY, true, VOTableVersion.V12);
        TapService tapService = (TapService)this.tapServiceSupplier_.get();
        TapQuery tapQuery = new TapQuery(tapService, adql, this.extraParams_, uploadMap, -1L, voWriter);
        if (this.isSync_) {
            conn = tapQuery.createSyncConnection(this.coding_);
        } else {
            URL url;
            UwsJob job = tapQuery.submitAsync();
            job.start();
            try {
                url = TapQuery.waitForResultUrl((UwsJob)job, (long)10000L);
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Interrupted").initCause(e);
            }
            conn = AuthManager.getInstance().connect(url, (UrlConnector)this.coding_);
        }
        if (this.serviceMode_ == ServiceFindMode.BEST) {
            rawResultSink = new FilterBestSink(rawResultSink);
            if (maxrec >= 0L) {
                rawResultSink = new LimitRowSink(rawResultSink, maxrec);
            }
        }
        try {
            return TapQuery.streamResultVOTable((URLConnection)conn, (ContentCoding)this.coding_, (TableSink)rawResultSink) || rawResultSink instanceof LimitRowSink && ((LimitRowSink)rawResultSink).isTruncated();
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Parse error from TAP service result: " + e).initCause(e);
        }
    }

    @Override
    public ColumnPlan getColumnPlan(ColumnInfo[] resultCols, ColumnInfo[] uploadCols) {
        return new TapColumnPlan(resultCols, uploadCols);
    }

    public String getAdql(long maxrec) {
        String nl = "\n   ";
        String uploadName_ = "TAP_UPLOAD.up1";
        String sysarg = "'ICRS'";
        String uPosargs = new StringBuffer().append(sysarg).append(", u.").append(RA_NAME).append(", u.").append(DEC_NAME).toString();
        String rPosargs = new StringBuffer().append(sysarg).append(", r.").append(this.raExpr_).append(", r.").append(this.decExpr_).toString();
        boolean isBestScore = this.serviceMode_ == ServiceFindMode.BEST_SCORE;
        boolean isBest = this.serviceMode_ == ServiceFindMode.BEST;
        boolean isClientFilter = this.serviceMode_ == ServiceFindMode.BEST;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SELECT");
        if (maxrec >= 0L && !isClientFilter) {
            sbuf.append(nl).append("TOP ").append(maxrec);
        }
        sbuf.append(nl);
        if (!this.serviceMode_.isScoreOnly()) {
            if (this.tapCols_ == null) {
                sbuf.append("r.*, ");
            } else {
                for (String colname : this.tapCols_) {
                    sbuf.append("r.").append(colname).append(", ");
                }
            }
        }
        sbuf.append("u.").append(ID_NAME).append(" AS ").append(ID_ALIAS).append(",");
        sbuf.append(nl);
        if (isBestScore) {
            sbuf.append("MIN(");
        }
        sbuf.append("DISTANCE(POINT(").append(uPosargs).append("),").append(nl);
        if (isBestScore) {
            sbuf.append("    ");
        }
        sbuf.append("         POINT(").append(rPosargs).append("))");
        if (isBestScore) {
            sbuf.append(")");
        }
        sbuf.append("*3600.0").append(" AS SEP_ARCSEC").append(nl).append("FROM ").append(this.tableName_).append(" AS r").append(nl).append("JOIN ").append("TAP_UPLOAD.").append(TABLE_ID).append(" AS u").append(nl).append("ON 1=CONTAINS(POINT(").append(rPosargs).append("),").append(nl).append("              CIRCLE(").append(uPosargs).append(", ").append(this.radiusDegExpr_).append("))");
        if (isBestScore) {
            sbuf.append(nl).append("GROUP BY ").append(ID_ALIAS);
        } else if (isBest) {
            sbuf.append(nl).append("ORDER BY ").append(ID_ALIAS).append(" ASC");
        }
        return sbuf.toString();
    }

    public static ServiceFindMode[] getSupportedServiceModes() {
        return new ServiceFindMode[]{ServiceFindMode.ALL, ServiceFindMode.ALL_SCORE, ServiceFindMode.BEST, ServiceFindMode.BEST_SCORE};
    }

    private static class FilterBestSink
    implements TableSink {
        private final TableSink base_;
        private int icId_;
        private int icScore_;
        private Object currentId_;
        private double bestScore_;
        private Object[] bestRow_;

        public FilterBestSink(TableSink base) {
            this.base_ = base;
        }

        public void acceptMetadata(StarTable meta) throws TableFormatException {
            TapColumnPlan cplan = new TapColumnPlan(Tables.getColumnInfos((StarTable)meta), new ColumnInfo[0]);
            this.icId_ = cplan.getResultIdColumnIndex();
            this.icScore_ = cplan.getResultScoreColumnIndex();
            this.base_.acceptMetadata(meta);
        }

        public void acceptRow(Object[] row) throws IOException {
            double score;
            Object id = row[this.icId_];
            Object scoreObj = row[this.icScore_];
            double d = score = scoreObj instanceof Number ? ((Number)scoreObj).doubleValue() : Double.NaN;
            if (!id.equals(this.currentId_)) {
                this.flushBestRow();
                this.currentId_ = id;
                this.bestScore_ = Double.POSITIVE_INFINITY;
            }
            if (score < this.bestScore_) {
                this.bestScore_ = score;
                this.bestRow_ = (Object[])row.clone();
            }
        }

        public void endRows() throws IOException {
            this.flushBestRow();
            this.base_.endRows();
        }

        private void flushBestRow() throws IOException {
            if (this.bestRow_ != null) {
                this.base_.acceptRow(this.bestRow_);
                this.bestRow_ = null;
            }
        }
    }

    private static class TapColumnPlan
    implements ColumnPlan {
        private final int ncUp_;
        private final int ncRem_;
        private final int ncOut_;
        private final int icId_;
        private final int icDist_;

        TapColumnPlan(ColumnInfo[] resultCols, ColumnInfo[] uploadCols) {
            int ncRes = resultCols.length;
            this.ncUp_ = uploadCols.length;
            this.ncRem_ = ncRes - 2;
            this.ncOut_ = this.ncUp_ + this.ncRem_ + 1;
            this.icId_ = this.ncRem_;
            this.icDist_ = this.ncRem_ + 1;
        }

        @Override
        public int getOutputColumnCount() {
            return this.ncOut_;
        }

        @Override
        public int getOutputColumnLocation(int icolOutput) {
            if (icolOutput < 0) {
                throw new IllegalArgumentException("Out of range");
            }
            if (icolOutput < this.ncUp_) {
                int iUp = icolOutput;
                return -iUp - 1;
            }
            if (icolOutput < this.ncUp_ + this.ncRem_) {
                int iRes = icolOutput - this.ncUp_;
                return iRes;
            }
            if (icolOutput == this.ncUp_ + this.ncRem_) {
                int iRes = this.icDist_;
                return iRes;
            }
            throw new IllegalArgumentException("Out of range");
        }

        @Override
        public int getResultIdColumnIndex() {
            return this.icId_;
        }

        @Override
        public int getResultScoreColumnIndex() {
            return this.icDist_;
        }
    }
}

