/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.UnrepeatableSequenceException;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.RowMapper;

public class UploadConeTable
extends AbstractStarTable {
    private ConeQueryRowSequence coneSeq_;
    private final RowMapper<?> rowMapper_;
    private final ColumnInfo[] colInfos_;

    public UploadConeTable(ConeQueryRowSequence coneSeq, RowMapper<?> rowMapper, String idName, String raName, String decName) {
        this.coneSeq_ = coneSeq;
        this.rowMapper_ = rowMapper;
        this.colInfos_ = new ColumnInfo[]{new ColumnInfo(idName, this.rowMapper_.getIdClass(), "Row identifier"), new ColumnInfo(raName, Double.class, "ICRS Right Ascension"), new ColumnInfo(decName, Double.class, "ICRS Declination")};
    }

    public int getColumnCount() {
        return this.colInfos_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public long getRowCount() {
        return -1L;
    }

    public synchronized RowSequence getRowSequence() throws IOException {
        if (this.coneSeq_ == null) {
            throw new UnrepeatableSequenceException();
        }
        final ConeQueryRowSequence coneSeq = this.coneSeq_;
        this.coneSeq_ = null;
        return new RowSequence(){
            private Object[] row_;

            public boolean next() throws IOException {
                Object[] objectArray;
                boolean hasNext = coneSeq.next();
                if (hasNext) {
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = UploadConeTable.this.rowMapper_.rowIndexToId(coneSeq.getIndex());
                    objectArray2[1] = coneSeq.getRa();
                    objectArray = objectArray2;
                    objectArray2[2] = coneSeq.getDec();
                } else {
                    objectArray = this.row_ = null;
                }
                assert (!hasNext || UploadConeTable.this.isRowCompatible(this.row_, (ValueInfo[])UploadConeTable.this.colInfos_));
                return hasNext;
            }

            public Object[] getRow() {
                return this.row_;
            }

            public Object getCell(int icol) {
                return this.row_[icol];
            }

            public void close() throws IOException {
                coneSeq.close();
            }
        };
    }

    public void close() throws IOException {
        this.coneSeq_.close();
    }

    private boolean isRowCompatible(Object[] row, ValueInfo[] infos) {
        int n = row.length;
        if (infos.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object cell = row[i];
            if (cell == null || infos[i].getContentClass().isAssignableFrom(cell.getClass())) continue;
            return false;
        }
        return true;
    }
}

