/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import java.util.regex.Pattern;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.convert.SexagesimalToDegrees;
import uk.ac.starlink.ttools.convert.ValueConverter;

public class Conversions {
    private static final boolean DO_TIME = false;
    private static final boolean DO_ANGLE = true;
    private static final Pattern ISO8601_UNIT_PATTERN = Pattern.compile("iso.?8601", 2);
    private static final Pattern HMS_UNIT_PATTERN = Pattern.compile("h+[: ]?m+[: ]?s+(\\..*)?", 2);
    private static final Pattern DMS_UNIT_PATTERN = Pattern.compile("d+[: ]?m+[: ]?s+(\\..*)?", 2);
    private static final Pattern ISO8601_UCD_PATTERN = Pattern.compile("time|time\\.epoch(\\..*)?|TIME_DATE(_.*)?", 2);
    private static final Pattern HMS_UCD_PATTERN = Pattern.compile("POS_EQ_RA.*|pos\\.eq\\.ra.*", 2);
    private static final Pattern DMS_UCD_PATTERN = Pattern.compile("POS_EQ_DEC.*|pos\\.eq\\.dec.*", 2);

    private Conversions() {
    }

    public static ValueConverter getNumericConverter(final ValueInfo info) {
        String units = info.getUnitString();
        String ucd = info.getUCD();
        String xtype = info.getXtype();
        Class clazz = info.getContentClass();
        if (Number.class.isAssignableFrom(clazz)) {
            return new ValueConverter(){

                @Override
                public ValueInfo getInputInfo() {
                    return info;
                }

                @Override
                public ValueInfo getOutputInfo() {
                    return info;
                }

                @Override
                public Object convert(Object value) {
                    return value;
                }

                @Override
                public Object unconvert(Object value) {
                    return value;
                }
            };
        }
        if (String.class.isAssignableFrom(clazz)) {
            if (xtype == null || xtype.trim().length() > 0) {
                // empty if block
            }
            if (units != null && units.trim().length() > 0) {
                if (DMS_UNIT_PATTERN.matcher(units = Conversions.unquote(units.trim()).trim()).matches()) {
                    return new SexagesimalToDegrees(info, false);
                }
                if (HMS_UNIT_PATTERN.matcher(units).matches()) {
                    return new SexagesimalToDegrees(info, true);
                }
            }
            if (ucd != null && ucd.trim().length() > 0) {
                if (DMS_UCD_PATTERN.matcher(ucd = ucd.trim()).matches()) {
                    return new SexagesimalToDegrees(info, false);
                }
                if (HMS_UCD_PATTERN.matcher(ucd).matches()) {
                    return new SexagesimalToDegrees(info, true);
                }
            }
        }
        return null;
    }

    private static String unquote(String str) {
        int leng = str.length();
        if (leng > 1 && (str.charAt(0) == '\'' && str.charAt(leng - 1) == '\'' || str.charAt(0) == '\"' && str.charAt(leng - 1) == '\"')) {
            return str.substring(1, leng - 1);
        }
        return str;
    }
}

