/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.convert.ValueConverter;

public abstract class Iso8601Converter
implements ValueConverter {
    private final ValueInfo inInfo_;
    private final ValueInfo outInfo_;
    private static final char DATE_SEP = 'T';
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String ISO_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Pattern ISO_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,2})-([0-9]{1,2})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?Z?)?");
    private static final double MJD_EPOCH = 40587.0;
    private static final double MILLIS_PER_DAY = 8.64E7;
    private static final ThreadLocal<DateKit> kitHolder_ = new ThreadLocal<DateKit>(){

        @Override
        protected DateKit initialValue() {
            return new DateKit();
        }
    };

    protected Iso8601Converter(ValueInfo isoInfo, ValueInfo numInfo) {
        if (!String.class.isAssignableFrom(isoInfo.getContentClass())) {
            throw new IllegalArgumentException("Input data must be String, not " + isoInfo.getContentClass().getName());
        }
        this.inInfo_ = isoInfo;
        this.outInfo_ = numInfo;
    }

    @Override
    public ValueInfo getInputInfo() {
        return this.inInfo_;
    }

    @Override
    public ValueInfo getOutputInfo() {
        return this.outInfo_;
    }

    @Override
    public Object convert(Object in) {
        if (in instanceof String) {
            String isoDate = ((String)in).trim();
            if (isoDate.length() > 0) {
                return this.fromMjd(Iso8601Converter.isoToMjd(isoDate));
            }
            return null;
        }
        return null;
    }

    @Override
    public Object unconvert(Object out) {
        if (out instanceof Number) {
            double number = ((Number)out).doubleValue();
            if (Double.isNaN(number) || Double.isInfinite(number)) {
                return null;
            }
            return Iso8601Converter.mjdToIso(this.toMjd(number));
        }
        return null;
    }

    protected abstract double toMjd(double var1);

    protected abstract double fromMjd(double var1);

    private static double isoToMjd(String isoDate) {
        Matcher matcher = ISO_REGEX.matcher(isoDate);
        if (matcher.matches()) {
            try {
                String[] groups = new String[6];
                int ng = matcher.groupCount();
                for (int i = 0; i < ng; ++i) {
                    groups[i] = matcher.group(i + 1);
                }
                int year = Integer.parseInt(groups[0]);
                int month = Integer.parseInt(groups[1]);
                int dom = Integer.parseInt(groups[2]);
                int hour = groups[3] == null ? 0 : Integer.parseInt(groups[3]);
                int min = groups[4] == null ? 0 : Integer.parseInt(groups[4]);
                double sec = groups[5] == null ? 0.0 : Double.parseDouble(groups[5]);
                return Iso8601Converter.dateToMjd(year, month, dom, hour, min, sec);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    protected static double dateToMjd(int year, int month, int day, int hour, int min, double sec) {
        Calendar cal = Iso8601Converter.getKit().calendar_;
        cal.clear();
        int intMillis = (int)Math.round(sec * 1000.0);
        cal.set(year, month - 1, day, hour, min, intMillis / 1000);
        cal.set(14, intMillis % 1000);
        try {
            return Iso8601Converter.unixMillisToMjd(cal.getTimeInMillis());
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    protected static double unixMillisToMjd(long unixMillis) {
        return (double)unixMillis / 8.64E7 + 40587.0;
    }

    public static long mjdToUnixMillis(double mjd) {
        return Math.round((mjd - 40587.0) * 8.64E7);
    }

    private static String mjdToIso(double mjd) {
        return Iso8601Converter.formatMjd(mjd, Iso8601Converter.getKit().isoDateTimeFormat_);
    }

    private static String formatMjd(double mjd, DateFormat format) {
        if (Double.isNaN(mjd) || Double.isInfinite(mjd)) {
            return null;
        }
        return format.format(new Date(Iso8601Converter.mjdToUnixMillis(mjd)));
    }

    private static Calendar newCalendar() {
        GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
        cal.setLenient(true);
        return cal;
    }

    private static DateFormat newDateFormat(String pattern) {
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(UTC);
        fmt.setCalendar(Iso8601Converter.newCalendar());
        return fmt;
    }

    protected static DateKit getKit() {
        return kitHolder_.get();
    }

    static /* synthetic */ Calendar access$000() {
        return Iso8601Converter.newCalendar();
    }

    static /* synthetic */ DateFormat access$100(String x0) {
        return Iso8601Converter.newDateFormat(x0);
    }

    protected static class DateKit {
        final Calendar calendar_ = Iso8601Converter.access$000();
        final DateFormat isoDateTimeFormat_ = Iso8601Converter.access$100("yyyy-MM-dd'T'HH:mm:ss");

        protected DateKit() {
        }
    }
}

