/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.copy;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

class SAXWriter
implements ContentHandler,
LexicalHandler {
    private Writer out_;
    private Locator locator_;
    private String pendingTag_;
    private boolean cdata_;

    SAXWriter() {
    }

    public void setOutput(Writer out) {
        this.out_ = out;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.out("\n");
        try {
            this.out_.flush();
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
        this.locator_ = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.flushTag();
        StringBuffer buf = new StringBuffer("<" + qName);
        for (int i = 0; i < atts.getLength(); ++i) {
            String value = atts.getValue(i);
            if (value == null) continue;
            buf.append(' ').append(atts.getQName(i)).append("=\"");
            block7: for (int j = 0; j < value.length(); ++j) {
                char c = value.charAt(j);
                switch (c) {
                    case '<': {
                        buf.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        buf.append("&gt;");
                        continue block7;
                    }
                    case '&': {
                        buf.append("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        buf.append("&quot;");
                        continue block7;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            buf.append('\"');
        }
        this.pendingTag_ = buf.toString();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.pendingTag_ != null) {
            this.out(this.pendingTag_);
            this.out("/>");
            this.pendingTag_ = null;
        } else {
            this.out("</" + qName + ">");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushTag();
        this.escapeOut(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.flushTag();
        this.out(ch, start, length);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.flushTag();
        this.out("&" + name + ";");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.flushTag();
        this.out("<?" + target + " ");
        this.out(data);
        this.out("?>");
        this.out("\n");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushTag();
        this.out("<!--");
        this.out(ch, start, length);
        this.out("-->");
    }

    @Override
    public void startCDATA() throws SAXException {
        this.flushTag();
        this.out("<![CDATA[");
        this.cdata_ = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.out("]]>");
        this.cdata_ = false;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    public void flush() throws SAXException {
        this.flushTag();
    }

    private void flushTag() throws SAXException {
        if (this.pendingTag_ != null) {
            this.out(this.pendingTag_);
            this.out('>');
            this.pendingTag_ = null;
        }
    }

    private SAXException wrapException(IOException e) {
        return (SAXException)new SAXParseException(e.getMessage(), this.locator_).initCause(e);
    }

    private void out(char c) throws SAXException {
        try {
            this.out_.write(c);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    private void out(char[] ch, int start, int leng) throws SAXException {
        try {
            this.out_.write(ch, start, leng);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    public void out(String text) throws SAXException {
        try {
            this.out_.write(text);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    private void escapeOut(String text) throws SAXException {
        this.escapeOut(text.toCharArray(), 0, text.length());
    }

    private void escapeOut(char[] ch, int start, int leng) throws SAXException {
        try {
            if (this.cdata_) {
                this.out(ch, start, leng);
            } else {
                block8: while (leng-- > 0) {
                    char c = ch[start++];
                    switch (c) {
                        case '<': {
                            this.out_.write("&lt;");
                            continue block8;
                        }
                        case '>': {
                            this.out_.write("&gt;");
                            continue block8;
                        }
                        case '&': {
                            this.out_.write("&amp;");
                            continue block8;
                        }
                        case '\"': {
                            this.out_.write("&quot;");
                            continue block8;
                        }
                    }
                    this.out_.write(c);
                }
            }
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }
}

