/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.SequentialRowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowAccess;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.AssertException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.RandomJELRowReader;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;

public class AssertFilter
extends BasicFilter {
    public AssertFilter() {
        super("assert", "<test-expr> [<msg-expr>]");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Check that a boolean expression is true for each row.", "If the expression <code>&lt;test-expr&gt;</code> does not", "evaluate true for any row of the table, execution terminates", "with an error.", "As long as no error occurs, the output table is identical", "to the input one.", "</p>", "<p>If the <code>&lt;msg-expr&gt;</code> parameter is supplied,", "then on failure it will be evaluated and its value presented", "in the error message.", "</p>", "<p>The exception generated by an assertion violation is of class", "<code>" + AssertException.class.getName() + "</code>", "although that is not usually obvious if you are running from", "the shell in the usual way.", "</p>", AssertFilter.explainSyntax(new String[]{"test-expr", "msg-expr"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String msgExpr;
        if (!argIt.hasNext()) {
            throw new ArgException("Missing test expression");
        }
        final String testExpr = argIt.next();
        argIt.remove();
        if (argIt.hasNext()) {
            msgExpr = argIt.next();
            argIt.remove();
        } else {
            msgExpr = null;
        }
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) throws IOException {
                return new JELAssertionTable(base, testExpr, msgExpr);
            }
        };
    }

    private static CompiledExpression compile(Library lib, StarTable table, String expr) throws IOException {
        if (expr == null) {
            return null;
        }
        try {
            return JELUtils.compile(lib, table, expr);
        }
        catch (CompilationException e) {
            throw JELUtils.toIOException(e, expr);
        }
    }

    private static class JELAssertionTable
    extends WrapperStarTable {
        private final String expr_;
        private final String msgExpr_;
        private final StarTable baseTable_;
        private final RandomJELRowReader randomReader_;
        private final CompiledExpression compEx_;
        private final CompiledExpression msgCompEx_;
        private final boolean requiresRowIndex_;

        public JELAssertionTable(StarTable baseTable, String expr, String msgExpr) throws IOException {
            super(baseTable);
            this.baseTable_ = baseTable;
            this.expr_ = expr;
            this.msgExpr_ = msgExpr;
            this.randomReader_ = RandomJELRowReader.createConcurrentReader(baseTable);
            Library lib = JELUtils.getLibrary(this.randomReader_);
            this.compEx_ = AssertFilter.compile(lib, baseTable, expr);
            this.msgCompEx_ = AssertFilter.compile(lib, baseTable, msgExpr);
            this.requiresRowIndex_ = this.randomReader_.requiresRowIndex();
            try {
                JELUtils.checkExpressionType(lib, baseTable, expr, Boolean.TYPE);
            }
            catch (CompilationException e) {
                throw JELUtils.toIOException(e, expr);
            }
        }

        public Object getCell(long irow, int icol) throws IOException {
            Object cell = super.getCell(irow, icol);
            this.assertAtRow(this.randomReader_, irow);
            return cell;
        }

        public Object[] getRow(long irow) throws IOException {
            Object[] row = super.getRow(irow);
            this.assertAtRow(this.randomReader_, irow);
            return row;
        }

        private void assertAtRow(RandomJELRowReader reader, long irow) throws IOException {
            Object result;
            try {
                result = reader.evaluateAtRow(this.compEx_, irow);
            }
            catch (IOException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            MessageSupplier msgSupplier = () -> reader.evaluateAtRow(this.msgCompEx_, irow);
            this.check(result, irow, msgSupplier);
        }

        public RowAccess getRowAccess() throws IOException {
            RowAccess baseAcc = super.getRowAccess();
            final RandomJELRowReader accReader = RandomJELRowReader.createAccessReader(this.baseTable_, baseAcc);
            Library lib = JELUtils.getLibrary(accReader);
            CompiledExpression compEx = AssertFilter.compile(lib, this.baseTable_, this.expr_);
            return new WrapperRowAccess(baseAcc){

                public void setRowIndex(long irow) throws IOException {
                    super.setRowIndex(irow);
                    this.assertAtRow(accReader, irow);
                }
            };
        }

        public RowSequence getRowSequence() throws IOException {
            final SequentialJELRowReader seqReader = new SequentialJELRowReader(this.baseTable_);
            Library lib = JELUtils.getLibrary(seqReader);
            final CompiledExpression compEx = AssertFilter.compile(lib, this.baseTable_, this.expr_);
            CompiledExpression msgCompEx = AssertFilter.compile(lib, this.baseTable_, this.msgExpr_);
            final MessageSupplier msgSupplier = () -> seqReader.evaluate(msgCompEx);
            return new WrapperRowSequence(seqReader){
                long lrow_;

                public boolean next() throws IOException {
                    boolean next = super.next();
                    if (next) {
                        Object result;
                        try {
                            result = seqReader.evaluate(compEx);
                        }
                        catch (IOException | Error | RuntimeException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw (IOException)new IOException(e.getMessage()).initCause(e);
                        }
                        this.check(result, this.lrow_++, msgSupplier);
                    }
                    return next;
                }
            };
        }

        public RowSplittable getRowSplittable() throws IOException {
            RowSplittable baseSplittable = this.baseTable.getRowSplittable();
            if (this.requiresRowIndex_ && baseSplittable.rowIndex() == null) {
                return new SequentialRowSplittable((StarTable)this);
            }
            return new AssertRowSplittable(this.baseTable.getRowSplittable());
        }

        private void check(Object result, long irow, MessageSupplier msgSupplier) throws AssertException {
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("Assertion \"").append(this.expr_).append("\" violated at row ").append(irow + 1L);
                if (msgSupplier != null) {
                    Object msg;
                    try {
                        msg = msgSupplier.getMessage();
                    }
                    catch (Throwable e) {
                        msg = null;
                    }
                    if (msg != null) {
                        sbuf.append(": ").append(msg);
                    }
                }
                throw new AssertException(sbuf.toString());
            }
        }

        private class AssertRowSplittable
        extends WrapperRowSequence
        implements RowSplittable {
            final RowSplittable baseSplit_;
            final SequentialJELRowReader seqReader_;
            final CompiledExpression compEx1_;
            final LongSupplier rowIndex_;
            final MessageSupplier msgSupplier_;

            AssertRowSplittable(RowSplittable baseSplit) throws IOException {
                super((RowSequence)baseSplit);
                this.baseSplit_ = baseSplit;
                this.seqReader_ = new SequentialJELRowReader(JELAssertionTable.this.baseTable_, baseSplit);
                LongSupplier rowIndex = baseSplit.rowIndex();
                if (rowIndex == null) {
                    this.rowIndex_ = () -> Long.MIN_VALUE;
                    assert (!JELAssertionTable.this.requiresRowIndex_);
                } else {
                    this.rowIndex_ = rowIndex;
                }
                Library lib = JELUtils.getLibrary(this.seqReader_);
                this.compEx1_ = AssertFilter.compile(lib, JELAssertionTable.this.baseTable_, JELAssertionTable.this.expr_);
                CompiledExpression msgCompEx1 = AssertFilter.compile(lib, JELAssertionTable.this.baseTable_, JELAssertionTable.this.msgExpr_);
                this.msgSupplier_ = () -> this.seqReader_.evaluate(msgCompEx1);
            }

            public long splittableSize() {
                return this.baseSplit_.splittableSize();
            }

            public LongSupplier rowIndex() {
                return this.baseSplit_.rowIndex();
            }

            public boolean next() throws IOException {
                boolean next = super.next();
                if (next) {
                    Object result;
                    try {
                        result = this.seqReader_.evaluate(this.compEx1_);
                    }
                    catch (IOException | Error | RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                    JELAssertionTable.this.check(result, this.rowIndex_.getAsLong(), this.msgSupplier_);
                }
                return next;
            }

            public AssertRowSplittable split() {
                RowSplittable split1 = (RowSplittable)this.baseSplit_.split();
                try {
                    return split1 == null ? null : new AssertRowSplittable(split1);
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
    }

    @FunctionalInterface
    private static interface MessageSupplier {
        public Object getMessage() throws Throwable;
    }
}

