/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.AddColumnFilter;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class ColumnMetadataFilter
extends BasicFilter {
    public ColumnMetadataFilter() {
        super("colmeta", "[-name <name>] [-units <units>] [-ucd <ucd>]\n[-utype <utype>] [-xtype <xtype>] [-desc <descrip>]\n[-shape <n>[,<n>...][,*]] [-elsize <n>]\n<colid-list>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Modifies the metadata of one or more columns.", "Some or all of the name, units, ucd, utype, xtype, description,", "shape and elementsize of", "the column(s), identified by <code>&lt;colid-list&gt;</code>", "can be set by using some or all of the listed flags.", "Typically, <code>&lt;colid-list&gt;</code> will simply be", "the name of a single column.", "</p>", "<p>The <code>-name</code>, <code>-units</code>,", "<code>-ucd</code>, <code>-utype</code>, <code>-xtype</code>", "and <code>-desc</code> flags just take textual arguments.", "The <code>-shape</code> flag can also be used,", "but is intended only for array-valued columns,", "e.g. <code>-shape 3,3</code> to declare a 3x3 array.", "The final entry only in the shape list", "may be a \"<code>*</code>\" character", "to indicate unknown extent.", "Array values with no specified shape effectively have a", "shape of \"<code>*</code>\".", "The <code>-elsize</code> flag may be used to specify the length", "of fixed length strings; use with non-string columns", "is not recommended.", "</p>", ColumnMetadataFilter.explainSyntax(new String[]{"colid-list"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String colidList = null;
        String rename = null;
        String units = null;
        String ucd = null;
        String utype = null;
        String xtype = null;
        String desc = null;
        int[] shape = null;
        int elsize = -1;
        while (argIt.hasNext() && colidList == null) {
            String arg = argIt.next();
            if (arg.equals("-name") && argIt.hasNext()) {
                argIt.remove();
                rename = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.startsWith("-unit") && argIt.hasNext()) {
                argIt.remove();
                units = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-ucd") && argIt.hasNext()) {
                argIt.remove();
                ucd = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-utype") && argIt.hasNext()) {
                argIt.remove();
                utype = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-xtype") && argIt.hasNext()) {
                argIt.remove();
                xtype = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-desc") && argIt.hasNext()) {
                argIt.remove();
                desc = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-shape") && argIt.hasNext()) {
                argIt.remove();
                String shapeTxt = argIt.next();
                argIt.remove();
                try {
                    shape = DefaultValueInfo.unformatShape((String)shapeTxt);
                    continue;
                }
                catch (Exception e) {
                    throw new ArgException("Bad -shape specification \"" + shapeTxt + "\"");
                }
            }
            if (arg.equals("-elsize") && argIt.hasNext()) {
                argIt.remove();
                String elsizeTxt = argIt.next();
                argIt.remove();
                try {
                    elsize = Integer.parseInt(elsizeTxt);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ArgException("Bad -elsize specification \"" + elsizeTxt + "\"");
                }
            }
            if (arg.startsWith("-")) {
                argIt.remove();
                throw new ArgException("No such flag " + arg);
            }
            if (colidList != null) continue;
            colidList = arg;
            argIt.remove();
        }
        if (colidList == null) {
            throw new ArgException("No columns specified");
        }
        return new ColMetaStep(colidList, rename, units, ucd, utype, xtype, desc, shape, elsize);
    }

    private static class ColMetaStep
    implements ProcessingStep {
        final String colidList_;
        final String name_;
        final String units_;
        final String ucd_;
        final String utype_;
        final String xtype_;
        final String desc_;
        final int[] shape_;
        final int elsize_;

        public ColMetaStep(String colidList, String name, String units, String ucd, String utype, String xtype, String desc, int[] shape, int elsize) {
            this.colidList_ = colidList;
            this.name_ = name;
            this.units_ = units;
            this.ucd_ = ucd;
            this.utype_ = utype;
            this.xtype_ = xtype;
            this.desc_ = desc;
            this.shape_ = shape;
            this.elsize_ = elsize;
        }

        @Override
        public StarTable wrap(StarTable base) throws IOException {
            int ncol = base.getColumnCount();
            boolean[] colFlags = new ColumnIdentifier(base).getColumnFlags(this.colidList_);
            assert (colFlags.length == ncol);
            final ColumnInfo[] colInfos = new ColumnInfo[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo info = new ColumnInfo((ValueInfo)base.getColumnInfo(icol));
                if (colFlags[icol]) {
                    if (this.name_ != null) {
                        info.setName(this.name_);
                    }
                    if (this.units_ != null) {
                        info.setUnitString(this.units_);
                    }
                    if (this.ucd_ != null) {
                        info.setUCD(this.ucd_);
                    }
                    if (this.utype_ != null) {
                        info.setUtype(this.utype_);
                    }
                    if (this.xtype_ != null) {
                        info.setXtype(this.xtype_);
                    }
                    if (this.desc_ != null) {
                        info.setDescription(this.desc_);
                    }
                    if (this.shape_ != null) {
                        info.setShape(this.shape_);
                    }
                    if (this.elsize_ >= 0) {
                        info.setElementSize(this.elsize_);
                    }
                }
                colInfos[icol] = info;
            }
            WrapperStarTable out = new WrapperStarTable(base){

                public ColumnInfo getColumnInfo(int icol) {
                    return colInfos[icol];
                }
            };
            for (int icol = 0; icol < ncol; ++icol) {
                if (!colFlags[icol]) continue;
                AddColumnFilter.checkDuplicatedName((StarTable)out, icol);
            }
            return out;
        }
    }
}

