/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.LinkedList;
import uk.ac.starlink.table.AccessRowSequence;
import uk.ac.starlink.table.IteratorRowSequence;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperRowAccess;
import uk.ac.starlink.table.WrapperStarTable;

public class TailTable
extends WrapperStarTable {
    private final long ntail_;

    public TailTable(StarTable base, long ntail) {
        super(base);
        this.ntail_ = ntail;
    }

    public long getRowCount() {
        long nbase = super.getRowCount();
        return nbase >= 0L ? Math.min(this.ntail_, nbase) : -1L;
    }

    public Object getCell(long irow, int icol) throws IOException {
        return super.getCell(this.translateRow(irow), icol);
    }

    public Object[] getRow(long irow) throws IOException {
        return super.getRow(this.translateRow(irow));
    }

    private long translateRow(long irow) {
        return super.getRowCount() - this.getRowCount() + irow;
    }

    public RowAccess getRowAccess() throws IOException {
        final long ioff = super.getRowCount() - this.getRowCount();
        return new WrapperRowAccess(super.getRowAccess()){

            public void setRowIndex(long irow) throws IOException {
                super.setRowIndex(ioff + irow);
            }
        };
    }

    public RowSequence getRowSequence() throws IOException {
        if (this.isRandom()) {
            return AccessRowSequence.createInstance((StarTable)this);
        }
        long nbase = super.getRowCount();
        RowSequence baseSeq = super.getRowSequence();
        if (nbase >= 0L) {
            long nskip = nbase - this.ntail_;
            for (long i = 0L; i < nskip && baseSeq.next(); ++i) {
            }
            return baseSeq;
        }
        LinkedList<Object[]> queue = new LinkedList<Object[]>();
        long size = 0L;
        while (baseSeq.next()) {
            queue.addLast(baseSeq.getRow());
            if (++size <= this.ntail_) continue;
            queue.removeFirst();
            --size;
        }
        assert (size <= this.ntail_);
        assert (size == (long)queue.size());
        return new IteratorRowSequence(queue.iterator());
    }

    public RowSplittable getRowSplittable() throws IOException {
        return Tables.getDefaultRowSplittable((StarTable)this);
    }
}

