/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DoubleList;
import uk.ac.starlink.util.IntList;

public class Conversions {
    private static final Pattern INT_REGEX = Pattern.compile("(?<![-+.0-9a-zA-Z])[+-]?([0-9]+)(?![-+.0-9a-zA-Z])");
    private static final Pattern FLOAT_REGEX = Pattern.compile("(?<![-+.0-9a-zA-Z])([+-]?([0-9]*\\.[0-9]+|[0-9]+\\.?)([eE][-+]?[0-9]{1,3})?|none|null|nan)(?![-+.0-9a-zA-Z])", 2);

    private Conversions() {
    }

    public static String toString(double fpVal) {
        if (Tables.isBlank((Object)fpVal)) {
            return null;
        }
        return fpVal == (double)((long)fpVal) ? Long.toString((long)fpVal) : Double.toString(fpVal);
    }

    public static String toString(long intVal) {
        return Long.toString(intVal);
    }

    public static String toString(char charVal) {
        return Character.toString(charVal);
    }

    public static String toString(byte byteVal) {
        return Byte.toString(byteVal);
    }

    public static String toString(boolean booleanVal) {
        return Boolean.toString(booleanVal);
    }

    public static String toString(Object objVal) {
        return Tables.isBlank((Object)objVal) ? null : objVal.toString();
    }

    public static byte parseByte(String str) {
        return Byte.parseByte(str.trim());
    }

    public static short parseShort(String str) {
        return Short.parseShort(str.trim());
    }

    public static int parseInt(String str) {
        return Integer.parseInt(str.trim());
    }

    public static long parseLong(String str) {
        return Long.parseLong(str.trim());
    }

    public static float parseFloat(String str) {
        return Float.parseFloat(str.trim());
    }

    public static double parseDouble(String str) {
        return Double.parseDouble(str.trim());
    }

    public static BigInteger parseBigInteger(String str) {
        return new BigInteger(str.trim());
    }

    public static BigDecimal parseBigDecimal(String str) {
        return new BigDecimal(str);
    }

    public static int[] parseInts(String str) {
        IntList ilist = new IntList(48);
        Matcher matcher = INT_REGEX.matcher(str);
        while (matcher.find()) {
            String match = str.substring(matcher.start(), matcher.end());
            try {
                ilist.add(Integer.parseInt(match));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ilist.toIntArray();
    }

    public static double[] parseDoubles(String str) {
        DoubleList dlist = new DoubleList(48);
        Matcher matcher = FLOAT_REGEX.matcher(str);
        while (matcher.find()) {
            String match = str.substring(matcher.start(), matcher.end());
            char c1 = match.charAt(0);
            if (c1 == 'n' || c1 == 'N') {
                assert ("nan".equalsIgnoreCase(match) || "none".equalsIgnoreCase(match) || "null".equalsIgnoreCase(match));
                dlist.add(Double.NaN);
                continue;
            }
            try {
                dlist.add(Double.parseDouble(match));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return dlist.toDoubleArray();
    }

    public static byte toByte(double value) {
        if (value < -128.0 || value > 127.0 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (byte)value;
    }

    public static short toShort(double value) {
        if (value < -32768.0 || value > 32767.0 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (short)value;
    }

    public static int toInteger(double value) {
        if (value < -2.147483648E9 || value > 2.147483647E9 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (int)value;
    }

    public static long toLong(double value) {
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18 || Double.isNaN(value)) {
            throw new NumberFormatException();
        }
        return (long)value;
    }

    public static float toFloat(double value) {
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            return Float.NaN;
        }
        return (float)value;
    }

    public static double toDouble(double value) {
        return value;
    }

    public static String toHex(long value) {
        return Long.toHexString(value);
    }

    public static int fromHex(String hexVal) {
        return Integer.parseInt(hexVal.trim(), 16);
    }
}

