/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import uk.ac.starlink.ttools.build.HideDoc;
import uk.ac.starlink.ttools.jel.StateDependent;

public class Randoms {
    private Randoms() {
    }

    public static double random(long index) {
        return Randoms.createRandomFromIndex(index).nextDouble();
    }

    public static double randomGaussian(long index) {
        return Randoms.createRandomFromIndex(index).nextGaussian();
    }

    public static double[] randomArray(long index, int n) {
        Random rnd = Randoms.createRandomFromIndex(index);
        double[] out = new double[n];
        for (int i = 0; i < n; ++i) {
            out[i] = rnd.nextDouble();
        }
        return out;
    }

    public static double[] randomGaussianArray(long index, int n) {
        Random rnd = Randoms.createRandomFromIndex(index);
        double[] out = new double[n];
        for (int i = 0; i < n; ++i) {
            out[i] = rnd.nextGaussian();
        }
        return out;
    }

    @StateDependent
    public static double nextRandom() {
        return Randoms.getGlobalRandom().nextDouble();
    }

    @StateDependent
    public static double nextRandomGaussian() {
        return Randoms.getGlobalRandom().nextGaussian();
    }

    @HideDoc
    public static Random createRandomFromIndex(long index) {
        long seed = Randoms.lcgNext(index);
        return new Random(seed);
    }

    @HideDoc
    public static Random getGlobalRandom() {
        return ThreadLocalRandom.current();
    }

    private static long lcgNext(long i) {
        return 6364136223846793005L * i + 1442695040888963407L;
    }
}

