/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

public class Shapes {
    private Shapes() {
    }

    public static double polyLine(double x, double ... xys) {
        int np2 = xys.length;
        if (np2 % 2 != 0 || np2 < 2) {
            return Double.NaN;
        }
        if (np2 == 2) {
            return xys[1];
        }
        if (np2 == 4) {
            return Shapes.lineSegment(x, xys, 0);
        }
        double xB = xys[np2 - 2];
        double xA = xys[0];
        if ((xys[2] - x) * (xB - xA) >= 0.0) {
            return Shapes.lineSegment(x, xys, 0);
        }
        if ((xys[np2 - 4] - x) * (xA - xB) >= 0.0) {
            return Shapes.lineSegment(x, xys, np2 - 4);
        }
        for (int ip2 = 2; ip2 < np2 - 4; ip2 += 2) {
            if (!((x - xys[ip2 + 0]) * (x - xys[ip2 + 2]) <= 0.0)) continue;
            return Shapes.lineSegment(x, xys, ip2);
        }
        return Double.NaN;
    }

    public static boolean isInside(double x, double y, double ... xys) {
        int np2 = xys.length;
        return np2 % 2 == 0 && np2 > 4 ? Shapes.windingNumber(x, y, xys) != 0 : false;
    }

    private static double lineSegment(double x, double[] xys, int i) {
        double x1 = xys[i + 0];
        double y1 = xys[i + 1];
        double x2 = xys[i + 2];
        double y2 = xys[i + 3];
        return (y2 - y1) / (x2 - x1) * (x - x1) + y1;
    }

    private static int windingNumber(double x0, double y0, double[] xys) {
        int nw = 0;
        int np2 = xys.length;
        double xA = xys[np2 - 2];
        double yA = xys[np2 - 1];
        for (int ip2 = 0; ip2 < np2; ip2 += 2) {
            double xB = xys[ip2 + 0];
            double yB = xys[ip2 + 1];
            if (yA <= y0) {
                if (yB > y0 && Shapes.sideCode(x0, y0, xA, yA, xB, yB) > 0.0) {
                    ++nw;
                }
            } else if (yB <= y0 && Shapes.sideCode(x0, y0, xA, yA, xB, yB) < 0.0) {
                --nw;
            }
            xA = xB;
            yA = yB;
        }
        return nw;
    }

    private static double sideCode(double x0, double y0, double x1, double y1, double x2, double y2) {
        return (x2 - x1) * (y0 - y1) - (x0 - x1) * (y2 - y1);
    }
}

