/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import cds.healpix.Healpix;
import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMfunc;

public class Tilings {
    public static final double SQDEG = 3.0461741978670857E-4;

    private Tilings() {
    }

    public static long htmIndex(int level, double lon, double lat) {
        try {
            return HTMfunc.lookupId((double)lon, (double)lat, (int)level);
        }
        catch (HTMException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static long healpixNestIndex(int k, double lon, double lat) {
        return Healpix.getNestedFast((int)k).hash(Math.toRadians(lon), Math.toRadians(lat));
    }

    public static long healpixRingIndex(int k, double lon, double lat) {
        return Tilings.healpixNestToRing(k, Tilings.healpixNestIndex(k, lon, lat));
    }

    public static double healpixNestLon(int k, long index) {
        return Math.toDegrees(Healpix.getNestedFast((int)k).center(index)[0]);
    }

    public static double healpixNestLat(int k, long index) {
        return Math.toDegrees(Healpix.getNestedFast((int)k).center(index)[1]);
    }

    public static double healpixRingLon(int k, long index) {
        return Tilings.healpixNestLon(k, Tilings.healpixRingToNest(k, index));
    }

    public static double healpixRingLat(int k, long index) {
        return Tilings.healpixNestLat(k, Tilings.healpixRingToNest(k, index));
    }

    public static long healpixNestToRing(int k, long nestIndex) {
        return Healpix.getNested((int)k).toRing(nestIndex);
    }

    public static long healpixRingToNest(int k, long ringIndex) {
        return Healpix.getNested((int)k).toNested(ringIndex);
    }

    public static int healpixK(double pixelsize) {
        return Math.max(0, Healpix.getBestStartingDepth((double)Math.toRadians(pixelsize)));
    }

    public static double healpixResolution(int k) {
        return Math.sqrt(Tilings.healpixSqdeg(k));
    }

    public static double healpixSteradians(int k) {
        return Math.PI * 4 / (double)(12L << 2 * k);
    }

    public static double healpixSqdeg(int k) {
        return Tilings.steradiansToSqdeg(Tilings.healpixSteradians(k));
    }

    public static double steradiansToSqdeg(double sr) {
        return sr / 3.0461741978670857E-4;
    }

    public static double sqdegToSteradians(double sqdeg) {
        return sqdeg * 3.0461741978670857E-4;
    }

    public static int htmLevel(double pixelsize) {
        return (int)Math.ceil(5.0 - Math.log(pixelsize / 2.8125) / Math.log(2.0));
    }

    public static double htmResolution(int level) {
        return 2.8125 * Math.pow(2.0, 5 - level);
    }
}

