/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.pal.Pal;

public class Times {
    private static final char DATE_SEP = 'T';
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Pal pal = new Pal();
    private static final long BCE_BOUNDARY_UNIXMILLIS = -62135769600000L;
    private static final Pattern ISO_MMDD_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,2})-([0-9]{1,2})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?)?Z?");
    private static final Pattern ISO_DDD_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,3})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?)?Z?");
    private static final double MJD_EPOCH = 40587.0;
    private static final double MILLIS_PER_DAY = 8.64E7;
    private static final double SEC_PER_DAY = 86400.0;
    public static final double MJD_OFFSET = 2400000.5;
    private static final ThreadLocal<DateKit> kitHolder_ = new ThreadLocal<DateKit>(){

        @Override
        protected DateKit initialValue() {
            return new DateKit();
        }
    };

    private Times() {
    }

    public static double isoToMjd(String isoDate) {
        if (isoDate == null || isoDate.trim().length() == 0) {
            return Double.NaN;
        }
        Matcher matcher1 = ISO_MMDD_REGEX.matcher(isoDate);
        if (matcher1.matches()) {
            try {
                String[] groups = new String[6];
                int ng = matcher1.groupCount();
                for (int i = 0; i < ng; ++i) {
                    groups[i] = matcher1.group(i + 1);
                }
                int year = Integer.parseInt(groups[0]);
                int month = Integer.parseInt(groups[1]);
                int dom = Integer.parseInt(groups[2]);
                int hour = groups[3] == null ? 0 : Integer.parseInt(groups[3]);
                int min = groups[4] == null ? 0 : Integer.parseInt(groups[4]);
                double sec = groups[5] == null ? 0.0 : Double.parseDouble(groups[5]);
                return Times.dateToMjd(year, month, dom, hour, min, sec);
            }
            catch (NumberFormatException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Bad ISO-8601 date " + isoDate).initCause(e);
            }
        }
        Matcher matcher2 = ISO_DDD_REGEX.matcher(isoDate);
        if (matcher2.matches()) {
            try {
                String[] groups = new String[5];
                int ng = matcher2.groupCount();
                for (int i = 0; i < ng; ++i) {
                    groups[i] = matcher2.group(i + 1);
                }
                int year = Integer.parseInt(groups[0]);
                int doy = Integer.parseInt(groups[1]);
                int hour = groups[2] == null ? 0 : Integer.parseInt(groups[2]);
                int min = groups[3] == null ? 0 : Integer.parseInt(groups[3]);
                double sec = groups[4] == null ? 0.0 : Double.parseDouble(groups[4]);
                int intMillis = (int)Math.round(sec * 1000.0);
                Calendar cal = Times.getKit().calendar_;
                cal.clear();
                cal.set(1, year);
                cal.set(6, doy);
                cal.set(11, hour);
                cal.set(12, min);
                cal.set(13, intMillis / 1000);
                cal.set(14, intMillis % 1000);
                return Times.unixMillisToMjd(cal.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Bad ISO-8601 date " + isoDate).initCause(e);
            }
        }
        throw new IllegalArgumentException("Bad ISO-8601 date " + isoDate);
    }

    public static double dateToMjd(int year, int month, int day, int hour, int min, double sec) {
        Calendar cal = Times.getKit().calendar_;
        cal.clear();
        int intMillis = (int)Math.round(sec * 1000.0);
        cal.set(year, month - 1, day, hour, min, intMillis / 1000);
        cal.set(14, intMillis % 1000);
        return Times.unixMillisToMjd(cal.getTimeInMillis());
    }

    public static double dateToMjd(int year, int month, int day) {
        Calendar cal = Times.getKit().calendar_;
        cal.clear();
        cal.set(year, month - 1, day);
        return Times.unixMillisToMjd(cal.getTimeInMillis());
    }

    public static double decYearToMjd(double decYear) {
        int year = (int)Math.floor(decYear);
        double frac = decYear - (double)year;
        Calendar cal = Times.getKit().calendar_;
        cal.clear();
        cal.set(1, year);
        long y0 = cal.getTimeInMillis();
        cal.set(1, year + 1);
        long y1 = cal.getTimeInMillis();
        long t = y0 + Math.round(frac * (double)(y1 - y0));
        return Times.unixMillisToMjd(t);
    }

    public static double isoToUnixSec(String isoDate) {
        return Times.mjdToUnixSec(Times.isoToMjd(isoDate));
    }

    public static double decYearToUnixSec(double decYear) {
        return Times.mjdToUnixSec(Times.decYearToMjd(decYear));
    }

    public static double mjdToUnixSec(double mjd) {
        return (mjd - 40587.0) * 86400.0;
    }

    public static double jdToUnixSec(double jd) {
        return Times.mjdToUnixSec(Times.jdToMjd(jd));
    }

    public static String mjdToIso(double mjd) {
        return Times.formatMjd(mjd, Times.getKit().isoDateTimeFormat_, true);
    }

    public static String mjdToDate(double mjd) {
        return Times.formatMjd(mjd, Times.getKit().isoDateFormat_, true);
    }

    public static String mjdToTime(double mjd) {
        return Times.formatMjd(mjd, Times.getKit().isoTimeFormat_, false);
    }

    public static double mjdToDecYear(double mjd) {
        Calendar cal = Times.getKit().calendar_;
        cal.clear();
        long t = Times.mjdToUnixMillis(mjd);
        cal.setTimeInMillis(t);
        int year = cal.get(1);
        cal.clear();
        cal.set(1, year);
        long y0 = cal.getTimeInMillis();
        cal.set(1, year + 1);
        long y1 = cal.getTimeInMillis();
        return (double)year + (double)(t - y0) / (double)(y1 - y0);
    }

    public static String formatMjd(double mjd, String format) {
        return Times.formatMjd(mjd, Times.getFormat(format), false);
    }

    public static double jdToMjd(double jd) {
        return jd - 2400000.5;
    }

    public static double mjdToJd(double mjd) {
        return mjd + 2400000.5;
    }

    public static double mjdToJulian(double mjd) {
        return pal.Epj(mjd);
    }

    public static double julianToMjd(double julianEpoch) {
        return pal.Epj2d(julianEpoch);
    }

    public static double mjdToBesselian(double mjd) {
        return pal.Epb(mjd);
    }

    public static double besselianToMjd(double besselianEpoch) {
        return pal.Epb2d(besselianEpoch);
    }

    static int mjdYear(double mjd) {
        return Times.getField(mjd, 1);
    }

    static int mjdMonth(double mjd) {
        return Times.getField(mjd, 2) + 1;
    }

    static int mjdDayOfMonth(double mjd) {
        return Times.getField(mjd, 5);
    }

    static int mjdHour(double mjd) {
        return Times.getField(mjd, 11);
    }

    static int mjdMinute(double mjd) {
        return Times.getField(mjd, 12);
    }

    static double mjdSecond(double mjd) {
        double minutes = mjd * 60.0 * 24.0;
        double minFrac = minutes - Math.floor(minutes);
        return minFrac * 60.0;
    }

    private static int getField(double mjd, int field) {
        Calendar cal = Times.getKit().calendar_;
        cal.setTimeInMillis(Times.mjdToUnixMillis(mjd));
        return cal.get(field);
    }

    private static String formatMjd(double mjd, DateFormat format, boolean prependBce) {
        if (Double.isNaN(mjd) || Double.isInfinite(mjd)) {
            return null;
        }
        long unixMillis = Times.mjdToUnixMillis(mjd);
        String txt = format.format(new Date(unixMillis));
        if (prependBce && unixMillis < -62135769600000L) {
            txt = "(BCE)" + txt;
        }
        return txt;
    }

    public static double unixMillisToMjd(long unixMillis) {
        return (double)unixMillis / 8.64E7 + 40587.0;
    }

    public static long mjdToUnixMillis(double mjd) {
        return Math.round((mjd - 40587.0) * 8.64E7);
    }

    private static DateKit getKit() {
        return kitHolder_.get();
    }

    private static DateFormat getFormat(String pattern) {
        Map<String, DateFormat> map = Times.getKit().patternMap_;
        if (!map.containsKey(pattern)) {
            map.put(pattern, Times.newDateFormat(pattern));
        }
        return map.get(pattern);
    }

    private static Calendar newCalendar() {
        GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
        cal.setLenient(true);
        return cal;
    }

    private static DateFormat newDateFormat(String pattern) {
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(UTC);
        fmt.setCalendar(Times.newCalendar());
        return fmt;
    }

    static /* synthetic */ Calendar access$100() {
        return Times.newCalendar();
    }

    static /* synthetic */ DateFormat access$200(String x0) {
        return Times.newDateFormat(x0);
    }

    private static class DateKit {
        final Calendar calendar_ = Times.access$100();
        final Map<String, DateFormat> patternMap_ = new HashMap<String, DateFormat>();
        final DateFormat isoDateTimeFormat_ = Times.access$200("yyyy-MM-dd'T'HH:mm:ss");
        final DateFormat isoDateFormat_ = Times.access$200("yyyy-MM-dd");
        final DateFormat isoTimeFormat_ = Times.access$200("HH:mm:ss");

        private DateKit() {
        }
    }
}

