/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.ttools.calc.WebMapper;
import uk.ac.starlink.ttools.func.Formats;
import uk.ac.starlink.ttools.func.Maths;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.util.CgiQuery;

public class URLs {
    private static final String URI_DATA_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.~";
    private static final String HIPS2FITS_BASE = "http://alasky.u-strasbg.fr/hips-image-services/hips2fits";
    private static final String HIPS2FITS_BASE2 = "http://alaskybis.u-strasbg.fr/hips-image-services/hips2fits";

    private URLs() {
    }

    public static String urlEncode(String txt) {
        if (txt == null) {
            return null;
        }
        int nc = txt.length();
        StringBuffer sbuf = new StringBuffer(nc);
        for (int i = 0; i < nc; ++i) {
            char c = txt.charAt(i);
            if (URI_DATA_CHARS.indexOf(c) >= 0) {
                sbuf.append(c);
                continue;
            }
            if (c < '\u0010' || c > '\u007f') continue;
            sbuf.append('%').append(Integer.toHexString(c));
        }
        return sbuf.toString();
    }

    public static String urlDecode(String txt) {
        if (txt == null) {
            return null;
        }
        int nc = txt.length();
        StringBuffer sbuf = new StringBuffer(nc);
        for (int i = 0; i < nc; ++i) {
            char c = txt.charAt(i);
            if (c == '%') {
                try {
                    String hexPair = txt.substring(i + 1, i + 3);
                    c = (char)Integer.parseInt(hexPair, 16);
                    i += 2;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    public static String paramsUrl(String baseUrl, String ... nameValuePairs) {
        return URLs.paramsUrl(baseUrl, URLs.toStringMap(nameValuePairs));
    }

    private static String paramsUrl(String baseUrl, Map<String, String> pmap) {
        CgiQuery query = new CgiQuery(baseUrl);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            query.addArgument(entry.getKey(), entry.getValue());
        }
        return query.toURL().toString();
    }

    private static Map<String, String> toStringMap(String ... nameValuePairs) {
        int n2 = nameValuePairs.length;
        if (n2 % 2 == 0) {
            LinkedHashMap<String, String> pmap = new LinkedHashMap<String, String>();
            for (int i2 = 0; i2 < n2; i2 += 2) {
                pmap.put(nameValuePairs[i2], nameValuePairs[i2 + 1]);
            }
            return pmap;
        }
        return null;
    }

    public static String bibcodeUrl(String bibcode) {
        return URLs.webMap(WebMapper.BIBCODE, bibcode);
    }

    public static String doiUrl(String doi) {
        return URLs.webMap(WebMapper.DOI, doi);
    }

    public static String arxivUrl(String arxivId) {
        return URLs.webMap(WebMapper.ARXIV, arxivId);
    }

    public static String simbadUrl(String sourceId) {
        return URLs.webMap(WebMapper.SIMBAD, sourceId);
    }

    public static String nedUrl(String sourceId) {
        return URLs.webMap(WebMapper.NED, sourceId);
    }

    public static String hips2fitsUrl(String hipsId, String fmt, double raDeg, double decDeg, double fovDeg, int npix) {
        double pixSizeDeg = fovDeg / (double)npix;
        int decPlaces = -((int)Math.floor(Maths.log10(pixSizeDeg)));
        int ndp = Math.max(decPlaces + 1, 0);
        double fovEps = fovDeg / (double)npix;
        return new StringBuffer().append(HIPS2FITS_BASE).append("?hips=").append(hipsId).append("&format=").append(fmt).append("&ra=").append(Formats.formatDecimal(raDeg, ndp).replaceFirst("0+$", "")).append("&dec=").append(Formats.formatDecimal(decDeg, ndp).replaceFirst("0+$", "")).append("&fov=").append(PlotUtil.formatNumber(fovDeg, fovEps)).append("&width=").append(npix).append("&height=").append(npix).append("&projection=SIN").toString();
    }

    private static String webMap(WebMapper mapper, String txt) {
        if (txt == null) {
            return null;
        }
        URL url = mapper.toUrl(txt);
        return url == null ? null : url.toString();
    }
}

