/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import uk.ac.starlink.ttools.build.Heading;
import uk.ac.starlink.ttools.build.HideDoc;
import uk.ac.starlink.ttools.gui.DocNames;
import uk.ac.starlink.ttools.gui.ResourceIcon;

public class MethodBrowser
extends JPanel {
    private final JTree tree_ = new JTree(new DefaultMutableTreeNode());
    private final JEditorPane docPane_;
    private final Map<Object, String> objLabels_ = new HashMap<Object, String>();
    private static final Pattern TITLE_PATTERN = Pattern.compile(".*<title>([^<&].*?)</title>.*", 2);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.gui");

    public MethodBrowser() {
        super(new BorderLayout());
        this.tree_.setRootVisible(false);
        this.tree_.setShowsRootHandles(true);
        this.tree_.setCellRenderer(new DefaultTreeCellRenderer(){
            Font basicFont;
            Font strongFont;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int irow, boolean hasFocus) {
                Component comp = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, irow, hasFocus);
                if (comp instanceof JLabel && value instanceof DefaultMutableTreeNode) {
                    Icon icon;
                    JLabel label = (JLabel)comp;
                    Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
                    String text = MethodBrowser.this.textFor(userObj);
                    if (text != null) {
                        if (this.basicFont == null) {
                            this.basicFont = label.getFont();
                            this.strongFont = this.basicFont.deriveFont(1);
                        }
                        label.setFont(userObj instanceof Heading ? this.strongFont : this.basicFont);
                        label.setText(text);
                    }
                    if ((icon = MethodBrowser.this.iconFor(userObj)) != null) {
                        label.setIcon(icon);
                    }
                }
                return comp;
            }
        });
        DefaultMutableTreeNode root = this.getRoot();
        TreePath rootPath = new TreePath(root);
        this.tree_.expandPath(rootPath);
        this.tree_.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                MethodBrowser.this.nodeSelected(evt.getNewLeadSelectionPath());
            }
        });
        this.tree_.getSelectionModel().setSelectionMode(1);
        JScrollPane treeScroller = new JScrollPane(this.tree_);
        treeScroller.setPreferredSize(new Dimension(350, 450));
        this.docPane_ = new JEditorPane(){
            boolean fontSet;

            @Override
            public void paint(Graphics g) {
                if (!this.fontSet) {
                    this.fontSet = true;
                    this.setFont(Font.decode("SansSerif"));
                }
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g2);
            }
        };
        this.docPane_.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.docPane_.setEditable(false);
        HTMLEditorKit ekit = new HTMLEditorKit();
        StyleSheet stylesheet = new StyleSheet();
        stylesheet.addStyleSheet(ekit.getStyleSheet());
        stylesheet.addRule("p {margin-top: 10}");
        stylesheet.addRule("code {color: #6F3F0F}");
        ekit.setStyleSheet(stylesheet);
        this.docPane_.setEditorKit(ekit);
        this.docPane_.setText(MethodBrowser.getInstructions());
        JScrollPane docScroller = new JScrollPane(this.docPane_);
        docScroller.setPreferredSize(new Dimension(500, 450));
        JSplitPane splitter = new JSplitPane(1, false, treeScroller, docScroller);
        this.add((Component)splitter, "Center");
    }

    public JTree getTree() {
        return this.tree_;
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree_.getModel();
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.getTreeModel().getRoot();
    }

    public void addStaticClasses(Class<?>[] clazzes) {
        DefaultMutableTreeNode root = this.getRoot();
        for (int i = 0; i < clazzes.length; ++i) {
            this.addStaticClass(clazzes[i], root);
        }
        this.tree_.expandPath(new TreePath(root));
    }

    public void addStaticClass(Class<?> clazz, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode clazzNode = new DefaultMutableTreeNode(clazz);
        this.getTreeModel().insertNodeInto(clazzNode, parent, parent.getChildCount());
        parent.add(clazzNode);
        this.addPublicStaticMembers(clazzNode, clazz.getDeclaredMethods());
        this.addPublicStaticMembers(clazzNode, clazz.getDeclaredFields());
    }

    private void addPublicStaticMembers(DefaultMutableTreeNode parent, Member[] members) {
        ArrayList<Member> mems = new ArrayList<Member>(Arrays.asList(members));
        Iterator it = mems.iterator();
        while (it.hasNext()) {
            Member mem = (Member)it.next();
            int mods = mem.getModifiers();
            if (Modifier.isStatic(mods) && Modifier.isPublic(mods) && (!(mem instanceof AccessibleObject) || ((AccessibleObject)((Object)mem)).getAnnotation(HideDoc.class) == null)) continue;
            it.remove();
        }
        Collections.sort(mems, new Comparator<Member>(){

            @Override
            public int compare(Member m1, Member m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        DefaultTreeModel model = this.getTreeModel();
        for (Member mem : mems) {
            model.insertNodeInto(new DefaultMutableTreeNode(mem), parent, parent.getChildCount());
        }
    }

    private void nodeSelected(TreePath path) {
        Object leaf;
        if (path != null && (leaf = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            Object item = ((DefaultMutableTreeNode)leaf).getUserObject();
            URL docUrl = DocNames.docURL(item);
            if (docUrl != null) {
                try {
                    this.docPane_.setPage(docUrl);
                }
                catch (IOException e) {
                    logger_.warning("Trouble loading documentation at " + docUrl);
                }
            } else {
                logger_.warning("No documentation for " + leaf);
                this.docPane_.setText(null);
            }
        }
    }

    public String textFor(Object userObj) {
        if (userObj == null) {
            return null;
        }
        if (!this.objLabels_.containsKey(userObj)) {
            String text = null;
            if (userObj instanceof Heading) {
                text = ((Heading)userObj).getUserString();
            }
            if (text == null) {
                text = this.readTitleFromResource(DocNames.docURL(userObj));
            }
            if (text == null) {
                if (userObj instanceof Class) {
                    text = ((Class)userObj).getName();
                } else {
                    if (userObj instanceof Method) {
                        Method method = (Method)userObj;
                        StringBuffer sbuf = new StringBuffer().append(method.getReturnType().getName()).append(' ').append(method.getName()).append("( ");
                        Class<?>[] params = method.getParameterTypes();
                        for (int i = 0; i < params.length; ++i) {
                            if (i > 0) {
                                sbuf.append(", ");
                            }
                            sbuf.append(params[i].getName());
                        }
                        sbuf.append(" )");
                        return sbuf.toString();
                    }
                    if (userObj instanceof Field) {
                        Field field = (Field)userObj;
                        return field.getName();
                    }
                    if (userObj != null) {
                        text = userObj.toString();
                    }
                }
            }
            this.objLabels_.put(userObj, text);
        }
        return this.objLabels_.get(userObj);
    }

    public Icon iconFor(Object userObj) {
        if (userObj instanceof Method) {
            return ResourceIcon.FUNCTION_NODE;
        }
        if (userObj instanceof Field) {
            return ResourceIcon.CONSTANT_NODE;
        }
        if (userObj instanceof Class) {
            return ResourceIcon.LIBRARY_NODE;
        }
        if (userObj instanceof Heading) {
            return ResourceIcon.FOLDER_NODE;
        }
        if (userObj == null) {
            return null;
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTitleFromResource(URL url) {
        if (url == null) {
            return null;
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = in.readLine()) != null) {
                Matcher matcher = TITLE_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String string = matcher.group(1);
                return string;
            }
            line = null;
            return line;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getInstructions() {
        return new StringBuffer().append("<h1>Function Browser</h1>").append("<p>Open tree nodes on the left by double-clicking\n").append("to Select categories of functions.\n").append("Clicking on the name of a function or constant\n").append("will show details of its usage and semantics.\n").append("</p>").toString();
    }
}

