/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import uk.ac.starlink.util.gui.RenderingComboBox;

public class ThicknessComboBox
extends RenderingComboBox<Integer> {
    private static final int LINE_LENGTH = 48;

    public ThicknessComboBox(int maxThick) {
        Integer[] numbers = new Integer[maxThick];
        for (int i = 0; i < maxThick; ++i) {
            numbers[i] = i + 1;
        }
        this.setModel(new DefaultComboBoxModel<Integer>(numbers));
    }

    public int getSelectedThickness() {
        return this.getSelectedIndex() + 1;
    }

    public void setSelectedThickness(int thick) {
        this.setSelectedIndex(Math.max(thick - 1, 0));
    }

    public Icon getRendererIcon(Integer thickObj) {
        final int thick = thickObj;
        return new Icon(){

            @Override
            public int getIconHeight() {
                return thick;
            }

            @Override
            public int getIconWidth() {
                return 52;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Stroke oldStroke = g2.getStroke();
                Color oldColor = g2.getColor();
                g2.setColor(Color.BLACK);
                g2.setStroke(new BasicStroke(thick, 0, 0, 10.0f, null, 0.0f));
                int ypos = y + thick / 2;
                g2.drawLine(x + 4, ypos, x + 4 + 48, ypos);
                g2.setStroke(oldStroke);
                g2.setColor(oldColor);
            }
        };
    }
}

