/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.DVMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.ttools.jel.Constant;

public class ConstantResolver
extends DVMap {
    private final Map<String, ? extends Constant<?>> constMap_;
    private final Set<Constant<?>> translatedConsts_;

    public ConstantResolver(Map<String, ? extends Constant<?>> constMap) {
        this.constMap_ = constMap;
        this.translatedConsts_ = new LinkedHashSet();
    }

    public Map<String, ? extends Constant<?>> getConstantMap() {
        return this.constMap_;
    }

    public Set<Constant<?>> getTranslatedConstants() {
        return this.translatedConsts_;
    }

    @Override
    public String getTypeName(String name) {
        Constant<?> konst = this.constMap_.get(name);
        if (konst == null) {
            return null;
        }
        this.translatedConsts_.add(konst);
        Class<?> clazz = konst.getContentClass();
        if (clazz == Double.class) {
            return "Double";
        }
        if (clazz == Float.class) {
            return "Float";
        }
        if (clazz == Long.class) {
            return "Long";
        }
        if (clazz == Integer.class) {
            return "Integer";
        }
        if (clazz == Short.class) {
            return "Short";
        }
        if (clazz == Byte.class) {
            return "Byte";
        }
        if (clazz == Boolean.class) {
            return "Boolean";
        }
        if (clazz == Character.class) {
            return "Character";
        }
        if (clazz == String.class) {
            return "String";
        }
        return "Object";
    }

    public double getDoubleProperty(String name) {
        return (Double)this.constMap_.get(name).getValue();
    }

    public float getFloatProperty(String name) {
        return ((Float)this.constMap_.get(name).getValue()).floatValue();
    }

    public long getLongProperty(String name) {
        return (Long)this.constMap_.get(name).getValue();
    }

    public int getIntegerProperty(String name) {
        return (Integer)this.constMap_.get(name).getValue();
    }

    public short getShortProperty(String name) {
        return (Short)this.constMap_.get(name).getValue();
    }

    public byte getByteProperty(String name) {
        return (Byte)this.constMap_.get(name).getValue();
    }

    public boolean getBooleanProperty(String name) {
        return (Boolean)this.constMap_.get(name).getValue();
    }

    public char getCharacterProperty(String name) {
        return ((Character)this.constMap_.get(name).getValue()).charValue();
    }

    public String getStringProperty(String name) {
        return (String)this.constMap_.get(name).getValue();
    }

    public Object getObjectProperty(String name) {
        return this.constMap_.get(name).getValue();
    }
}

