/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompiledExpression;
import java.io.IOException;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public abstract class RandomJELRowReader
extends StarTableJELRowReader {
    protected RandomJELRowReader(StarTable table) {
        super(table);
    }

    public abstract Object evaluateAtRow(CompiledExpression var1, long var2) throws Throwable;

    public static RandomJELRowReader createConcurrentReader(final StarTable table) {
        return new RandomJELRowReader(table){
            private long lrow_;
            {
                super(table2);
                this.lrow_ = -1L;
            }

            @Override
            public long getCurrentRow() {
                return this.lrow_;
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return table.getCell(this.lrow_, icol);
            }

            @Override
            public synchronized Object evaluateAtRow(CompiledExpression compEx, long lrow) throws Throwable {
                this.lrow_ = lrow;
                return this.evaluate(compEx);
            }
        };
    }

    public static RandomJELRowReader createAccessReader(StarTable table, final RowAccess racc) {
        return new RandomJELRowReader(table){
            private long lrow_;
            {
                super(table);
                this.lrow_ = -1L;
            }

            @Override
            public long getCurrentRow() {
                return this.lrow_;
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return racc.getCell(icol);
            }

            @Override
            public Object evaluateAtRow(CompiledExpression compEx, long lrow) throws Throwable {
                if (lrow != this.lrow_) {
                    racc.setRowIndex(lrow);
                    this.lrow_ = lrow;
                }
                return this.evaluate(compEx);
            }
        };
    }

    public static RandomJELRowReader createAccessReader(StarTable table) throws IOException {
        return RandomJELRowReader.createAccessReader(table, table.getRowAccess());
    }
}

