/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.util.logging.Logger;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AnisotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.CdsHealpixSkyPixellator;
import uk.ac.starlink.table.join.CombinedMatchEngine;
import uk.ac.starlink.table.join.CuboidCartesianMatchEngine;
import uk.ac.starlink.table.join.EllipseCartesianMatchEngine;
import uk.ac.starlink.table.join.EllipseSkyMatchEngine;
import uk.ac.starlink.table.join.EqualsMatchEngine;
import uk.ac.starlink.table.join.ErrorCartesianMatchEngine;
import uk.ac.starlink.table.join.ErrorSkyMatchEngine;
import uk.ac.starlink.table.join.ErrorSummation;
import uk.ac.starlink.table.join.FixedSkyMatchEngine;
import uk.ac.starlink.table.join.HtmSkyPixellator;
import uk.ac.starlink.table.join.IsotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.SkyPixellator;
import uk.ac.starlink.table.join.SphericalPolarMatchEngine;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.ttools.task.WordsParameter;
import uk.ac.starlink.util.Loader;

public class MatchEngineParameter
extends Parameter<MatchEngine>
implements ExtraParameter {
    private final WordsParameter<String> paramsParam_ = WordsParameter.createStringWordsParameter("params");
    private final WordsParameter<String> tuningParam_ = WordsParameter.createStringWordsParameter("tuning");
    private final StringParameter scoreParam_;
    private static final int MAX_CHARS = 78;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Score", Number.class, "Closeness of match (0 is exact)");
    private static final double ARC_SECOND = 4.84813681109536E-6;
    private static final String TUPLE_NAME = "values";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.join");

    public MatchEngineParameter(String name) {
        super(name, MatchEngine.class, true);
        this.setStringDefault("sky");
        this.setPreferExplicit(true);
        this.setUsage("<matcher-name>");
        this.setPrompt("Name of matching algorithm");
        this.setDescription(new String[]{"<p>Defines the nature of the matching that will be performed.", "Depending on the name supplied, this may be positional", "matching using celestial or Cartesian coordinates,", "exact matching on the value of a string column,", "or other things.", "A list and explanation of the available matching algorithms", "is given in <ref id='MatchEngine'/>.", "The value supplied for this parameter determines the meanings", "of the values required by the ", "<code>" + this.paramsParam_.getName() + "</code>,", "<code>values*</code> and", "<code>" + this.tuningParam_.getName() + "</code>", "parameter(s).", "</p>"});
        this.paramsParam_.setPrompt("Match parameters");
        this.paramsParam_.setDescription(new String[]{"<p>Determines the parameters of this match.", "This is typically one or more tolerances such as error radii.", "It may contain zero or more values; the values that are", "required depend on the match type selected by the", "<code>" + this.getName() + "</code> parameter.", "If it contains multiple values, they must be separated by spaces;", "values which contain a space can be 'quoted' or \"quoted\".", "</p>"});
        this.paramsParam_.setNullPermitted(true);
        this.paramsParam_.setUsage("<match-params>");
        this.tuningParam_.setPrompt("Tuning parameters");
        this.tuningParam_.setDescription(new String[]{"<p>Tuning values for the matching process, if appropriate.", "It may contain zero or more values; the values that are", "permitted depend on the match type selected by the", "<code>" + this.getName() + "</code> parameter.", "If it contains multiple values, they must be separated by spaces;", "values which contain a space can be 'quoted' or \"quoted\".", "If this optional parameter is not supplied, sensible defaults", "will be chosen.", "</p>"});
        this.tuningParam_.setNullPermitted(true);
        this.tuningParam_.setUsage("<tuning-params>");
        this.scoreParam_ = new StringParameter("scorecol");
        this.scoreParam_.setUsage("<col-name>");
        this.scoreParam_.setPrompt("Match score output column name");
        this.scoreParam_.setDescription(new String[]{"<p>Gives the name of a column in the output table to contain", "the \"match score\" for each pairwise match.", "The meaning of this column is dependent on the chosen", "<code>" + this.getName() + "</code>,", "but it typically represents a distance of some kind between", "the two matching points.", "If a null value is chosen, no score column will be inserted", "in the output table.", "The default value of this parameter depends on", "<code>" + this.getName() + "</code>.", "</p>"});
        this.scoreParam_.setNullPermitted(true);
        this.scoreParam_.setStringDefault(SCORE_INFO.getName());
    }

    @Override
    public String getExtraUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Available matchers, with associated parameters, include:\n");
        try {
            for (String name : MatchEngineParameter.getExampleValues()) {
                StringBuffer line = new StringBuffer();
                MatchEngine engine = this.createEngine(name);
                line.append("      ").append(this.getName()).append('=').append(name);
                String pad = line.toString().replaceAll(".", " ");
                String vu = this.getValuesUsage(engine, line.length());
                String pu = this.getConfigUsage(engine, this.paramsParam_, engine.getMatchParameters());
                String tu = this.getConfigUsage(engine, this.tuningParam_, engine.getTuningParameters());
                int leng = line.length();
                line.append(vu);
                if ((leng += vu.length()) + pu.length() > 78) {
                    line.append('\n').append(pad);
                    leng = pad.length();
                }
                line.append(pu);
                if ((leng += pu.length()) + tu.length() > 78) {
                    line.append('\n').append(pad);
                    leng = pad.length();
                }
                line.append(tu);
                leng += tu.length();
                line.append('\n');
                sbuf.append(line);
            }
        }
        catch (UsageException e) {
            sbuf.append("\n      ???\n");
        }
        return sbuf.toString();
    }

    public Parameter<String[]> getMatchParametersParameter() {
        return this.paramsParam_;
    }

    public Parameter<String[]> getTuningParametersParameter() {
        return this.tuningParam_;
    }

    public Parameter<String> getScoreParameter() {
        return this.scoreParam_;
    }

    public ValueInfo getScoreInfo(Environment env) throws TaskException {
        String scoreVal = this.scoreParam_.stringValue(env);
        if (scoreVal == null || scoreVal.trim().length() == 0) {
            return null;
        }
        ValueInfo baseInfo = ((MatchEngine)this.objectValue(env)).getMatchScoreInfo();
        DefaultValueInfo info = baseInfo == null ? new DefaultValueInfo(SCORE_INFO) : new DefaultValueInfo(baseInfo);
        info.setName(scoreVal);
        return info;
    }

    public WordsParameter<String> createMatchTupleParameter(String numLabel) {
        boolean isNumbered = numLabel != null && numLabel.length() > 0;
        WordsParameter<String> tupleParam = WordsParameter.createStringWordsParameter(TUPLE_NAME + numLabel);
        tupleParam.setUsage("<expr-list>");
        tupleParam.setPrompt("Expressions for match values" + (isNumbered ? " from table " + numLabel : ""));
        tupleParam.setDescription(new String[]{"<p>Defines the values from", isNumbered ? "table " + numLabel : "the input table", "which are used to determine whether a match has occurred.", "These will typically be coordinate values such as RA and Dec", "and perhaps some per-row error values as well, though exactly", "what values are required is determined by the kind of match", "as determined by <code>" + this.getName() + "</code>.", "Depending on the kind of match, the number and type of", "the values required will be different.", "Multiple values should be separated by whitespace;", "if whitespace occurs within a single value it must be", "'quoted' or \"quoted\".", "Elements of the expression list are commonly just column", "names, but may be algebraic expressions calculated from", "zero or more columns as explained in <ref id='jel'/>.", "</p>"});
        return tupleParam;
    }

    public static void configureTupleParameter(WordsParameter<String> tupleParam, MatchEngine matcher) {
        String tname = tupleParam.getName();
        int inum = tname.indexOf(TUPLE_NAME);
        String numLabel = inum >= 0 ? tname.substring(TUPLE_NAME.length() + inum) : "";
        ValueInfo[] tinfos = matcher.getTupleInfos();
        int nexpr = tinfos.length;
        StringBuffer sbuf = new StringBuffer();
        if (numLabel == null || numLabel.length() == 0) {
            sbuf.append("Match value expressions");
        } else {
            sbuf.append("Table ").append(numLabel).append(" match value expressions");
        }
        sbuf.append(" (");
        for (int i = 0; i < nexpr; ++i) {
            if (i > 0) {
                sbuf.append(' ');
            }
            sbuf.append(tinfos[i].getName().replaceAll(" ", "_"));
            String units = tinfos[i].getUnitString();
            if (units == null || units.trim().length() <= 0) continue;
            if (units.equalsIgnoreCase("degree") || units.equalsIgnoreCase("degrees")) {
                units = "deg";
            }
            sbuf.append('/').append(units);
        }
        sbuf.append(")");
        String prompt = sbuf.toString();
        tupleParam.setRequiredWordCount(nexpr);
        tupleParam.setPrompt(prompt);
    }

    public MatchEngine matchEngineValue(Environment env) throws TaskException {
        return (MatchEngine)this.objectValue(env);
    }

    public MatchEngine stringToObject(Environment env, String stringVal) throws TaskException {
        MatchEngine engine = this.createEngine(stringVal);
        ValueInfo scoreInfo = engine.getMatchScoreInfo();
        this.scoreParam_.setStringDefault(scoreInfo == null ? null : scoreInfo.getName());
        this.setConfigValues(env, engine.getMatchParameters(), this.paramsParam_, true);
        this.setConfigValues(env, engine.getTuningParameters(), this.tuningParam_, false);
        if (engine instanceof CombinedMatchEngine && !(engine.getScoreScale() > 0.0)) {
            logger_.warning("Matcher " + stringVal + " can't be scaled; Best match won't make much sense");
        }
        return engine;
    }

    private void setConfigValues(Environment env, DescribedValue[] configs, WordsParameter<String> wordsParam, boolean required) throws TaskException {
        int nConfig = configs.length;
        if (nConfig == 0) {
            wordsParam.setNullPermitted(true);
            wordsParam.setStringDefault(null);
        } else {
            int i;
            wordsParam.setNullPermitted(!required);
            StringBuffer sbuf = new StringBuffer(wordsParam.getPrompt()).append(" (");
            for (int i2 = 0; i2 < nConfig; ++i2) {
                if (i2 > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(MatchEngineParameter.getInfoUsage(configs[i2].getInfo()));
            }
            sbuf.append(')');
            wordsParam.setPrompt(sbuf.toString());
            wordsParam.setRequiredWordCount(nConfig);
            String[] words = wordsParam.wordsValue(env);
            if (words != null) {
                for (i = 0; i < nConfig; ++i) {
                    String word = words[i];
                    try {
                        configs[i].setValueFromString(word);
                        continue;
                    }
                    catch (RuntimeException e) {
                        throw new UsageException("Value " + words[i] + " not suitable for " + configs[i].getInfo(), (Throwable)e);
                    }
                }
            }
            for (i = 0; i < nConfig; ++i) {
                logger_.info(configs[i].toString());
            }
        }
    }

    public MatchEngine createEngine(String name) throws UsageException {
        NameList nameList = MatchEngineParameter.parseNameList(name);
        String[] names = nameList.names_;
        MatchEngine[] components = new MatchEngine[names.length];
        for (int i = 0; i < names.length; ++i) {
            FixedSkyMatchEngine.InDegrees component;
            String cName = names[i];
            if ("sky".equalsIgnoreCase(cName) || "healpix".equalsIgnoreCase(cName)) {
                component = new FixedSkyMatchEngine.InDegrees((SkyPixellator)new CdsHealpixSkyPixellator(), 4.84813681109536E-6);
            } else if ("skyerr".equalsIgnoreCase(cName)) {
                component = new ErrorSkyMatchEngine.InDegrees((SkyPixellator)new CdsHealpixSkyPixellator(), ErrorSummation.SIMPLE, 4.84813681109536E-6);
            } else if ("skyerr_q".equalsIgnoreCase(cName)) {
                component = new ErrorSkyMatchEngine.InDegrees((SkyPixellator)new CdsHealpixSkyPixellator(), ErrorSummation.QUADRATURE, 4.84813681109536E-6);
            } else if ("skyellipse".equalsIgnoreCase(cName)) {
                component = new EllipseSkyMatchEngine.InDegrees((SkyPixellator)new CdsHealpixSkyPixellator(), 4.84813681109536E-6);
            } else if ("skyellipse-nocirc".equalsIgnoreCase(cName)) {
                EllipseSkyMatchEngine.InDegrees matcher = new EllipseSkyMatchEngine.InDegrees((SkyPixellator)new CdsHealpixSkyPixellator(), 4.84813681109536E-6);
                matcher.setRecogniseCircles(false);
                component = matcher;
            } else if ("sky3d".equalsIgnoreCase(cName)) {
                component = new SphericalPolarMatchEngine.InDegrees(0.0);
            } else if ("exact".equalsIgnoreCase(cName)) {
                component = new EqualsMatchEngine();
            } else if ("2d_ellipse".equalsIgnoreCase(cName)) {
                component = new EllipseCartesianMatchEngine.InDegrees(1.0);
            } else if ("2d_ellipse-nocirc".equalsIgnoreCase(cName)) {
                EllipseCartesianMatchEngine.InDegrees matcher = new EllipseCartesianMatchEngine.InDegrees(1.0);
                matcher.setRecogniseCircles(false);
                component = matcher;
            } else if (cName.matches("[0-9][dD]")) {
                int ndim = Integer.parseInt(cName.substring(0, 1));
                component = new IsotropicCartesianMatchEngine(ndim, 0.0, false);
            } else if (cName.toLowerCase().matches("[0-9]d_err")) {
                int ndim = Integer.parseInt(cName.substring(0, 1));
                component = new ErrorCartesianMatchEngine(ndim, ErrorSummation.SIMPLE, 1.0);
            } else if (cName.toLowerCase().matches("[0-9]d_err_q")) {
                int ndim = Integer.parseInt(cName.substring(0, 1));
                component = new ErrorCartesianMatchEngine(ndim, ErrorSummation.QUADRATURE, 1.0);
            } else if (cName.toLowerCase().matches("[0-9]d_anisotropic")) {
                int ndim = Integer.parseInt(cName.substring(0, 1));
                component = new AnisotropicCartesianMatchEngine(new double[ndim]);
            } else if (cName.toLowerCase().matches("[0-9]d_cuboid")) {
                int ndim = Integer.parseInt(cName.substring(0, 1));
                component = new CuboidCartesianMatchEngine(new double[ndim]);
            } else if (cName.equalsIgnoreCase("htm")) {
                component = new FixedSkyMatchEngine.InDegrees((SkyPixellator)new HtmSkyPixellator(), 4.84813681109536E-6);
            } else {
                component = (MatchEngine)Loader.getClassInstance((String)cName, MatchEngine.class);
                if (component == null) {
                    throw new UsageException("Unknown matcher element: " + cName);
                }
            }
            components[i] = component;
        }
        return components.length == 1 ? components[0] : new CombinedMatchEngine(components, nameList.inSphere_);
    }

    public String getValuesUsage(MatchEngine engine, int startLeng) {
        StringBuffer sbuf = new StringBuffer();
        ValueInfo[] tupleInfos = engine.getTupleInfos();
        if (tupleInfos.length > 0) {
            int baseLeng;
            sbuf.append(" values*='");
            int leng = baseLeng = startLeng + sbuf.length();
            for (int iv = 0; iv < tupleInfos.length; ++iv) {
                StringBuffer vbuf = new StringBuffer();
                if (iv > 0) {
                    vbuf.append(' ');
                }
                vbuf.append('<').append(MatchEngineParameter.getInfoUsage(tupleInfos[iv])).append('>');
                if (leng + vbuf.length() > 78) {
                    sbuf.append('\n');
                    for (int is = 0; is < baseLeng - 1; ++is) {
                        sbuf.append(' ');
                    }
                    leng = baseLeng;
                }
                sbuf.append(vbuf);
                leng += vbuf.length();
            }
            sbuf.append('\'');
        }
        return sbuf.toString();
    }

    public String getConfigUsage(MatchEngine engine, Parameter<String[]> wordsParam, DescribedValue[] configs) {
        StringBuffer sbuf = new StringBuffer();
        if (configs.length > 0) {
            sbuf.append(' ').append(wordsParam.getName()).append('=').append('\'');
            for (int i = 0; i < configs.length; ++i) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append('<').append(MatchEngineParameter.getInfoUsage(configs[i].getInfo())).append('>');
            }
            sbuf.append('\'');
        }
        return sbuf.toString();
    }

    public static String getInfoUsage(ValueInfo info) {
        StringBuffer sbuf = new StringBuffer().append(info.getName().toLowerCase().replaceAll(" ", "-"));
        String units = info.getUnitString();
        if (units != null) {
            sbuf.append('/').append(units);
        }
        return sbuf.toString();
    }

    public static String[] getExampleValues() {
        return new String[]{"sky", "sky3d", "skyerr", "skyellipse", "exact", "1d", "2d", "3d", "2d_anisotropic", "3d_anisotropic", "2d_cuboid", "3d_cuboid", "1d_err", "2d_err", "2d_err_q", "2d_ellipse", "sky+1d"};
    }

    private static NameList parseNameList(String text) throws UsageException {
        boolean inSphere;
        char sep;
        boolean hasStar;
        boolean hasPlus = text.indexOf(43) >= 0;
        boolean bl = hasStar = text.indexOf(42) >= 0;
        if (hasPlus && hasStar) {
            throw new UsageException("Illegal mix of '+' and '*' separators in \"" + text + "\"");
        }
        if (hasStar) {
            sep = '*';
            inSphere = true;
        } else {
            sep = '+';
            inSphere = false;
        }
        String[] names = text.trim().split("\\" + sep, -1);
        return new NameList(names, inSphere);
    }

    private static class NameList {
        final String[] names_;
        final boolean inSphere_;

        NameList(String[] names, boolean inSphere) {
            this.names_ = names;
            this.inSphere_ = inSphere;
        }
    }
}

