/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.moc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import uk.ac.starlink.ttools.moc.IndexBag;

public class IntegerBag
implements IndexBag {
    private final Set<Integer> intSet_;
    private final int setmax_;
    private int[] sortedInts_;
    public static final int DFLT_SETMAX = 100000;

    public IntegerBag() {
        this(100000);
    }

    public IntegerBag(int setmax) {
        this.intSet_ = new HashSet<Integer>(setmax);
        this.setmax_ = setmax;
        this.sortedInts_ = new int[0];
    }

    @Override
    public boolean hasIndex(long lval) {
        int ival = (int)lval;
        return this.intSet_.contains(ival) || Arrays.binarySearch(this.sortedInts_, ival) >= 0;
    }

    @Override
    public void addIndex(long lval) {
        int ival = (int)lval;
        if (Arrays.binarySearch(this.sortedInts_, ival) < 0) {
            this.intSet_.add(ival);
            if (this.intSet_.size() > this.setmax_) {
                this.drainSet();
            }
        }
    }

    @Override
    public long getCount() {
        this.drainSet();
        return this.sortedInts_.length;
    }

    @Override
    public PrimitiveIterator.OfLong sortedLongIterator() {
        this.drainSet();
        return Arrays.stream(this.sortedInts_).asLongStream().iterator();
    }

    private void drainSet() {
        int[] array0 = this.sortedInts_;
        int[] array1 = new int[array0.length + this.intSet_.size()];
        System.arraycopy(array0, 0, array1, 0, array0.length);
        int ix = array0.length;
        for (Integer ival : this.intSet_) {
            array1[ix++] = ival;
        }
        this.intSet_.clear();
        Arrays.sort(array1);
        this.sortedInts_ = array1;
    }
}

