/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.moc;

import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.SMoc;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.PrimitiveIterator;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.ttools.func.Coverage;
import uk.ac.starlink.util.DataBufferedOutputStream;

public abstract class MocStreamFormat {
    private final String name_;
    public static final MocStreamFormat ASCII = new AsciiFormat("ascii");
    public static final MocStreamFormat JSON;
    public static final MocStreamFormat FITS;
    public static final MocStreamFormat RAW;
    public static final MocStreamFormat SUMMARY;
    public static final MocStreamFormat CDS_ASCII;
    public static final MocStreamFormat CDS_JSON;
    public static final MocStreamFormat CDS_FITS;
    public static final MocStreamFormat[] FORMATS;

    protected MocStreamFormat(String name) {
        this.name_ = name;
    }

    public abstract void writeMoc(PrimitiveIterator.OfLong var1, long var2, int var4, OutputStream var5) throws IOException;

    public String toString() {
        return this.name_;
    }

    private static int uniqToOrder(long uniq) {
        return Coverage.uniqToOrder(uniq);
    }

    private static long uniqToIndex(long uniq) {
        return Coverage.uniqToIndex(uniq);
    }

    static {
        FITS = new FitsFormat("fits");
        JSON = new JsonFormat("json");
        RAW = new RawFormat("raw");
        SUMMARY = new SummaryFormat("summary");
        CDS_ASCII = new CdsFormat("cds_ascii", (smoc, out) -> {
            smoc.writeASCII(out);
            out.write(10);
        });
        CDS_JSON = new CdsFormat("cds_json", Moc1D::writeJSON);
        CDS_FITS = new CdsFormat("cds_fits", Moc::writeFITS);
        FORMATS = new MocStreamFormat[]{ASCII, FITS, JSON, RAW, SUMMARY, CDS_ASCII, CDS_JSON, CDS_FITS};
    }

    private static abstract class TextWriter {
        private final OutputStream out_;

        TextWriter(OutputStream out) {
            this.out_ = out;
        }

        abstract void writeUniq(long var1) throws IOException;

        abstract void flush() throws IOException;

        void write(String txt) throws IOException {
            this.out_.write(txt.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static class CdsFormat
    extends MocStreamFormat {
        private final SmocWriter smocWriter_;

        CdsFormat(String name, SmocWriter smocWriter) {
            super(name);
            this.smocWriter_ = smocWriter;
        }

        @Override
        public void writeMoc(PrimitiveIterator.OfLong uniqIt, long count, int maxOrder, OutputStream out) throws IOException {
            SMoc smoc = new SMoc();
            smoc.bufferOn(500000);
            try {
                while (uniqIt.hasNext()) {
                    long uniq = uniqIt.nextLong();
                    smoc.add(MocStreamFormat.uniqToOrder(uniq), MocStreamFormat.uniqToIndex(uniq));
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            smoc.bufferOff();
            try {
                this.smocWriter_.writeSmoc(smoc, out);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @FunctionalInterface
        static interface SmocWriter {
            public void writeSmoc(SMoc var1, OutputStream var2) throws Exception;
        }
    }

    private static class FitsFormat
    extends MocStreamFormat {
        FitsFormat(String name) {
            super(name);
        }

        @Override
        public void writeMoc(PrimitiveIterator.OfLong uniqIt, long count, int maxOrder, OutputStream out) throws IOException {
            boolean isLong = maxOrder >= 14;
            FitsUtil.writeEmptyPrimary((OutputStream)out);
            CardFactory cfact = CardFactory.DEFAULT;
            CardImage[] cards = new CardImage[]{cfact.createStringCard("XTENSION", "BINTABLE", "binary table extension"), cfact.createIntegerCard("BITPIX", 8L, "8-bit bytes"), cfact.createIntegerCard("NAXIS", 2L, "2-dimensional table"), cfact.createIntegerCard("NAXIS1", isLong ? 8L : 4L, "width of table in bytes"), cfact.createIntegerCard("NAXIS2", count, "row count"), cfact.createIntegerCard("PCOUNT", 0L, "size of special data area"), cfact.createIntegerCard("GCOUNT", 1L, "one data group"), cfact.createIntegerCard("TFIELDS", 1L, "number of columns"), cfact.createStringCard("TFORM1", isLong ? "1K" : "1J", "Type for column 1"), cfact.createStringCard("MOCVERS", "2.0", "MOC version"), cfact.createStringCard("TTYPE1", "UNIQ", "UNIQ pixel number"), cfact.createStringCard("COORDSYS", "C", "Space reference frame"), cfact.createStringCard("MOCDIM", "SPACE", "Physical dimension"), cfact.createIntegerCard("MOCORD_S", (long)maxOrder, "Maximum MOC order"), cfact.createIntegerCard("MOCORDER", (long)maxOrder, "Maximum MOC order"), cfact.createStringCard("MOCTOOL", "STIL", "Name of MOC generator"), CardFactory.END_CARD};
            FitsUtil.writeHeader((CardImage[])cards, (OutputStream)out);
            DataBufferedOutputStream dataOut = new DataBufferedOutputStream(out);
            if (isLong) {
                while (uniqIt.hasNext()) {
                    dataOut.writeLong(uniqIt.nextLong());
                }
            } else {
                while (uniqIt.hasNext()) {
                    long uniq = uniqIt.nextLong();
                    int iuniq = (int)uniq;
                    assert ((long)iuniq == uniq);
                    dataOut.writeInt(iuniq);
                }
            }
            dataOut.flush();
            long nWritten = (long)(isLong ? 8 : 4) * count;
            int extra = (int)(nWritten % 2880L);
            if (extra > 0) {
                out.write(new byte[2880 - extra]);
            }
        }
    }

    private static class JsonFormat
    extends MocStreamFormat {
        JsonFormat(String name) {
            super(name);
        }

        @Override
        public void writeMoc(PrimitiveIterator.OfLong uniqIt, long count, int maxOrder, OutputStream out) throws IOException {
            JsonWriter writer = new JsonWriter(out);
            writer.write("{");
            while (uniqIt.hasNext()) {
                writer.writeUniq(uniqIt.nextLong());
            }
            writer.flush();
        }

        private static class JsonWriter
        extends TextWriter {
            private int lastOrder_ = -1;

            JsonWriter(OutputStream out) {
                super(out);
            }

            @Override
            void writeUniq(long uniq) throws IOException {
                int order = MocStreamFormat.uniqToOrder(uniq);
                long index = MocStreamFormat.uniqToIndex(uniq);
                if (order == this.lastOrder_) {
                    this.write(",");
                } else {
                    if (this.lastOrder_ >= 0) {
                        this.write("],");
                    }
                    this.write("\n  \"" + Integer.toString(order) + "\": [");
                    this.lastOrder_ = order;
                }
                this.write(Long.toString(index));
            }

            @Override
            void flush() throws IOException {
                if (this.lastOrder_ >= 0) {
                    this.write("]");
                }
                this.write("\n}\n");
            }
        }
    }

    private static class AsciiFormat
    extends MocStreamFormat {
        AsciiFormat(String name) {
            super(name);
        }

        @Override
        public void writeMoc(PrimitiveIterator.OfLong uniqIt, long count, int maxOrder, OutputStream out) throws IOException {
            AsciiWriter writer = new AsciiWriter(out);
            while (uniqIt.hasNext()) {
                writer.writeUniq(uniqIt.nextLong());
            }
            writer.flush();
        }

        private static class AsciiWriter
        extends TextWriter {
            private int lastOrder_;
            private long i0_ = -2L;
            private long i1_ = -4L;
            private long i2_;
            private int o0_ = -3;
            private int o1_ = -1;
            private int o2_;

            AsciiWriter(OutputStream out) {
                super(out);
            }

            @Override
            void writeUniq(long uniq) throws IOException {
                this.i2_ = this.i1_;
                this.i1_ = this.i0_;
                this.i0_ = MocStreamFormat.uniqToIndex(uniq);
                this.o2_ = this.o1_;
                this.o1_ = this.o0_;
                this.o0_ = MocStreamFormat.uniqToOrder(uniq);
                if (this.o1_ >= 0) {
                    this.write1();
                }
            }

            @Override
            void flush() throws IOException {
                this.i2_ = this.i1_;
                this.i1_ = this.i0_;
                this.i0_ = Long.MAX_VALUE;
                this.o2_ = this.o1_;
                this.o1_ = this.o0_;
                this.o0_ = Integer.MAX_VALUE;
                this.write1();
                this.write("\n");
            }

            private void write1() throws IOException {
                if (this.o1_ != this.o2_) {
                    this.write(" " + Integer.toString(this.o1_) + "/" + Long.toString(this.i1_));
                } else if (this.i1_ != this.i2_ + 1L) {
                    this.write(" " + Long.toString(this.i1_));
                } else if (this.i1_ != this.i0_ - 1L) {
                    this.write("-" + Long.toString(this.i1_));
                }
            }
        }
    }

    private static class SummaryFormat
    extends MocStreamFormat {
        SummaryFormat(String name) {
            super(name);
        }

        @Override
        public void writeMoc(PrimitiveIterator.OfLong uniqIt, long count, int maxOrder, OutputStream out) {
            long ntile = 0L;
            int maxOrd = 0;
            double cov = 0.0;
            Adler32 cksum = new Adler32();
            while (uniqIt.hasNext()) {
                long uniq = uniqIt.next();
                ++ntile;
                SummaryFormat.updateChecksum(cksum, uniq);
                int order = MocStreamFormat.uniqToOrder(uniq);
                maxOrd = Math.max(order, maxOrd);
                cov += 1.0 / (double)(12L << 2 * order);
            }
            if (ntile != count) {
                throw new IllegalArgumentException("count mismatch: " + ntile + " != " + count);
            }
            if (maxOrd != maxOrder) {
                throw new IllegalArgumentException("Max order mismatch: " + maxOrd + " != " + maxOrder);
            }
            PrintStream pout = new PrintStream(out);
            pout.println("Count: " + count + "\nOrder: " + maxOrder + "\nCoverage: " + cov + "\nChecksum: " + Long.toHexString(cksum.getValue()));
            pout.flush();
        }

        private static void updateChecksum(Checksum cksum, long lvalue) {
            cksum.update((byte)(lvalue >>> 56));
            cksum.update((byte)(lvalue >>> 48));
            cksum.update((byte)(lvalue >>> 40));
            cksum.update((byte)(lvalue >>> 32));
            cksum.update((byte)(lvalue >>> 24));
            cksum.update((byte)(lvalue >>> 16));
            cksum.update((byte)(lvalue >>> 8));
            cksum.update((byte)(lvalue >>> 0));
        }
    }

    private static class RawFormat
    extends MocStreamFormat {
        RawFormat(String name) {
            super(name);
        }

        @Override
        public void writeMoc(PrimitiveIterator.OfLong uniqIt, long count, int maxOrder, OutputStream out) throws IOException {
            TextWriter writer = new TextWriter(out){

                @Override
                public void writeUniq(long uniq) throws IOException {
                    this.write(new StringBuffer().append(Long.toHexString(uniq)).append(":\t").append(MocStreamFormat.uniqToOrder(uniq)).append("\t").append(MocStreamFormat.uniqToIndex(uniq)).append("\n").toString());
                }

                @Override
                public void flush() {
                }
            };
            while (uniqIt.hasNext()) {
                writer.writeUniq(uniqIt.nextLong());
            }
            writer.flush();
        }
    }
}

