/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import java.io.PrintStream;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class CountMode
implements ProcessingMode {
    private final boolean isParallel_;

    public CountMode() {
        this(true);
    }

    public CountMode(boolean isParallel) {
        this.isParallel_ = isParallel;
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[0];
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Counts the number of rows and columns", "and writes the result to standard output.", "</p>"});
    }

    @Override
    public TableConsumer createConsumer(Environment env) {
        final PrintStream out = env.getOutputStream();
        return new TableConsumer(){

            @Override
            public void consume(StarTable table) throws IOException {
                out.println(CountMode.this.getSummary(table));
            }
        };
    }

    private String getSummary(StarTable table) throws IOException {
        int ncol = table.getColumnCount();
        long nrow = table.getRowCount();
        if (nrow < 0L) {
            RowRunner runner = this.isParallel_ ? RowRunner.DEFAULT : RowRunner.SEQUENTIAL;
            nrow = ((long[])runner.collect((RowCollector)new CountCollector(), table))[0];
        }
        return "columns: " + ncol + "   rows: " + nrow;
    }

    private static class CountCollector
    extends RowCollector<long[]> {
        private CountCollector() {
        }

        public long[] createAccumulator() {
            return new long[1];
        }

        public long[] combine(long[] acc1, long[] acc2) {
            return new long[]{acc1[0] + acc2[0]};
        }

        public void accumulateRows(RowSplittable rseq, long[] acc) throws IOException {
            long nrow = 0L;
            while (rseq.next()) {
                ++nrow;
            }
            acc[0] = acc[0] + nrow;
        }
    }
}

