/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import gnu.jel.CompilationException;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.jel.JELTable;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinListCollector;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.util.DataBufferedOutputStream;
import uk.ac.starlink.util.Destination;

public class CubeWriter
implements TableConsumer {
    private final double[] loBounds_;
    private final double[] hiBounds_;
    private final String[] colExprs_;
    private final String scaleExpr_;
    private final Combiner combiner_;
    private final Class<?> outType_;
    private final Destination dest_;
    private int[] nbins_;
    private double[] binSizes_;

    public CubeWriter(double[] loBounds, double[] hiBounds, int[] nbins, double[] binSizes, String[] colExprs, String scaleExpr, Combiner combiner, Destination dest, Class<?> outType) {
        this.loBounds_ = loBounds;
        this.hiBounds_ = hiBounds;
        this.nbins_ = nbins;
        this.binSizes_ = binSizes;
        this.colExprs_ = colExprs;
        this.scaleExpr_ = scaleExpr;
        this.combiner_ = combiner;
        this.dest_ = dest;
        this.outType_ = outType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(StarTable inTable) throws IOException {
        int i;
        StarTable asTable;
        int ndim = this.colExprs_.length;
        String[] exprs = new String[ndim + 1];
        System.arraycopy(this.colExprs_, 0, exprs, 0, ndim);
        exprs[ndim] = this.scaleExpr_ == null ? "1" : this.scaleExpr_;
        try {
            asTable = JELTable.createJELTable(inTable, exprs);
        }
        catch (CompilationException e) {
            throw new IOException("Bad expression " + e.getMessage());
        }
        int[] icData = new int[ndim];
        for (int ic = 0; ic < ndim; ++ic) {
            icData[ic] = ic;
        }
        ColumnPermutedStarTable aTable = new ColumnPermutedStarTable(asTable, icData);
        CubeWriter.fixBounds((StarTable)aTable, this.loBounds_, this.hiBounds_);
        if (this.binSizes_ == null) {
            assert (this.nbins_ != null);
            this.binSizes_ = new double[ndim];
            for (i = 0; i < ndim; ++i) {
                this.binSizes_[i] = (this.hiBounds_[i] - this.loBounds_[i]) / (double)this.nbins_[i];
            }
        } else if (this.nbins_ == null) {
            assert (this.binSizes_ != null);
            this.nbins_ = new int[ndim];
            for (i = 0; i < ndim; ++i) {
                this.nbins_[i] = (int)Math.ceil((this.hiBounds_[i] - this.loBounds_[i]) / this.binSizes_[i]);
            }
        }
        double[] cube = CubeWriter.calculateCube(asTable, this.combiner_, this.loBounds_, this.nbins_, this.binSizes_);
        try (DataBufferedOutputStream out = new DataBufferedOutputStream(this.dest_.createStream());){
            this.writeFits((ValueInfo[])Tables.getColumnInfos((StarTable)aTable), (ValueInfo)asTable.getColumnInfo(ndim), cube, this.outType_, out);
            out.flush();
        }
    }

    private static void fixBounds(StarTable table, double[] loBounds, double[] hiBounds) throws IOException {
        int ndim = table.getColumnCount();
        boolean autobound = false;
        for (int idim = 0; idim < ndim; ++idim) {
            autobound = autobound || Double.isNaN(loBounds[idim]) || Double.isNaN(hiBounds[idim]);
        }
        if (autobound) {
            double[][] dataBounds = CubeWriter.getDataBounds(table);
            for (int idim = 0; idim < ndim; ++idim) {
                if (Double.isNaN(loBounds[idim])) {
                    loBounds[idim] = dataBounds[idim][0];
                }
                if (Double.isNaN(hiBounds[idim])) {
                    hiBounds[idim] = dataBounds[idim][1];
                }
                if (!Double.isNaN(loBounds[idim]) && !Double.isNaN(hiBounds[idim])) continue;
                throw new IOException("Can't get bounds for " + table.getColumnInfo(idim).getName() + " - no data?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[][] getDataBounds(StarTable table) throws IOException {
        int ndim = table.getColumnCount();
        double[][] bounds = new double[ndim][2];
        for (int idim = 0; idim < ndim; ++idim) {
            bounds[idim] = new double[]{Double.NaN, Double.NaN};
        }
        try (RowSequence rseq = table.getRowSequence();){
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int idim = 0; idim < ndim; ++idim) {
                    double dval;
                    Object cell = row[idim];
                    if (!(cell instanceof Number) || Double.isInfinite(dval = ((Number)cell).doubleValue()) || Double.isNaN(dval)) continue;
                    if (!(dval >= bounds[idim][0])) {
                        bounds[idim][0] = dval;
                    }
                    if (dval <= bounds[idim][1]) continue;
                    bounds[idim][1] = dval;
                }
            }
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] calculateCube(StarTable table, Combiner combiner, double[] loBounds, int[] nbins, double[] binSizes) throws IOException {
        int ndim = table.getColumnCount() - 1;
        double[] hiBounds = new double[ndim];
        double binExtent = 1.0;
        for (int idim = 0; idim < ndim; ++idim) {
            hiBounds[idim] = loBounds[idim] + (double)nbins[idim] * binSizes[idim];
            binExtent *= binSizes[idim];
        }
        Combiner.Type ctype = combiner.getType();
        double binFactor = ctype.getBinFactor(binExtent);
        long np = 1L;
        for (int idim = 0; idim < ndim; ++idim) {
            np *= (long)nbins[idim];
        }
        int npix = Tables.checkedLongToInt((long)np);
        BinList binList = BinListCollector.createDefaultBinList(combiner, np);
        try (RowSequence rseq = table.getRowSequence();){
            int[] coords = new int[ndim];
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                Object scaleObj = row[ndim];
                double scale = scaleObj instanceof Number ? ((Number)scaleObj).doubleValue() : Double.NaN;
                boolean okRow = scale != 0.0 && !Double.isNaN(scale);
                for (int idim = 0; okRow && idim < ndim; ++idim) {
                    double dval;
                    boolean okCell = false;
                    Object cell = row[idim];
                    if (cell instanceof Number && (dval = ((Number)cell).doubleValue()) >= loBounds[idim] && dval <= hiBounds[idim]) {
                        int ibin = (int)((dval - loBounds[idim]) / binSizes[idim]);
                        if (ibin == nbins[idim]) {
                            --ibin;
                        }
                        assert (ibin >= 0 && ibin <= nbins[idim]);
                        coords[idim] = ibin;
                        okCell = true;
                    }
                    okRow = okRow && okCell;
                }
                if (!okRow) continue;
                int ipix = 0;
                int step = 1;
                for (int idim = 0; idim < ndim; ++idim) {
                    ipix += step * coords[idim];
                    step *= nbins[idim];
                }
                binList.submitToBin(ipix, scale);
            }
        }
        BinList.Result result = binList.getResult();
        double[] cube = new double[npix];
        if (!ctype.isExtensive()) {
            Arrays.fill(cube, Double.NaN);
        }
        Iterator<Long> it = result.indexIterator();
        while (it.hasNext()) {
            int index = it.next().intValue();
            cube[index] = result.getBinValue(index) * binFactor;
        }
        return cube;
    }

    private void writeFits(ValueInfo[] axInfos, ValueInfo binInfo, double[] cube, Class<?> outType, DataBufferedOutputStream out) throws IOException {
        int npix = cube.length;
        int ndim = this.nbins_.length;
        double min = Double.NaN;
        double max = Double.NaN;
        boolean isInt = true;
        boolean hasBlank = false;
        if (npix > 0) {
            for (int i = 0; i < npix; ++i) {
                double datum = cube[i];
                if (!(datum >= min)) {
                    min = datum;
                }
                if (!(datum <= max)) {
                    max = datum;
                }
                boolean isNaN = Double.isNaN(datum);
                hasBlank = hasBlank || isNaN;
                isInt = isInt && (isNaN || (double)((int)datum) == datum);
            }
        }
        if (Double.isNaN(min)) assert (max == Double.NaN);
        Class<Object> clazz = outType;
        if (clazz == null) {
            if (Double.isNaN(min)) {
                clazz = Byte.TYPE;
            } else if (isInt) {
                if (min >= -127.0 && max <= 127.0) {
                    clazz = Byte.TYPE;
                } else if (min >= -32767.0 && max <= 32767.0) {
                    clazz = Short.TYPE;
                } else if (min >= -2.147483647E9 && max <= 2.147483647E9) {
                    clazz = Integer.TYPE;
                }
            }
        }
        if (clazz == null) {
            clazz = Double.TYPE;
        }
        NumberWriter writer = CubeWriter.createNumberWriter((DataOutput)out, clazz);
        CardFactory cf = CardFactory.STRICT;
        ArrayList<CardImage> cards = new ArrayList<CardImage>();
        cards.addAll(Arrays.asList(cf.createLogicalCard("SIMPLE", true, null), cf.createIntegerCard("BITPIX", (long)writer.getBitpix(), "Data type"), cf.createIntegerCard("NAXIS", (long)this.nbins_.length, "Number of axes")));
        for (int id = 0; id < ndim; ++id) {
            cards.add(cf.createIntegerCard("NAXIS" + (id + 1), (long)this.nbins_[id], "Dimension " + (id + 1)));
        }
        String isoDate = Times.mjdToIso(Times.unixMillisToMjd(System.currentTimeMillis()));
        cards.add(cf.createStringCard("DATE", isoDate, "HDU creation date"));
        cards.add(cf.createStringCard("BUNIT", "COUNTS", "Number of points per pixel (bin)"));
        if (hasBlank && writer.blank_ != 0L) {
            cards.add(cf.createIntegerCard("BLANK", writer.blank_, "Blank value"));
        }
        if (!Double.isNaN(min) && !Double.isNaN(max)) {
            cards.add(cf.createRealCard("DATAMIN", min, "Minimum value"));
            cards.add(cf.createRealCard("DATAMAX", max, "Maximum value"));
        }
        for (int id = 0; id < ndim; ++id) {
            int id1 = id + 1;
            String pd1 = " (" + id1 + ")";
            ValueInfo info = axInfos[id];
            String units = info.getUnitString();
            String desc = info.getDescription();
            cards.add(cf.createStringCard("CTYPE" + id1, info.getName(), desc));
            if (units != null) {
                cards.add(cf.createStringCard("CUNIT" + id1, units, "Units"));
            }
            cards.add(cf.createRealCard("CRVAL" + id1, 0.0, "Reference pixel position" + pd1));
            cards.add(cf.createRealCard("CDELT" + id1, this.binSizes_[id], "Reference pixel extent" + pd1));
            cards.add(cf.createRealCard("CRPIX" + id1, -this.loBounds_[id] / this.binSizes_[id], "Reference pixel index" + pd1));
        }
        cards.add(cf.createStringCard("ORIGIN", "STILTS version " + Stilts.getVersion() + " (" + this.getClass().getName() + ")", null));
        cards.add(CardFactory.END_CARD);
        FitsUtil.writeHeader((CardImage[])cards.toArray(new CardImage[0]), (OutputStream)out);
        for (int ip = 0; ip < npix; ++ip) {
            writer.writeNumber(cube[ip]);
        }
        long nbyte = (long)(Math.abs(writer.getBitpix()) / 8) * (long)npix;
        int over = (int)(nbyte % 2880L);
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
    }

    public static NumberWriter createNumberWriter(final DataOutput out, Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return new NumberWriter(8, -128L){

                @Override
                public void writeNumber(double value) throws IOException {
                    out.writeByte(Double.isNaN(value) ? (byte)this.blank_ : (byte)value);
                }
            };
        }
        if (clazz == Short.TYPE) {
            return new NumberWriter(16, -32768L){

                @Override
                public void writeNumber(double value) throws IOException {
                    out.writeShort(Double.isNaN(value) ? (short)this.blank_ : (short)value);
                }
            };
        }
        if (clazz == Integer.TYPE) {
            return new NumberWriter(32, Integer.MIN_VALUE){

                @Override
                public void writeNumber(double value) throws IOException {
                    out.writeInt(Double.isNaN(value) ? (int)this.blank_ : (int)value);
                }
            };
        }
        if (clazz == Long.TYPE) {
            return new NumberWriter(64, Long.MIN_VALUE){

                @Override
                public void writeNumber(double value) throws IOException {
                    out.writeLong(Double.isNaN(value) ? this.blank_ : (long)value);
                }
            };
        }
        if (clazz == Float.TYPE) {
            return new NumberWriter(-32, 0L){

                @Override
                public void writeNumber(double value) throws IOException {
                    out.writeFloat((float)value);
                }
            };
        }
        if (clazz == Double.TYPE) {
            return new NumberWriter(-64, 0L){

                @Override
                public void writeNumber(double value) throws IOException {
                    out.writeDouble(value);
                }
            };
        }
        assert (false);
        return new NumberWriter(64, 0L){

            @Override
            public void writeNumber(double value) throws IOException {
                out.writeDouble(value);
            }
        };
    }

    private static class UnitColumnData
    extends ColumnData {
        private final Integer unit_ = 1;

        UnitColumnData() {
            super((ValueInfo)new DefaultValueInfo("Counts", Integer.class));
        }

        public Object readValue(long irow) {
            return this.unit_;
        }
    }

    private static abstract class NumberWriter {
        private final int bitpix_;
        final long blank_;

        protected NumberWriter(int bitpix, long blank) {
            this.bitpix_ = bitpix;
            this.blank_ = blank;
        }

        public abstract void writeNumber(double var1) throws IOException;

        public int getBitpix() {
            return this.bitpix_;
        }
    }
}

