/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import java.sql.SQLException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.table.jdbc.WriteMode;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.task.LineTableEnvironment;

public class JdbcConsumer
implements TableConsumer {
    private final String url_;
    private final JDBCHandler handler_;
    private final WriteMode mode_;

    public JdbcConsumer(String url, JDBCHandler handler, WriteMode mode) {
        this.url_ = url;
        this.handler_ = handler;
        this.mode_ = mode;
    }

    public JdbcConsumer(String url, Environment env, WriteMode mode) {
        this(url, new JDBCHandler(LineTableEnvironment.getJdbcAuthenticator(env)), mode);
    }

    @Override
    public void consume(StarTable table) throws IOException {
        try {
            this.handler_.createJDBCTable(table, this.url_, this.mode_);
        }
        catch (SQLException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "SQL error";
            }
            throw (IOException)new IOException(msg).initCause(e);
        }
    }
}

